/* Bitmaps and things for scrollbars.
   Copyright (C) 1989 Free Software Foundation.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


static void install_vertical_scrollbar ();
static void install_horizontal_scrollbar ();
static void x_set_horizontal_scrollbar ();
static void x_set_vertical_scrollbar ();

/* Prefix-characters for scroll bar commands in Vglobal_mouse_map.
   Choice of prefix depends on which region of the scroll bar.  */

enum scroll_bar_prefix
  { VSCROLL_BAR_PREFIX = 050, VSCROLL_SLIDER_PREFIX /* unused */,
    VSCROLL_THUMBUP_PREFIX, VSCROLL_THUMBDOWN_PREFIX,
    HSCROLL_BAR_PREFIX, HSCROLL_SLIDER_PREFIX /* unused */,
    HSCROLL_THUMBLEFT_PREFIX, HSCROLL_THUMBRIGHT_PREFIX };

#define CROSS_WIDTH 16
#define CROSS_HEIGHT 16

#define CROSS_MASK_WIDTH 16
#define CROSS_MASK_HEIGHT 16

/* Vertical and Horizontal scroll bar widths. */
#define VSCROLL_WIDTH 18
#define HSCROLL_HEIGHT 18

#ifdef HAVE_X11

/* Arrow cursors for scroll bars.  */

Cursor up_arrow_cursor, down_arrow_cursor, v_double_arrow_cursor;
Cursor left_arrow_cursor, right_arrow_cursor, h_double_arrow_cursor;

static char cross_bits[] =
 {
   0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
   0x80, 0x01, 0xfe, 0x7f, 0xfe, 0x7f, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
   0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00
 };

static char gray_bits[] =
 {
   0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
   0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
   0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
   0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa
 };

static char up_arrow_bits[] =
  {
    0x00, 0x00, 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f, 0xf8, 0x1f,
    0xfc, 0x3f, 0xfe, 0x7f, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
    0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xff, 0xff
  };

static char down_arrow_bits[] =
  {
    0xff, 0xff, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
    0x80, 0x01, 0x80, 0x01, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0x0f,
    0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01, 0x00, 0x00
  };

static char left_arrow_bits[] =
  {
    0x00, 0x80, 0x80, 0x80, 0xc0, 0x80, 0xe0, 0x80, 0xf0, 0x80, 0xf8, 0x80,
    0xfc, 0x80, 0xfe, 0xff, 0xfe, 0xff, 0xfc, 0x80, 0xf8, 0x80, 0xf0, 0x80,
    0xe0, 0x80, 0xc0, 0x80, 0x80, 0x80, 0x00, 0x80
  };

static char right_arrow_bits[] =
  {
    0x01, 0x00, 0x01, 0x01, 0x01, 0x03, 0x01, 0x07, 0x01, 0x0f, 0x01, 0x1f,
    0x01, 0x3f, 0xff, 0x7f, 0xff, 0x7f, 0x01, 0x3f, 0x01, 0x1f, 0x01, 0x0f,
    0x01, 0x07, 0x01, 0x03, 0x01, 0x01, 0x01, 0x00
  };

static char cross_mask_bits[] =
 {
   0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x03, 0xc0, 0x03,
   0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03
 };
#else /* not HAVE_X11 */
static short cross_bits[] =
  {
    0x0000, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0180, 0x7ffe,
    0x7ffe, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0180, 0x0000,
  };

static short gray_bits[] = {
    0xaaaa, 0x5555, 0xaaaa, 0x5555,
    0xaaaa, 0x5555, 0xaaaa, 0x5555,
    0xaaaa, 0x5555, 0xaaaa, 0x5555,
    0xaaaa, 0x5555, 0xaaaa, 0x5555};

static short cross_mask_bits[] =
  {
    0x03c0, 0x03c0, 0x03c0, 0x03c0,
    0x03c0, 0x03c0, 0xffff, 0xffff,
    0xffff, 0xffff, 0x03c0, 0x03c0,
    0x03c0, 0x03c0, 0x03c0, 0x03c0,
  };
#endif /* X10 */
