;;; idlw-rinfo.el --- Routine Information for IDLWAVE
;; Copyright (c) 1999, 2000 Free Software Foundation

;; Author: John-David Smith <jdsmith@astro.cornell.edu>
;; Version: 4.7
;; Keywords: languages

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; The constants which contain information about IDLs builtin
;; functions, procedures, system variables and class tags.  This
;; information is extracted automatically from the IDL documentation
;; and by talking to IDL.
;;
;; Created by get_rinfo54 on Fri Dec  8 14:06:41 2000
;; IDL version: 5.4
;; Number of files scanned:  5
;;       943 syntax entries in file refguide.txt
;;       327 syntax entries in file sdf.txt
;;         0 syntax entries in file datamine.txt
;;         6 syntax entries in file edg.txt
;;        45 syntax entries in file obsolete.txt
;; Number of routines found: 1287
;; Number of keywords found: 5724

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Code:

(defconst idlwave-system-routines
  '(
    ("ANNOTATE"               pro nil                 (system) "%s" (("COLOR_INDICES") ("DRAWABLE") ("LOAD_FILE") ("TEK_COLORS") ("WINDOW")))
    ("ARROW"                  pro nil                 (system) "%s, X0, Y0, X1, Y1" (("COLOR") ("DATA") ("HSIZE") ("HTHICK") ("NORMALIZED") ("SOLID") ("THICK")))
    ("AXIS"                   pro nil                 (system) "%s [, X [, Y [, Z]]]" (("CHARSIZE") ("CHARTHICK") ("COLOR") ("DATA") ("DEVICE") ("FONT") ("NODATA") ("NOERASE") ("NORMAL") ("SAVE") ("SUBTITLE") ("T3D") ("TICKLEN") ("XAXIS") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICK_GET") ("XTICKFORMAT") ("XTICKINTERVAL") ("XTICKLAYOUT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKUNITS") ("XTICKV") ("XTITLE") ("YAXIS") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YNOZERO") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICK_GET") ("YTICKFORMAT") ("YTICKINTERVAL") ("YTICKLAYOUT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKUNITS") ("YTICKV") ("YTITLE") ("ZAXIS") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZLOG") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICK_GET") ("ZTICKFORMAT") ("ZTICKINTERVAL") ("ZTICKLAYOUT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKUNITS") ("ZTICKV") ("ZTITLE") ("ZVALUE")))
    ("BAR_PLOT"               pro nil                 (system) "%s, Values" (("BACKGROUND") ("BARNAMES") ("BAROFFSET") ("BARSPACE") ("BARWIDTH") ("BASELINES") ("BASERANGE") ("COLORS") ("OUTLINE") ("OVERPLOT") ("ROTATE") ("TITLE") ("XTITLE") ("YTITLE")))
    ("BLAS_AXPY"              pro nil                 (system) "%s, Y, A, X [, D1, Loc1 [, D2, Range]]" nil)
    ("BOX_CURSOR"             pro nil                 (system) "%s, [ X0, Y0, NX, NY]" (("FIXED_SIZE") ("INIT") ("MESSAGE")))
    ("BREAKPOINT"             pro nil                 (system) "%s [, File], Index" (("AFTER") ("CLEAR") ("CONDITION") ("DISABLE") ("ENABLE") ("ONCE") ("SET")))
    ("BYTEORDER"              pro nil                 (system) "%s, Variable1, ..., Variablen" (("DTOGFLOAT") ("DTOVAX") ("DTOXDR") ("FTOVAX") ("FTOXDR") ("GFLOATTOD") ("HTONL") ("HTONS") ("L64SWAP") ("LSWAP") ("NTOHL") ("NTOHS") ("SSWAP") ("SWAP_IF_BIG_ENDIAN") ("SWAP_IF_LITTLE_ENDIAN") ("VAXTOD") ("VAXTOF") ("XDRTOD") ("XDRTOF")))
    ("CALDAT"                 pro nil                 (system) "%s, Julian, Month [, Day [, Year [, Hour [, Minute [, Second]]]]]" nil)
    ("CALENDAR"               pro nil                 (system) "%s [[, Month] , Year]" nil)
    ("CALL_METHOD"            pro nil                 (system) "%s, Name, ObjRef, [, P1, ..., Pn]" nil)
    ("CALL_PROCEDURE"         pro nil                 (system) "%s, Name [, P1, ..., Pn]" nil)
    ("CATCH"                  pro nil                 (system) "%s, Variable" (("CANCEL")))
    ("CD"                     pro nil                 (system) "%s [, Directory]" (("CURRENT")))
    ("CDF_ATTDELETE"          pro nil                 (system) "%s, Id, Attribute [, EntryNum]" (("ZVARIABLE")))
    ("CDF_ATTGET"             pro nil                 (system) "%s, Id, Attribute, EntryNum, Value" (("CDF_TYPE") ("ZVARIABLE")))
    ("CDF_ATTINQ"             pro nil                 (system) "%s, Id, Attribute, Name, Scope, MaxEntry [, MaxZEntry]" nil)
    ("CDF_ATTPUT"             pro nil                 (system) "%s, Id, Attribute, EntryNum, Value" (("ZVARIABLE")))
    ("CDF_ATTRENAME"          pro nil                 (system) "%s, Id, OldAttr, NewName" nil)
    ("CDF_CLOSE"              pro nil                 (system) "%s, Id" nil)
    ("CDF_COMPRESSION"        pro nil                 (system) "%s, Id" (("GET_COMPRESSION") ("GET_GZIP_LEVEL") ("GET_VAR_COMPRESSION") ("GET_VAR_GZIP_LEVEL") ("SET_COMPRESSION") ("SET_GZIP_LEVEL") ("SET_VAR_COMPRESSION") ("SET_VAR_GZIP_LEVEL") ("VARIABLE") ("ZVARIABLE")))
    ("CDF_CONTROL"            pro nil                 (system) "%s, Id" (("ATTRIBUTE") ("GET_ATTR_INFO") ("GET_CACHESIZE") ("GET_COPYRIGHT") ("GET_FILENAME") ("GET_FORMAT") ("GET_NEGTOPOSFP0_MODE") ("GET_NUMATTRS") ("GET_READONLY_MODE") ("GET_RVAR_CACHESIZE") ("GET_VAR_INFO") ("GET_ZMODE") ("GET_ZVAR_CACHESIZE") ("SET_CACHESIZE") ("SET_EXTENDRECS") ("SET_INITIALRECS") ("SET_NEGTOPOSFP0_MODE") ("SET_PADVALUE") ("SET_READONLY_MODE") ("SET_RVAR_CACHESIZE") ("SET_RVARS_CACHESIZE") ("SET_ZMODE") ("SET_ZVAR_CACHESIZE") ("SET_ZVARS_CACHESIZE") ("VARIABLE") ("ZVARIABLE")))
    ("CDF_DELETE"             pro nil                 (system) "%s, Id" nil)
    ("CDF_DOC"                pro nil                 (system) "%s, Id, Version, Release, Copyright" (("INCREMENT")))
    ("CDF_EPOCH"              pro nil                 (system) "%s, Epoch, Year [, Month, Day, Hour, Minute, Second, Milli]" (("BREAKDOWN_EPOCH") ("COMPUTE_EPOCH")))
    ("CDF_LIB_INFO"           pro nil                 (system) "%s" (("COPYRIGHT") ("INCREMENT") ("RELEASE") ("SUBINCREMENT") ("VERSION")))
    ("CDF_VARDELETE"          pro nil                 (system) "%s, Id, Variable" (("ZVARIABLE")))
    ("CDF_VARGET"             pro nil                 (system) "%s, Id, Variable, Value" (("COUNT") ("INTERVAL") ("OFFSET") ("REC_COUNT") ("REC_INTERVAL") ("REC_START") ("STRING") ("ZVARIABLE")))
    ("CDF_VARGET1"            pro nil                 (system) "%s, Id, Variable, Value" (("OFFSET") ("REC_START") ("STRING") ("ZVARIABLE")))
    ("CDF_VARPUT"             pro nil                 (system) "%s, Id, Variable, Value" (("COUNT") ("INTERVAL") ("OFFSET") ("REC_INTERVAL") ("REC_START") ("ZVARIABLE")))
    ("CDF_VARRENAME"          pro nil                 (system) "%s, Id, OldVariable, NewName" (("ZVARIABLE")))
    ("CHOLDC"                 pro nil                 (system) "%s, A, P" (("DOUBLE")))
    ("CIR_3PNT"               pro nil                 (system) "%s, X, Y, R, X0, Y0" nil)
    ("CLOSE"                  pro nil                 (system) "%s[, Unit1, ..., Unitn]" (("ALL") ("EXIT_STATUS") ("FILE") ("FORCE")))
    ("COLOR_CONVERT"          pro nil                 (system) "%s, I0, I1, I2, O0, O1, O2" (("HLS_RGB") ("HSV_RGB") ("RGB_HLS") ("RGB_HSV")))
    ("COMMON"                 pro nil                 (system) "%s VOLUME_DATA, A" (("A")))
    ("CONSTRAINED_MIN"        pro nil                 (system) "%s, X, Xbnd, Gbnd, Nobj, Gcomp, Inform" (("ESPTOP") ("LIMSER") ("MAXIMIZE") ("NSTOP") ("REPORT") ("TITLE")))
    ("CONTOUR"                pro nil                 (system) "%s, Z [, X, Y]" (("BACKGROUND") ("C_ANNOTATION") ("C_CHARSIZE") ("C_CHARTHICK") ("C_COLORS") ("C_LABELS") ("C_LINESTYLE") ("C_ORIENTATION") ("C_SPACING") ("C_THICK") ("CELL_FILL") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("CLOSED") ("COLOR") ("DATA") ("DEVICE") ("DOWNHILL") ("FILL") ("FOLLOW") ("FONT") ("IRREGULAR") ("LEVELS") ("MAX_VALUE") ("MIN_VALUE") ("NLEVELS") ("NOCLIP") ("NODATA") ("NOERASE") ("NORMAL") ("NSUM") ("OVERPLOT") ("PATH_DATA_COORDS") ("PATH_DOUBLE") ("PATH_FILENAME") ("PATH_INFO") ("PATH_XY") ("POLAR") ("POSITION") ("SUBTITLE") ("T3D") ("THICK") ("TICKLEN") ("TITLE") ("TRIANGULATION") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICK_GET") ("XTICKFORMAT") ("XTICKINTERVAL") ("XTICKLAYOUT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKUNITS") ("XTICKV") ("XTITLE") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YNOZERO") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICK_GET") ("YTICKFORMAT") ("YTICKINTERVAL") ("YTICKLAYOUT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKUNITS") ("YTICKV") ("YTITLE") ("ZAXIS") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZLOG") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICK_GET") ("ZTICKFORMAT") ("ZTICKINTERVAL") ("ZTICKLAYOUT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKUNITS") ("ZTICKV") ("ZTITLE") ("ZVALUE")))
    ("CREATE_VIEW"            pro nil                 (system) "%s" (("AX") ("AY") ("AZ") ("PERSP") ("RADIANS") ("WINX") ("WINY") ("XMAX") ("XMIN") ("YMAX") ("YMIN") ("ZFAC") ("ZMAX") ("ZMIN") ("ZOOM")))
    ("CURSOR"                 pro nil                 (system) "%s, X, Y [, Wait]" (("CHANGE") ("DATA") ("DEVICE") ("DOWN") ("NORMAL") ("NOWAIT") ("UP") ("WAIT")))
    ("CW_ANIMATE_GETP"        pro nil                 (system) "%s, Widget, Pixmaps" (("KILL_ANYWAY")))
    ("CW_ANIMATE_LOAD"        pro nil                 (system) "%s, Widget" (("CYCLE") ("FRAME") ("IMAGE") ("ORDER") ("WINDOW") ("XOFFSET") ("YOFFSET")))
    ("CW_ANIMATE_RUN"         pro nil                 (system) "%s, Widget [, Rate{0 to 100}]" (("NFRAMES") ("STOP")))
    ("CW_LIGHT_EDITOR_GET"    pro nil                 (system) "%s, WidgetID" (("DIRECTION_DISABLED") ("DRAG_EVENTS") ("HIDE_DISABLED") ("LIGHT") ("LOCATION_DISABLED") ("TYPE_DISABLED") ("XRANGE") ("XSIZE") ("YRANGE") ("YSIZE") ("ZRANGE")))
    ("CW_LIGHT_EDITOR_SET"    pro nil                 (system) "%s, WidgetID" (("DIRECTION_DISABLED") ("DRAG_EVENTS") ("HIDE_DISABLED") ("LIGHT") ("LOCATION_DISABLED") ("TYPE_DISABLED") ("XRANGE") ("XSIZE") ("YRANGE") ("YSIZE") ("ZRANGE")))
    ("CW_PALETTE_EDITOR_GET"  pro nil                 (system) "%s, WidgetID" (("ALPHA") ("HISTOGRAM")))
    ("CW_PALETTE_EDITOR_SET"  pro nil                 (system) "%s, WidgetID" (("ALPHA") ("HISTOGRAM")))
    ("DEFINE_KEY"             pro nil                 (system) "%s, Key [, Value]" (("BACK_CHARACTER") ("BACK_WORD") ("CONTROL") ("DELETE_CHARACTER") ("DELETE_CURRENT") ("DELETE_EOL") ("DELETE_LINE") ("DELETE_WORD") ("END_OF_FILE") ("END_OF_LINE") ("ENTER_LINE") ("ESCAPE") ("FORWARD_CHARACTER") ("FORWARD_WORD") ("INSERT_OVERSTRIKE_TOGGLE") ("MATCH_PREVIOUS") ("NEXT_LINE") ("NOECHO") ("PREVIOUS_LINE") ("RECALL") ("REDRAW") ("START_OF_LINE") ("TERMINATE")))
    ("DEFSYSV"                pro nil                 (system) "%s, Name, Value [, Read_Only]" (("EXISTS")))
    ("DELETE_SYMBOL"          pro nil                 (system) "%s, Name" (("TYPE")))
    ("DELLOG"                 pro nil                 (system) "%s, Lognam" (("TABLE")))
    ("DELVAR"                 pro nil                 (system) "%s, V1, ..., Vn" nil)
    ("DEVICE"                 pro nil                 (system) "%s" (("AVANTGARDE") ("AVERAGE_LINES") ("BINARY") ("BITS_PER_PIXEL") ("BKMAN") ("BOLD") ("BOOK") ("BYPASS_TRANSLATION") ("CLOSE") ("CLOSE_DOCUMENT") ("CLOSE_FILE") ("COLOR") ("COLORS") ("COPY") ("COURIER") ("CURSOR_CROSSHAIR") ("CURSOR_IMAGE") ("CURSOR_MASK") ("CURSOR_ORIGINAL") ("CURSOR_STANDARD") ("CURSOR_XY") ("DECOMPOSED") ("DEMI") ("DEPTH") ("DIRECT_COLOR") ("EJECT") ("ENCAPSULATED") ("ENCODING") ("FILENAME") ("FLOYD") ("FONT_INDEX") ("FONT_SIZE") ("GET_CURRENT_FONT") ("GET_DECOMPOSED") ("GET_FONTNAMES") ("GET_FONTNUM") ("GET_GRAPHICS_FUNCTION") ("GET_PAGESIZE") ("GET_SCREEN_SIZE") ("GET_VISUAL_DEPTH") ("GET_VISUAL_NAME") ("GET_WINDOW_POSITION") ("GET_WRITE_MASK") ("GIN_CHARS") ("GLYPH_CACHE") ("HELVETICA") ("INCHES") ("INDEX_COLOR") ("ISOLATIN1") ("ITALIC") ("LANDSCAPE") ("LIGHT") ("MEDIUM") ("NARROW") ("NCAR") ("OBLIQUE") ("OPTIMIZE") ("ORDERED") ("OUTPUT") ("PALATINO") ("PIXELS") ("PLOT_TO") ("PLOTTER_ON_OFF") ("POLYFILL") ("PORTRAIT") ("PRE_DEPTH") ("PRE_XSIZE") ("PRE_YSIZE") ("PREVIEW") ("PRINT_FILE") ("PSEUDO_COLOR") ("RESET_STRING") ("RESOLUTION") ("RETAIN") ("SCALE_FACTOR") ("SCHOOLBOOK") ("SET_CHARACTER_SIZE") ("SET_COLORMAP") ("SET_COLORS") ("SET_FONT") ("SET_GRAPHICS_FUNCTION") ("SET_RESOLUTION") ("SET_STRING") ("SET_TRANSLATION") ("SET_WRITE_MASK") ("STATIC_COLOR") ("STATIC_GRAY") ("SYMBOL") ("TEK4014") ("TEK4100") ("TEXT") ("THRESHOLD") ("TIMES") ("TRANSLATION") ("TRUE_COLOR") ("TT_FONT") ("TTY") ("VT240") ("VT241") ("VT340") ("VT341") ("WINDOW_STATE") ("XOFFSET") ("XON_XOFF") ("XSIZE") ("YOFFSET") ("YSIZE") ("Z_BUFFERING") ("ZAPFCHANCERY") ("ZAPFDINGBATS")))
    ("DFPMIN"                 pro nil                 (system) "%s, X, Gtol, Fmin, Func, Dfunc" (("DOUBLE") ("EPS") ("ITER") ("ITMAX") ("STEPMAX") ("TOLX")))
    ("DISSOLVE"               pro nil                 (system) "%s, Image" (("ORDER") ("SIZ") ("WAIT") ("X0") ("Y0")))
    ("DLM_LOAD"               pro nil                 (system) "%s, DLMNameStr1 [, DLMNameStr2,..., DLMNameStrn]" nil)
    ("DLM_REGISTER"           pro nil                 (system) "%s, DLMDefFilePath1 [, DLMDefFilePath2, ..., DLMDefFilePathn]" nil)
    ("DO_APPLE_SCRIPT"        pro nil                 (system) "%s, Script" (("AG_STRING") ("RESULT")))
    ("DOC_LIBRARY"            pro nil                 (system) "%s [, Name]" (("DIRECTORY") ("FILE") ("MULTI") ("OUTPUTS") ("PATH") ("PRINT")))
    ("DRAW_ROI"               pro nil                 (system) "%s, oROI" (("CLIP") ("COLOR") ("DATA") ("DEVICE") ("LINE_FILL") ("LINESTYLE") ("NOCLIP") ("NORMAL") ("ORIENTATION") ("PSYM") ("SPACING") ("SYMSIZE") ("T3D") ("THICK")))
    ("EFONT"                  pro nil                 (system) "%s [, Init_Font]" (("BLOCK") ("GROUP")))
    ("EMPTY"                  pro nil                 (system) "%s" nil)
    ("ENABLE_SYSRTN"          pro nil                 (system) "%s [, Routines]" (("DISABLE") ("EXCLUSIVE") ("FUNCTIONS")))
    ("ERASE"                  pro nil                 (system) "%s [, Background_Color]" (("CHANNEL") ("COLOR")))
    ("ERRPLOT"                pro nil                 (system) "%s, [ X, ] Low, High" (("WIDTH")))
    ("EXIT"                   pro nil                 (system) "%s" (("NO_CONFIRM") ("STATUS")))
    ("EXPAND"                 pro nil                 (system) "%s, A, Nx, Ny, Result" (("FILLVAL") ("MAXVAL")))
    ("FILE_CHMOD"             pro nil                 (system) "%s, File [, Mode]" (("A_EXECUTE") ("A_READ") ("A_WRITE") ("G_EXECTUE") ("G_READ") ("G_WRITE") ("O_EXECTUE") ("O_READ") ("O_WRITE") ("SETGID") ("SETUID") ("STICKY_BIT") ("U_EXECTUE") ("U_READ") ("U_WRITE")))
    ("FILE_DELETE"            pro nil                 (system) "%s, File1 [,... FileN]" (("QUIET")))
    ("FILE_MKDIR"             pro nil                 (system) "%s, File1 [,... FileN]" nil)
    ("FLICK"                  pro nil                 (system) "%s, A, B [, Rate]" nil)
    ("FLOW3"                  pro nil                 (system) "%s, Vx, Vy, Vz" (("ARROWSIZE") ("BLOB") ("LEN") ("NSTEPS") ("NVECS") ("SX") ("SY") ("SZ")))
    ("FLUSH"                  pro nil                 (system) "%s, Unit1, ..., Unitn" nil)
    ("FREE_LUN"               pro nil                 (system) "%s [, Unit1, ..., Unitn]" (("EXIT_STATUS") ("FORCE")))
    ("FUNCT"                  pro nil                 (system) "%s, X, A, F [, Pder]" nil)
    ("GAMMA_CT"               pro nil                 (system) "%s, Gamma" (("CURRENT") ("INTENSITY")))
    ("GET_LUN"                pro nil                 (system) "%s, Unit" nil)
    ("H_EQ_CT"                pro nil                 (system) "%s [, Image]" nil)
    ("H_EQ_INT"               pro nil                 (system) "%s [, Image]" nil)
    ("HANDLE_FREE"            pro nil                 (system) "%s, ID" nil)
    ("HANDLE_MOVE"            pro nil                 (system) "%s, Static_ID, Move_ID" nil)
    ("HANDLE_VALUE"           pro nil                 (system) "%s, ID, Value" nil)
    ("HDF_AN_END"             pro nil                 (system) "%s, an_id" nil)
    ("HDF_AN_ENDACCESS"       pro nil                 (system) "%s, ann_id" nil)
    ("HDF_CLOSE"              pro nil                 (system) "%s, FileHandle" nil)
    ("HDF_DELDD"              pro nil                 (system) "%s, FileHandle, Tag, Ref" nil)
    ("HDF_DF24_ADDIMAGE"      pro nil                 (system) "%s, Filename, Image" (("FORCE_BASELINE") ("JPEG") ("QUALITY") ("RLE")))
    ("HDF_DF24_GETIMAGE"      pro nil                 (system) "%s, Filename, Image" (("LINE") ("PIXEL") ("PLANE")))
    ("HDF_DF24_GETINFO"       pro nil                 (system) "%s, Filename, Width, Height, Interlace" nil)
    ("HDF_DF24_READREF"       pro nil                 (system) "%s, Filename, Refno" nil)
    ("HDF_DF24_RESTART"       pro nil                 (system) "%s" nil)
    ("HDF_DFAN_ADDFDS"        pro nil                 (system) "%s, Filename, Description" nil)
    ("HDF_DFAN_ADDFID"        pro nil                 (system) "%s, Filename, Label" nil)
    ("HDF_DFAN_GETDESC"       pro nil                 (system) "%s, Filename, Tag, Ref, Description" (("STRING")))
    ("HDF_DFAN_GETFDS"        pro nil                 (system) "%s, Filename, Description" (("FIRST") ("STRING")))
    ("HDF_DFAN_GETFID"        pro nil                 (system) "%s, Filename, Label" (("FIRST")))
    ("HDF_DFAN_GETLABEL"      pro nil                 (system) "%s, Filename, Tag, Ref, Label" nil)
    ("HDF_DFAN_PUTDESC"       pro nil                 (system) "%s, Filename, Tag, Ref, Description" nil)
    ("HDF_DFAN_PUTLABEL"      pro nil                 (system) "%s, Filename, Tag, Ref, Label" nil)
    ("HDF_DFP_ADDPAL"         pro nil                 (system) "%s, Filename, Palette" nil)
    ("HDF_DFP_GETPAL"         pro nil                 (system) "%s, Filename, Palette" nil)
    ("HDF_DFP_PUTPAL"         pro nil                 (system) "%s, Filename, Palette" (("DELETE") ("OVERWRITE")))
    ("HDF_DFP_READREF"        pro nil                 (system) "%s, Filename, Refno" nil)
    ("HDF_DFP_RESTART"        pro nil                 (system) "%s" nil)
    ("HDF_DFP_WRITEREF"       pro nil                 (system) "%s, Filename, Refno" nil)
    ("HDF_DFR8_ADDIMAGE"      pro nil                 (system) "%s, Filename, Image" (("FORCE_BASELINE") ("IMCOMP") ("JPEG") ("PALETTE") ("QUALITY") ("RLE")))
    ("HDF_DFR8_GETIMAGE"      pro nil                 (system) "%s, Filename, Image [, Palette]" nil)
    ("HDF_DFR8_GETINFO"       pro nil                 (system) "%s, Filename, Width, Height, Has_Palette" nil)
    ("HDF_DFR8_PUTIMAGE"      pro nil                 (system) "%s, Filename, Image" (("FORCE_BASELINE") ("IMCOMP") ("JPEG") ("PALETTE") ("QUALITY") ("RLE")))
    ("HDF_DFR8_READREF"       pro nil                 (system) "%s, Filename, Refno" nil)
    ("HDF_DFR8_RESTART"       pro nil                 (system) "%s" nil)
    ("HDF_DFR8_SETPALETTE"    pro nil                 (system) "%s, Palette" nil)
    ("HDF_DFSD_ADDDATA"       pro nil                 (system) "%s, Filename, Data" (("OVERWRITE") ("SET_DIM") ("SET_TYPE")))
    ("HDF_DFSD_DIMGET"        pro nil                 (system) "%s, Dimension" (("FORMAT") ("LABEL") ("SCALE") ("UNIT")))
    ("HDF_DFSD_DIMSET"        pro nil                 (system) "%s, Dimension" (("FORMAT") ("LABEL") ("SCALE") ("UNIT")))
    ("HDF_DFSD_ENDSLICE"      pro nil                 (system) "%s" nil)
    ("HDF_DFSD_GETDATA"       pro nil                 (system) "%s, Filename, Data" (("GET_DIMS") ("GET_TYPE")))
    ("HDF_DFSD_GETINFO"       pro nil                 (system) "%s, Filename" (("CALDATA") ("COORDSYS") ("DIMS") ("FORMAT") ("LABEL") ("LASTREF") ("NSDS") ("RANGE") ("TYPE") ("UNIT")))
    ("HDF_DFSD_GETSLICE"      pro nil                 (system) "%s, Filename, Data" (("COUNT") ("OFFSET")))
    ("HDF_DFSD_PUTSLICE"      pro nil                 (system) "%s, Data" (("COUNT")))
    ("HDF_DFSD_READREF"       pro nil                 (system) "%s, Filename, Refno" nil)
    ("HDF_DFSD_SETINFO"       pro nil                 (system) "%s" (("BYTE") ("CALDATA") ("CLEAR") ("COORDSYS") ("DIMS") ("DOUBLE") ("FLOAT") ("FORMAT") ("INT") ("LABEL") ("LEN_COORDSYS") ("LEN_FORMAT") ("LEN_LABEL") ("LEN_UNIT") ("LONG") ("RANGE") ("RESTART") ("UNIT")))
    ("HDF_DFSD_STARTSLICE"    pro nil                 (system) "%s, Filename" nil)
    ("HDF_DUPDD"              pro nil                 (system) "%s, FileHandle, NewTag, NewRef, OldTag, OldRef" nil)
    ("HDF_GR_END"             pro nil                 (system) "%s, gr_id" nil)
    ("HDF_GR_ENDACCESS"       pro nil                 (system) "%s, ri_id" nil)
    ("HDF_LIB_INFO"           pro nil                 (system) "%s, [FileHandle]" (("MAJOR") ("MINOR") ("RELEASE") ("VERSION")))
    ("HDF_SD_ADDDATA"         pro nil                 (system) "%s, SDS_ID, Data" (("COUNT") ("NOREVERSE") ("START") ("STRIDE")))
    ("HDF_SD_ATTRINFO"        pro nil                 (system) "%s, S_ID, Attr_Index" (("COUNT") ("DATA") ("HDF_TYPE") ("NAME") ("TYPE")))
    ("HDF_SD_ATTRSET"         pro nil                 (system) "%s, S_ID, Attr_Name, Values [, Count]" (("BYTE") ("DFNT_CHAR") ("DFNT_FLOAT32") ("DFNT_FLOAT64") ("DFNT_INT16") ("DFNT_INT32") ("DFNT_INT8") ("DFNT_UINT16") ("DFNT_UINT32") ("DFNT_UINT8") ("DOUBLE") ("FLOAT") ("INT") ("LONG") ("SHORT") ("STRING")))
    ("HDF_SD_DIMGET"          pro nil                 (system) "%s, Dim_ID" (("COMPATIBILITY") ("COUNT") ("FORMAT") ("LABEL") ("NAME") ("NATTR") ("SCALE") ("TYPE") ("UNIT")))
    ("HDF_SD_DIMSET"          pro nil                 (system) "%s, Dim_ID" (("BW_INCOMP") ("FORMAT") ("LABEL") ("NAME") ("SCALE") ("UNIT")))
    ("HDF_SD_END"             pro nil                 (system) "%s, SD_ID" nil)
    ("HDF_SD_ENDACCESS"       pro nil                 (system) "%s, SD_ID" nil)
    ("HDF_SD_FILEINFO"        pro nil                 (system) "%s, SD_ID, Datasets, Attributes" nil)
    ("HDF_SD_GETDATA"         pro nil                 (system) "%s, SDS_ID, Data" (("COUNT") ("NOREVERSE") ("START") ("STRIDE")))
    ("HDF_SD_GETINFO"         pro nil                 (system) "%s, SDS_ID" (("CALDATA") ("COORDSYS") ("DIMS") ("FILL") ("FORMAT") ("HDF_TYPE") ("LABEL") ("NAME") ("NATTS") ("NDIMS") ("NOREVERSE") ("RANGE") ("TYPE") ("UNIT")))
    ("HDF_SD_SETCOMPRESS"     pro nil                 (system) "%s, SDS_ID, comptype" (("EFFORT")))
    ("HDF_SD_SETEXTFILE"      pro nil                 (system) "%s, SDS_ID, Filename" (("OFFSET")))
    ("HDF_SD_SETINFO"         pro nil                 (system) "%s, SDS_ID" (("CALDATA") ("COORDSYS") ("FILL") ("FORMAT") ("LABEL") ("RANGE") ("UNIT")))
    ("HDF_UNPACKDATA"         pro nil                 (system) "%s, packeddata, data1 [, data2 [, data3 [, data4 [, data5 [, data6 [, data7 [, data8]]]]]]]" (("HDF_ORDER") ("HDF_TYPE") ("NREC")))
    ("HDF_VD_DETACH"          pro nil                 (system) "%s, VData" nil)
    ("HDF_VD_FDEFINE"         pro nil                 (system) "%s, VData, Fieldname" (("BYTE") ("DLONG") ("DOUBLE") ("DULONG") ("FLOAT") ("INT") ("LONG") ("ORDER") ("UINT") ("ULONG")))
    ("HDF_VD_GET"             pro nil                 (system) "%s, VData" (("CLASS") ("COUNT") ("FIELDS") ("INTERLACE") ("NAME") ("NFIELDS") ("REF") ("SIZE") ("TAG")))
    ("HDF_VD_GETINFO"         pro nil                 (system) "%s, VData, Index" (("NAME") ("ORDER") ("SIZE") ("TYPE")))
    ("HDF_VD_INSERT"          pro nil                 (system) "%s, VGroup, VData(or Vgroup)" (("POSITION")))
    ("HDF_VD_SEEK"            pro nil                 (system) "%s, VData, Record" nil)
    ("HDF_VD_SETINFO"         pro nil                 (system) "%s, VData" (("CLASS") ("FULL_INTERLACE") ("NAME") ("NO_INTERLACE")))
    ("HDF_VD_WRITE"           pro nil                 (system) "%s, VData, Fields, Data" (("FULL_INTERLACE") ("NO_INTERLACE") ("NRECORDS")))
    ("HDF_VG_ADDTR"           pro nil                 (system) "%s, VGroup, Tag, Ref" nil)
    ("HDF_VG_DETACH"          pro nil                 (system) "%s, VGroup" nil)
    ("HDF_VG_GETINFO"         pro nil                 (system) "%s, VGroup" (("CLASS") ("NAME") ("NENTRIES") ("REF") ("TAG")))
    ("HDF_VG_GETTR"           pro nil                 (system) "%s, VGroup, Index, Tags, Refs" nil)
    ("HDF_VG_GETTRS"          pro nil                 (system) "%s, VGroup, Tags, Refs" (("MAXSIZE")))
    ("HDF_VG_INSERT"          pro nil                 (system) "%s, VGroup, VData(or Vgroup)" (("POSITION")))
    ("HDF_VG_SETINFO"         pro nil                 (system) "%s, VGroup" (("CLASS") ("NAME")))
    ("HEAP_GC"                pro nil                 (system) "%s" (("OBJ") ("PTR") ("VERBOSE")))
    ("HELP"                   pro nil                 (system) "%s, Expression1, ..., Expressionn" (("ALL_KEYS") ("BREAKPOINTS") ("BRIEF") ("CALLS") ("DEVICE") ("DLM") ("FILES") ("FULL") ("FUNCTIONS") ("HEAP_VARIABLES") ("KEYS") ("LAST_MESSAGE") ("MEMORY") ("MESSAGES") ("NAMES") ("OBJECTS") ("OUTPUT") ("PROCEDURES") ("RECALL_COMMANDS") ("ROUTINES") ("SOURCE_FILES") ("STRUCTURES") ("SYSTEM_VARIABLES") ("TRACEBACK")))
    ("HLS"                    pro nil                 (system) "%s, Litlo, Lithi, Satlo, Sathi, Hue, Loops [, Colr]" nil)
    ("HOUGH"                  pro nil                 (system) "%s Transform: Result = HOUGH( Array)" (("BACKPROJECT") ("DOUBLE") ("DRHO") ("DX") ("DY") ("GRAY") ("NRHO") ("NTHETA") ("NX") ("NY") ("RHO") ("RMIN") ("THETA") ("XMIN") ("YMIN")))
    ("HSV"                    pro nil                 (system) "%s, Vlo, Vhi, Satlo, Sathi, Hue, Loops [, Colr]" nil)
    ("IDL_SYSRTN_GENERIC"     pro nil                 (system) "%s IDL_SysRtnGetRealPtr(int is_function, char *name)" nil)
    ("IMAGE_CONT"             pro nil                 (system) "%s, A" (("ASPECT") ("INTERP") ("WINDOW_SCALE")))
    ("IMAGE_STATISTICS"       pro nil                 (system) "%s, Data" (("COUNT") ("DATA_SUM") ("LABELED") ("LUT") ("MASK") ("MAXIMUM") ("MEAN") ("MINIMUM") ("STDDEV") ("SUM_OF_SQUARES") ("VARIANCE") ("VECTOR") ("WEIGHT_SUM") ("WEIGHTED")))
    ("ISOCONTOUR"             pro nil                 (system) "%s, Values, Outverts, Outconn" (("AUXDATA_IN") ("AUXDATA_OUT") ("C_VALUE") ("DOUBLE") ("FILL") ("GEOMX") ("GEOMY") ("GEOMZ") ("LEVEL_VALUES") ("N_LEVELS") ("OUTCONN_INDICES") ("POLYGONS")))
    ("ISOSURFACE"             pro nil                 (system) "%s, Data, Value, Outverts, Outconn" (("AUXDATA_IN") ("AUXDATA_OUT") ("GEOM_XYZ") ("TETRAHEDRA")))
    ("JOURNAL"                pro nil                 (system) "%s [, Arg]" nil)
    ("LINKIMAGE"              pro nil                 (system) "%s, Name, Image [, Type [, Entry]]" (("DEFAULT") ("DEVICE") ("FUNCT") ("KEYWORDS") ("MAX_ARGS") ("MIN_ARGS")))
    ("LIVE_CONTOUR"           pro nil                 (system) "%s [, Z1,..., Z25]" (("BUFFER") ("DIMENSIONS") ("DOUBLE") ("DRAW_DIMENSIONS") ("ERROR") ("INDEXED_COLOR") ("INSTANCING") ("LOCATION") ("MANAGE_STYLE") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("NO_STATUS") ("NO_TOOLBAR") ("PARENT_BASE") ("PREFERENCE_FILE") ("REFERENCE_OUT") ("RENDERER") ("REPLACE") ("STYLE") ("TEMPLATE_FILE") ("TITLE") ("TLB_LOCATION") ("WINDOW_IN") ("X") ("XINDEPENDENT") ("XRANGE") ("Y") ("YINDEPENDENT") ("YRANGE")))
    ("LIVE_CONTROL"           pro nil                 (system) "%s, [Name]" (("DIALOG") ("ERROR") ("NO_DRAW") ("PROPERTIES") ("SELECT") ("UPDATE_DATA") ("WINDOW_IN")))
    ("LIVE_DESTROY"           pro nil                 (system) "%s, [Name1,..., Name25]" (("ENVIRONMENT") ("ERROR") ("NO_DRAW") ("PURGE") ("WINDOW_IN")))
    ("LIVE_EXPORT"            pro nil                 (system) "%s" (("APPEND") ("COMPRESSION") ("DIALOG") ("DIMENSIONS") ("ERROR") ("FILENAME") ("ORDER") ("PROGRESSIVE") ("QUALITY") ("RESOLUTION") ("TYPE") ("UNITS") ("VISUALIZATION_IN") ("WINDOW_IN")))
    ("LIVE_IMAGE"             pro nil                 (system) "%s, Image" (("BLUE") ("BUFFER") ("DIMENSIONS") ("DRAW_DIMENSIONS") ("ERROR") ("GREEN") ("INDEXED_COLOR") ("INSTANCING") ("LOCATION") ("MANAGE_STYLE") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("NO_STATUS") ("NO_TOOLBAR") ("PARENT_BASE") ("PREFERENCE_FILE") ("RED") ("REFERENCE_OUT") ("RENDERER") ("REPLACE") ("STYLE") ("TEMPLATE_FILE") ("TITLE") ("TLB_LOCATION") ("WINDOW_IN")))
    ("LIVE_INFO"              pro nil                 (system) "%s, [Name]" (("ERROR") ("PROPERTIES") ("WINDOW_IN")))
    ("LIVE_LINE"              pro nil                 (system) "%s" (("ARROW_ANGLE") ("ARROW_END") ("ARROW_SIZE") ("ARROW_START") ("COLOR") ("DIALOG") ("DIMENSIONS") ("ERROR") ("HIDE") ("LINESTYLE") ("LOCATION") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("REFERENCE_OUT") ("THICK") ("VISUALIZATION_IN") ("WINDOW_IN")))
    ("LIVE_LOAD"              pro nil                 (system) "%s" nil)
    ("LIVE_OPLOT"             pro nil                 (system) "%s, Yvector1 [,... , Yvector25]" (("ERROR") ("INDEPENDENT") ("NAME") ("NEW_AXES") ("NO_DRAW") ("NO_SELECTION") ("REFERENCE_OUT") ("REPLACE") ("SUBTYPE") ("VISUALIZATION_IN") ("WINDOW_IN") ("XAXIS_IN") ("YAXIS_IN")))
    ("LIVE_PLOT"              pro nil                 (system) "%s, Yvector1 [, Yvector2,..., Yvector25]" (("BUFFER") ("DIMENSIONS") ("DOUBLE") ("DRAW_DIMENSIONS") ("ERROR") ("HISTOGRAM") ("INDEPENDENT") ("INDEXED_COLOR") ("INSTANCING") ("LINE") ("LOCATION") ("MANAGE_STYLE") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("NO_STATUS") ("NO_TOOLBAR") ("PARENT_BASE") ("POLAR") ("PREFERENCE_FILE") ("REFERENCE_OUT") ("RENDERER") ("REPLACE") ("SCATTER") ("STYLE") ("TEMPLATE_FILE") ("TITLE") ("TLB_LOCATION") ("WINDOW_IN") ("X") ("XRANGE") ("Y") ("YRANGE")))
    ("LIVE_PRINT"             pro nil                 (system) "%s" (("DIALOG") ("ERROR") ("SETUP") ("WINDOW_IN")))
    ("LIVE_RECT"              pro nil                 (system) "%s" (("COLOR") ("DIALOG") ("DIMENSIONS") ("ERROR") ("HIDE") ("LINESTYLE") ("LOCATION") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("REFERENCE_OUT") ("THICK") ("VISUALIZATION_IN") ("WINDOW_IN")))
    ("LIVE_SURFACE"           pro nil                 (system) "%s, Data, Data2,..." (("BUFFER") ("DIMENSIONS") ("DOUBLE") ("DRAW_DIMENSIONS") ("ERROR") ("INDEXED_COLOR") ("INSTANCING") ("LOCATION") ("MANAGE_STYLE") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("NO_STATUS") ("NO_TOOLBAR") ("PARENT_BASE") ("PREFERENCE_FILE") ("REFERENCE_OUT") ("RENDERER") ("REPLACE") ("STYLE") ("TEMPLATE_FILE") ("TITLE") ("TLB_LOCATION") ("WINDOW_IN") ("X") ("XINDEPENDENT") ("XRANGE") ("Y") ("YINDEPENDENT") ("YRANGE")))
    ("LIVE_TEXT"              pro nil                 (system) "%s[, Text]" (("ALIGNMENT") ("COLOR") ("DIALOG") ("ENABLE_FORMATTING") ("ERROR") ("FONTNAME") ("FONTSIZE") ("HIDE") ("LOCATION") ("NAME") ("NO_DRAW") ("NO_SELECTION") ("REFERENCE_OUT") ("TEXTANGLE") ("VERTICAL_ALIGNMENT") ("VISUALIZATION_IN") ("WINDOW_IN")))
    ("LJLCT"                  pro nil                 (system) "%s" nil)
    ("LOADCT"                 pro nil                 (system) "%s [, Table]" (("BOTTOM") ("FILE") ("GET_NAMES") ("NCOLORS") ("SILENT")))
    ("LUDC"                   pro nil                 (system) "%s, A, Index" (("COLUMN") ("DOUBLE") ("INTERCHANGES")))
    ("MAKE_DLL"               pro nil                 (system) "%s, InputFiles [, OutputFile], ExportedRoutineNames" (("CC") ("COMPILE_DIRECTORY") ("DLL_PATH") ("EXPORTED_DATA") ("EXTRA_CFLAGS") ("EXTRA_LFLAGS") ("INPUT_DIRECTORY") ("LD") ("NOCLEANUP") ("OUTPUT_DIRECTORY") ("SHOW_ALL_OUTPUT") ("VAX_FLOAT") ("VERBOSE")))
    ("MAP_CONTINENTS"         pro nil                 (system) "%s" (("COASTS") ("COLOR") ("CONTINENTS") ("COUNTRIES") ("FILL_CONTINENTS") ("HIRES") ("LIMIT") ("MLINESTYLE") ("MLINETHICK") ("ORIENTATION") ("RIVERS") ("SPACING") ("T3D") ("USA") ("ZVALUE")))
    ("MAP_GRID"               pro nil                 (system) "%s" (("BOX_AXES") ("CHARSIZE") ("CLIP_TEXT") ("COLOR") ("FILL_HORIZON") ("GLINESTYLE") ("GLINETHICK") ("HORIZON") ("INCREMENT") ("LABEL") ("LATALIGN") ("LATDEL") ("LATLAB") ("LATNAMES") ("LATS") ("LONALIGN") ("LONDEL") ("LONLAB") ("LONNAMES") ("LONS") ("NO_GRID") ("ORIENTATION") ("T3D") ("ZVALUE")))
    ("MAP_PROJ_INFO"          pro nil                 (system) "%s [, iproj]" (("AZIMUTHAL") ("CIRCLE") ("CURRENT") ("CYLINDRICAL") ("LL_LIMITS") ("NAME") ("PROJ_NAMES") ("UV_LIMITS") ("UV_RANGE")))
    ("MAP_SET"                pro nil                 (system) "%s [, P0lat, P0lon, Rot]" (("ADVANCE") ("AITOFF") ("ALBERS") ("AZIMUTHAL") ("CENTRAL_AZIMUTH") ("CHARSIZE") ("CLIP") ("COLOR") ("CON_COLOR") ("CONIC") ("CONTINENTS") ("CYLINDRICAL") ("E_CONTINENTS") ("E_GRID") ("E_HORIZON") ("ELLIPSOID") ("GLINESTYLE") ("GLINETHICK") ("GNOMIC") ("GOODESHOMOLOSINE") ("GRID") ("HAMMER") ("HIRES") ("HORIZON") ("ISOTROPIC") ("LABEL") ("LAMBERT") ("LATALIGN") ("LATDEL") ("LATLAB") ("LIMIT") ("LONDEL") ("LONLAB") ("MERCATOR") ("MILLER_CYLINDRICAL") ("MLINESTYLE") ("MLINETHICK") ("MOLLEWIDE") ("NAME") ("NOBORDER") ("NOERASE") ("ORTHOGRAPHIC") ("POSITION") ("REVERSE") ("ROBINSON") ("SAT_P") ("SATELLITE") ("SCALE") ("SINUSOIDAL") ("STANDARD_PARALLELS") ("STEREOGRAPHIC") ("T3D") ("TITLE") ("TRANSVERSE_MERCATOR") ("USA") ("XMARGIN") ("YMARGIN") ("ZVALUE")))
    ("MESH_OBJ"               pro nil                 (system) "%s, Type, Vertex_List, Polygon_List, Array1 [, Array2]" (("DEGREES") ("P1") ("P2") ("P3") ("P4") ("P5")))
    ("MESSAGE"                pro nil                 (system) "%s, [Text]" (("CONTINUE") ("INFORMATIONAL") ("IOERROR") ("NONAME") ("NOPREFIX") ("NOPRINT") ("RESET")))
    ("MK_HTML_HELP"           pro nil                 (system) "%s, Sources, Filename" (("STRICT") ("TITLE") ("VERBOSE")))
    ("MODIFYCT"               pro nil                 (system) "%s, Itab, Name, R, G, B" (("FILE")))
    ("MPEG_CLOSE"             pro nil                 (system) "%s, mpegID" nil)
    ("MPEG_PUT"               pro nil                 (system) "%s, mpegID" (("COLOR") ("FRAME") ("IMAGE") ("ORDER") ("WINDOW")))
    ("MPEG_SAVE"              pro nil                 (system) "%s, mpegID" (("FILENAME")))
    ("MSG_CAT_CLOSE"          pro nil                 (system) "%s, object" nil)
    ("MSG_CAT_COMPILE"        pro nil                 (system) "%s, input[, output]" (("LOCALE_ALIAS") ("MBCS")))
    ("MULTI"                  pro nil                 (system) "%s, N" nil)
    ("NCDF_ATTDEL"            pro nil                 (system) "%s, Cdfid [, Varid]" (("GLOBAL")))
    ("NCDF_ATTGET"            pro nil                 (system) "%s, Cdfid [, Varid]" (("GLOBAL")))
    ("NCDF_ATTPUT"            pro nil                 (system) "%s, Cdfid [, Varid]" (("BYTE") ("CHAR") ("DOUBLE") ("FLOAT") ("GLOBAL") ("LENGTH") ("LONG") ("SHORT")))
    ("NCDF_ATTRENAME"         pro nil                 (system) "%s, Cdfid [, Varid]" (("GLOBAL")))
    ("NCDF_CLOSE"             pro nil                 (system) "%s, Cdfid" nil)
    ("NCDF_CONTROL"           pro nil                 (system) "%s, Cdfid" (("ABORT") ("ENDEF") ("FILL") ("NOFILL") ("NOVERBOSE") ("OLDFILL") ("REDEF") ("SYNC") ("VERBOSE")))
    ("NCDF_DIMINQ"            pro nil                 (system) "%s, Cdfid, Dimid, Name, Size" nil)
    ("NCDF_DIMRENAME"         pro nil                 (system) "%s, Cdfid, Dimid, NewName" nil)
    ("NCDF_VARGET"            pro nil                 (system) "%s, Cdfid, Varid, Value" (("COUNT") ("OFFSET") ("STRIDE")))
    ("NCDF_VARGET1"           pro nil                 (system) "%s, Cdfid, Varid, Value" (("OFFSET")))
    ("NCDF_VARPUT"            pro nil                 (system) "%s, Cdfid, Varid, Value" (("COUNT") ("OFFSET") ("STRIDE")))
    ("NCDF_VARRENAME"         pro nil                 (system) "%s, Cdfid, Varid, Name" nil)
    ("OBJ_DESTROY"            pro nil                 (system) "%s, ObjRef [, Arg1, ..., Argn]" nil)
    ("ON_ERROR"               pro nil                 (system) "%s, N" nil)
    ("ON_IOERROR"             pro nil                 (system) "%s, Label" nil)
    ("ONLINE_HELP"            pro nil                 (system) "%s [, Value]" (("BOOK") ("CONTEXT") ("FULL_PATH") ("HTML_HELP") ("QUIT") ("TOPICS")))
    ("OPENR"                  pro nil                 (system) "%s, Unit, File [, Record_Length]" (("APPEND") ("BLOCK") ("BUFSIZE") ("COMPRESS") ("DEFAULT") ("DELETE") ("ERROR") ("EXTENDSIZE") ("F77_UNFORMATTED") ("FIXED") ("FORTRAN") ("GET_LUN") ("INITIALSIZE") ("KEYED") ("LIST") ("MACCREATOR") ("MACTYPE") ("MORE") ("NONE") ("PRINT") ("RAWIO") ("SEGMENTED") ("SHARED") ("STDIO") ("STREAM") ("SUBMIT") ("SUPERSEDE") ("SWAP_ENDIAN") ("SWAP_IF_BIG_ENDIAN") ("SWAP_IF_LITTLE_ENDIAN") ("TRUNCATE_ON_CLOSE") ("UDF_BLOCK") ("VARIABLE") ("VAX_FLOAT") ("WIDTH") ("XDR")))
    ("OPENU"                  pro nil                 (system) "%s, Unit, File [, Record_Length]" (("APPEND") ("BLOCK") ("BUFSIZE") ("COMPRESS") ("DEFAULT") ("DELETE") ("ERROR") ("EXTENDSIZE") ("F77_UNFORMATTED") ("FIXED") ("FORTRAN") ("GET_LUN") ("INITIALSIZE") ("KEYED") ("LIST") ("MACCREATOR") ("MACTYPE") ("MORE") ("NONE") ("PRINT") ("RAWIO") ("SEGMENTED") ("SHARED") ("STDIO") ("STREAM") ("SUBMIT") ("SUPERSEDE") ("SWAP_ENDIAN") ("SWAP_IF_BIG_ENDIAN") ("SWAP_IF_LITTLE_ENDIAN") ("TRUNCATE_ON_CLOSE") ("UDF_BLOCK") ("VARIABLE") ("VAX_FLOAT") ("WIDTH") ("XDR")))
    ("OPENW"                  pro nil                 (system) "%s, Unit, File [, Record_Length]" (("APPEND") ("BLOCK") ("BUFSIZE") ("COMPRESS") ("DEFAULT") ("DELETE") ("ERROR") ("EXTENDSIZE") ("F77_UNFORMATTED") ("FIXED") ("FORTRAN") ("GET_LUN") ("INITIALSIZE") ("KEYED") ("LIST") ("MACCREATOR") ("MACTYPE") ("MORE") ("NONE") ("PRINT") ("RAWIO") ("SEGMENTED") ("SHARED") ("STDIO") ("STREAM") ("SUBMIT") ("SUPERSEDE") ("SWAP_ENDIAN") ("SWAP_IF_BIG_ENDIAN") ("SWAP_IF_LITTLE_ENDIAN") ("TRUNCATE_ON_CLOSE") ("UDF_BLOCK") ("VARIABLE") ("VAX_FLOAT") ("WIDTH") ("XDR")))
    ("OPLOT"                  pro nil                 (system) "%s, [X,] Y" (("CLIP") ("COLOR") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NOCLIP") ("NSUM") ("POLAR") ("PSYM") ("SYMSIZE") ("T3D") ("THICK") ("ZVALUE")))
    ("OPLOTERR"               pro nil                 (system) "%s, [ X ,] Y , Err [, Psym]" nil)
    ("PARTICLE_TRACE"         pro nil                 (system) "%s, Data, Seeds, Verts, Conn [, Normals]" (("ANISOTROPY") ("INTEGRATION") ("MAX_ITERATIONS") ("MAX_STEPSIZE") ("SEED_NORMAL") ("TOLERANCE") ("UNIFORM")))
    ("PLOT"                   pro nil                 (system) "%s, [X,] Y" (("BACKGROUND") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("COLOR") ("DATA") ("DEVICE") ("FONT") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NOCLIP") ("NODATA") ("NOERASE") ("NORMAL") ("NSUM") ("POLAR") ("POSITION") ("PSYM") ("SUBTITLE") ("SYMSIZE") ("T3D") ("THICK") ("TICKLEN") ("TITLE") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICK_GET") ("XTICKFORMAT") ("XTICKINTERVAL") ("XTICKLAYOUT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKUNITS") ("XTICKV") ("XTITLE") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YNOZERO") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICK_GET") ("YTICKFORMAT") ("YTICKINTERVAL") ("YTICKLAYOUT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKUNITS") ("YTICKV") ("YTITLE") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICK_GET") ("ZTICKFORMAT") ("ZTICKINTERVAL") ("ZTICKLAYOUT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKUNITS") ("ZTICKV") ("ZTITLE") ("ZVALUE")))
    ("PLOT_3DBOX"             pro nil                 (system) "%s, X, Y, Z" (("AX") ("AZ") ("BACKGROUND") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("COLOR") ("DATA") ("DEVICE") ("GRIDSTYLE") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NOCLIP") ("NODATA") ("NOERASE") ("NORMAL") ("NSUM") ("POLAR") ("POSITION") ("PSYM") ("SOLID_WALLS") ("SUBTITLE") ("T3D") ("THICK") ("TICKLEN") ("TITLE") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICKFORMAT") ("XTICKINTERVAL") ("XTICKLAYOUT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKUNITS") ("XTICKV") ("XTITLE") ("XY_PLANE") ("XYSTYLE") ("XZ_PLANE") ("XZSTYLE") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YNOZERO") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICKFORMAT") ("YTICKINTERVAL") ("YTICKLAYOUT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKUNITS") ("YTICKV") ("YTITLE") ("YZ_PLANE") ("YZSTYLE") ("ZAXIS") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICKFORMAT") ("ZTICKINTERVAL") ("ZTICKLAYOUT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKUNITS") ("ZTICKV") ("ZTITLE")))
    ("PLOT_FIELD"             pro nil                 (system) "%s, U, V" (("ASPECT") ("LENGTH") ("N") ("TITLE")))
    ("PLOTERR"                pro nil                 (system) "%s, [ X ,] Y , Err" (("PSYM") ("TYPE")))
    ("PLOTS"                  pro nil                 (system) "%s, X [, Y [, Z]]" (("CLIP") ("COLOR") ("CONTINUE") ("DATA") ("DEVICE") ("LINESTYLE") ("NOCLIP") ("NORMAL") ("PSYM") ("SYMSIZE") ("T3D") ("THICK") ("Z")))
    ("POINT_LUN"              pro nil                 (system) "%s, Unit, Position" nil)
    ("POLAR_CONTOUR"          pro nil                 (system) "%s, Z, Theta, R" (("C_ANNOTATION") ("C_CHARSIZE") ("C_CHARTHICK") ("C_COLORS") ("C_LINESTYLE") ("C_ORIENTATION") ("C_SPACING") ("C_THICK") ("CLOSED") ("FILL") ("IRREGULAR") ("LEVELS") ("MAX_VALUE") ("MIN_VALUE") ("NLEVELS") ("OVERPLOT") ("PATH_DATA_COORDS") ("SHOW_TRIANGULATION") ("TRIANGULATION") ("XLOG") ("YLOG") ("ZAXIS")))
    ("POLYFILL"               pro nil                 (system) "%s, X [, Y [, Z]]" (("CLIP") ("COLOR") ("DATA") ("DEVICE") ("IMAGE_COORD") ("IMAGE_INTERP") ("LINE_FILL") ("LINESTYLE") ("NOCLIP") ("NORMAL") ("ORIENTATION") ("PATTERN") ("SPACING") ("T3D") ("THICK") ("TRANSPARENT") ("Z")))
    ("POLYWARP"               pro nil                 (system) "%s, Xi, Yi, Xo, Yo, Degree, Kx, Ky" nil)
    ("POPD"                   pro nil                 (system) "%s" nil)
    ("POWELL"                 pro nil                 (system) "%s, P, Xi, Ftol, Fmin, Func" (("DOUBLE") ("ITER") ("ITMAX")))
    ("PRINT"                  pro nil                 (system) "%s [, Expr1, ..., Exprn]" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("MONTHS") ("REWRITE") ("STDIO_NON_FINITE")))
    ("PRINTD"                 pro nil                 (system) "%s" nil)
    ("PRINTF"                 pro nil                 (system) "%s [, Unit, Expr1, ..., Exprn]" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("MONTHS") ("REWRITE") ("STDIO_NON_FINITE")))
    ("PROFILER"               pro nil                 (system) "%s [, Module]" (("CLEAR") ("DATA") ("OUTPUT") ("REPORT") ("RESET") ("SYSTEM")))
    ("PROFILES"               pro nil                 (system) "%s, Image" (("ORDER") ("SX") ("SY") ("WSIZE")))
    ("PS_SHOW_FONTS"          pro nil                 (system) "%s" (("NOLATIN")))
    ("PSAFM"                  pro nil                 (system) "%s, Input_Filename, Output_Filename" nil)
    ("PSEUDO"                 pro nil                 (system) "%s, Litlo, Lithi, Satlo, Sathi, Hue, Loops [, Colr]" nil)
    ("PTR_FREE"               pro nil                 (system) "%s, P1, ... ..., Pn" nil)
    ("PUSHD"                  pro nil                 (system) "%s, Dir" nil)
    ("RADON"                  pro nil                 (system) "%s Transform: Result = RADON( Array)" (("BACKPROJECT") ("DOUBLE") ("DRHO") ("DX") ("DY") ("GRAY") ("LINEAR") ("NRHO") ("NTHETA") ("NX") ("NY") ("RHO") ("RMIN") ("THETA") ("XMIN") ("YMIN")))
    ("RDPIX"                  pro nil                 (system) "%s, Image [, X0, Y0]" nil)
    ("READ"                   pro nil                 (system) "%s, [Prompt,] Var1, ..., Varn" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("KEY_ID") ("KEY_MATCH") ("KEY_VALUE") ("MONTHS") ("PROMPT")))
    ("READ_INTERFILE"         pro nil                 (system) "%s, File, Data" nil)
    ("READ_JPEG"              pro nil                 (system) "%s [, Filename]" (("BUFFER") ("COLORS") ("DITHER") ("GRAYSCALE") ("ORDER") ("TRUE") ("TWO_PASS_QUANTIZE") ("UNIT")))
    ("READ_PICT"              pro nil                 (system) "%s, Filename, Image [, R, G, B]" nil)
    ("READ_PPM"               pro nil                 (system) "%s, Filename, Image" (("MAXVAL")))
    ("READ_SRF"               pro nil                 (system) "%s, Filename, Image [, R, G, B]" nil)
    ("READ_WAVE"              pro nil                 (system) "%s, File, Variables, Names, Dimensions" (("MESHNAMES")))
    ("READ_X11_BITMAP"        pro nil                 (system) "%s, File, Bitmap [, X, Y]" (("EXPAND_TO_BYTES")))
    ("READF"                  pro nil                 (system) "%s, [Prompt,] Var1, ..., Varn" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("KEY_ID") ("KEY_MATCH") ("KEY_VALUE") ("MONTHS") ("PROMPT")))
    ("READS"                  pro nil                 (system) "%s, Input, Var1, ..., Varn" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("MONTHS")))
    ("READU"                  pro nil                 (system) "%s, Unit, Var1, ..., Varn" (("KEY_ID") ("KEY_MATCH") ("KEY_VALUE") ("TRANSFER_COUNT")))
    ("REDUCE_COLORS"          pro nil                 (system) "%s, Image, Values" nil)
    ("REPLICATE_INPLACE"      pro nil                 (system) "%s, X, Value [, D1, Loc1 [, D2, Range]]" nil)
    ("RESOLVE_ALL"            pro nil                 (system) "%s" (("CONTINUE_ON_ERROR") ("QUIET")))
    ("RESOLVE_ROUTINE"        pro nil                 (system) "%s, Name" (("COMPILE_FULL_FILE") ("EITHER") ("IS_FUNCTION") ("NO_RECOMPILE")))
    ("RESTORE"                pro nil                 (system) "%s [, Filename]" (("FILENAME") ("RELAXED_STRUCTURE_ASSIGNMENT") ("RESTORED_OBJECTS") ("VERBOSE")))
    ("RETALL"                 pro nil                 (system) "%s" nil)
    ("RETURN"                 pro nil                 (system) "%s [, Return_value]" nil)
    ("REWIND"                 pro nil                 (system) "%s, Unit" nil)
    ("RIEMANN"                pro nil                 (system) "%s, P, A, Theta" (("BACKPROJECT") ("BILINEAR") ("CENTER") ("COR") ("CUBIC") ("D") ("ROW")))
    ("SAVE"                   pro nil                 (system) "%s [, Var1, ..., Varn]" (("ALL") ("COMM") ("COMPRESS") ("FILENAME") ("ROUTINES") ("SYSTEM_VARIABLES") ("VARIABLES") ("VERBOSE")))
    ("SCALE3"                 pro nil                 (system) "%s" (("AX") ("AZ") ("XRANGE") ("YRANGE") ("ZRANGE")))
    ("SCALE3D"                pro nil                 (system) "%s" nil)
    ("SET_PLOT"               pro nil                 (system) "%s, Device" (("COPY") ("INTERPOLATE")))
    ("SET_SHADING"            pro nil                 (system) "%s" (("GOURAUD") ("LIGHT") ("REJECT") ("VALUES")))
    ("SET_SYMBOL"             pro nil                 (system) "%s, Name, Value" (("TYPE")))
    ("SETENV"                 pro nil                 (system) "%s, Environment_Expression" nil)
    ("SETLOG"                 pro nil                 (system) "%s, Lognam, Value" (("CONCEALED") ("CONFINE") ("NO_ALIAS") ("TABLE") ("TERMINAL")))
    ("SETUP_KEYS"             pro nil                 (system) "%s" (("APP_KEYPAD") ("EIGHTBIT") ("HP9000") ("MIPS") ("NUM_KEYPAD") ("PSTERM") ("SGI") ("SUN") ("VT200")))
    ("SHADE_SURF"             pro nil                 (system) "%s, Z [, X, Y]" (("AX") ("AZ") ("CHARSIZE") ("CHARTHICK") ("COLOR") ("DATA") ("DEVICE") ("FONT") ("IMAGE") ("MAX_VALUE") ("MIN_VALUE") ("NODATA") ("NORMAL") ("PIXELS") ("POSITION") ("SAVE") ("SHADES") ("SUBTITLE") ("T3D") ("THICK") ("TICKLEN") ("TITLE") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICK_GET") ("XTICKFORMAT") ("XTICKINTERVAL") ("XTICKLAYOUT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKUNITS") ("XTICKV") ("XTITLE") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICK_GET") ("YTICKFORMAT") ("YTICKINTERVAL") ("YTICKLAYOUT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKUNITS") ("YTICKV") ("YTITLE") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICK_GET") ("ZTICKFORMAT") ("ZTICKINTERVAL") ("ZTICKLAYOUT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKUNITS") ("ZTICKV") ("ZTITLE") ("ZVALUE")))
    ("SHADE_SURF_IRR"         pro nil                 (system) "%s, Z, X, Y" (("AX") ("AZ") ("IMAGE") ("PLIST") ("T3D")))
    ("SHADE_VOLUME"           pro nil                 (system) "%s, Volume, Value, Vertex, Poly" (("LOW") ("SHADES") ("VERBOSE") ("XRANGE") ("YRANGE") ("ZRANGE")))
    ("SHOW3"                  pro nil                 (system) "%s, Image [, X, Y]" (("E_CONTOUR") ("E_SURFACE") ("INTERP") ("SSCALE")))
    ("SHOWFONT"               pro nil                 (system) "%s, Font, Name" (("ENCAPSULATED") ("TT_FONT")))
    ("SKIPF"                  pro nil                 (system) "%s, Unit, Files or SKIPF, Unit, Records, R" nil)
    ("SLICER3"                pro nil                 (system) "%s [, hData3D]" (("DATA_NAMES") ("DETACH") ("GROUP") ("MODAL")))
    ("SLIDE_IMAGE"            pro nil                 (system) "%s [, Image]" (("BLOCK") ("CONGRID") ("FULL_WINDOW") ("GROUP") ("ORDER") ("REGISTER") ("RETAIN") ("SHOW_FULL") ("SLIDE_WINDOW") ("TITLE") ("TOP_ID") ("XSIZE") ("XVISIBLE") ("YSIZE") ("YVISIBLE")))
    ("SOCKET"                 pro nil                 (system) "%s, Unit, Host, Port" (("CONNECT_TIMEOUT") ("ERROR") ("GET_LUN") ("RAWIO") ("READ_TIMEOUT") ("STDIO") ("SWAP_ENDIAN") ("SWAP_IF_BIG_ENDIAN") ("SWAP_IF_LITTLE_ENDIAN") ("WIDTH") ("WRITE_TIMEOUT")))
    ("SPAWN"                  pro nil                 (system) "%s [, Command [, Result] [, ErrResult]]" (("COUNT") ("EXIT_STATUS") ("FORCE") ("HIDE") ("LOG_OUTPUT") ("MACCREATOR") ("NOCLISYM") ("NOLOGNAM") ("NOSHELL") ("NOTIFY") ("NOTTYRESET") ("NOWAIT") ("NULL_STDIN") ("PID") ("SH") ("STDERR") ("UNIT")))
    ("SPH_4PNT"               pro nil                 (system) "%s, X, Y, Z, Xc, Yc, Zc, R" (("DOUBLE")))
    ("SPLINE_P"               pro nil                 (system) "%s, X, Y, Xr, Yr" (("INTERVAL") ("TAN0") ("TAN1")))
    ("STOP"                   pro nil                 (system) "%s [, Expr1, ..., Exprn]" nil)
    ("STREAMLINE"             pro nil                 (system) "%s, Verts, Conn, Normals, Outverts, Outconn" (("ANISOTROPY") ("PROFILE") ("SIZE")))
    ("STRETCH"                pro nil                 (system) "%s [, Low, High [, Gamma]]" (("CHOP")))
    ("STRPUT"                 pro nil                 (system) "%s, Destination, Source [, Position]" nil)
    ("STRUCT_ASSIGN"          pro nil                 (system) "%s, Source, Destination" (("NOZERO") ("VERBOSE")))
    ("STRUCT_HIDE"            pro nil                 (system) "%s, Arg1 [, Arg2, ..., Argn]" nil)
    ("SURFACE"                pro nil                 (system) "%s, Z [, X, Y]" (("AX") ("AZ") ("BACKGROUND") ("BOTTOM") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("COLOR") ("DATA") ("DEVICE") ("FONT") ("HORIZONTAL") ("LEGO") ("LINESTYLE") ("LOWER_ONLY") ("MAX_VALUE") ("MIN_VALUE") ("NOCLIP") ("NODATA") ("NOERASE") ("NORMAL") ("NSUM") ("POLAR") ("POSITION") ("SAVE") ("SHADES") ("SKIRT") ("SUBTITLE") ("T3D") ("THICK") ("TICKLEN") ("TITLE") ("UPPER_ONLY") ("XCHARSIZE") ("XGRIDSTYLE") ("XLOG") ("XMARGIN") ("XMINOR") ("XRANGE") ("XSTYLE") ("XTHICK") ("XTICK_GET") ("XTICKFORMAT") ("XTICKINTERVAL") ("XTICKLAYOUT") ("XTICKLEN") ("XTICKNAME") ("XTICKS") ("XTICKUNITS") ("XTICKV") ("XTITLE") ("YCHARSIZE") ("YGRIDSTYLE") ("YLOG") ("YMARGIN") ("YMINOR") ("YNOZERO") ("YRANGE") ("YSTYLE") ("YTHICK") ("YTICK_GET") ("YTICKFORMAT") ("YTICKINTERVAL") ("YTICKLAYOUT") ("YTICKLEN") ("YTICKNAME") ("YTICKS") ("YTICKUNITS") ("YTICKV") ("YTITLE") ("ZAXIS") ("ZCHARSIZE") ("ZGRIDSTYLE") ("ZLOG") ("ZMARGIN") ("ZMINOR") ("ZRANGE") ("ZSTYLE") ("ZTHICK") ("ZTICK_GET") ("ZTICKFORMAT") ("ZTICKINTERVAL") ("ZTICKLAYOUT") ("ZTICKLEN") ("ZTICKNAME") ("ZTICKS") ("ZTICKUNITS") ("ZTICKV") ("ZTITLE") ("ZVALUE")))
    ("SURFR"                  pro nil                 (system) "%s" (("AX") ("AZ")))
    ("SVDC"                   pro nil                 (system) "%s, A, W, U, V" (("COLUMN") ("DOUBLE") ("ITMAX")))
    ("T3D"                    pro nil                 (system) "%s [, Array]" (("MATRIX") ("OBLIQUE") ("PERSPECTIVE") ("RESET") ("ROTATE") ("SCALE") ("TRANSLATE") ("XYEXCH") ("XZEXCH") ("YZEXCH")))
    ("TAPRD"                  pro nil                 (system) "%s, Array, Unit [, Byte_Reverse]" nil)
    ("TAPWRT"                 pro nil                 (system) "%s, Array, Unit [, Byte_Reverse]" nil)
    ("TEK_COLOR"              pro nil                 (system) "%s [, Start_Index, Colors]" nil)
    ("THREED"                 pro nil                 (system) "%s, A [, Sp]" (("TITLE") ("XTITLE") ("YTITLE")))
    ("TIFF_DUMP"              pro nil                 (system) "%s, File" nil)
    ("TIFF_WRITE"             pro nil                 (system) "%s, File, Array [, Orientation]" nil)
    ("TIME_TEST2"             pro nil                 (system) "%s [, Filename]" nil)
    ("TRIANGULATE"            pro nil                 (system) "%s, X, Y, Triangles [, B]" (("CONNECTIVITY") ("DEGREES") ("FVALUE") ("REPEATS") ("SPHERE")))
    ("TRIQL"                  pro nil                 (system) "%s, D, E, A" (("DOUBLE")))
    ("TRIRED"                 pro nil                 (system) "%s, A, D, E" (("DOUBLE")))
    ("TV"                     pro nil                 (system) "%s, Image [, Position] or TV, Image [, X, Y [, Channel]]" (("CENTIMETERS") ("CHANNEL") ("DATA") ("DEVICE") ("INCHES") ("NORMAL") ("ORDER") ("T3D") ("TRUE") ("WORDS") ("XSIZE") ("YSIZE") ("Z")))
    ("TVCRS"                  pro nil                 (system) "%s [, ON_OFF] or TVCRS [, X, Y]" (("CENTIMETERS") ("DATA") ("DEVICE") ("HIDE_CURSOR") ("INCHES") ("NORMAL") ("T3D") ("Z")))
    ("TVLCT"                  pro nil                 (system) "%s, V1, V2, V3 [, Start]" (("GET") ("HLS") ("HSV")))
    ("TVSCL"                  pro nil                 (system) "%s, Image [, Position] or TVSCL, Image [, X, Y [, Channel]]" (("CENTIMETERS") ("CHANNEL") ("DATA") ("DEVICE") ("INCHES") ("NAN") ("NORMAL") ("ORDER") ("T3D") ("TOP") ("TRUE") ("WORDS") ("XSIZE") ("YSIZE") ("Z")))
    ("USERSYM"                pro nil                 (system) "%s, X [, Y]" (("COLOR") ("FILL") ("THICK")))
    ("VECTOR_FIELD"           pro nil                 (system) "%s, Field, Outverts, Outconn" (("ANISOTROPY") ("SCALE") ("VERTICES")))
    ("VEL"                    pro nil                 (system) "%s, U, V" (("LENGTH") ("NSTEPS") ("NVECS") ("TITLE") ("XMAX")))
    ("VELOVECT"               pro nil                 (system) "%s, U, V [, X, Y]" (("COLOR") ("DOTS") ("LENGTH") ("MISSING") ("OVERPLOT")))
    ("VORONOI"                pro nil                 (system) "%s, X, Y, I0, C, Xp, Yp, Rect" nil)
    ("WAIT"                   pro nil                 (system) "%s, Seconds" nil)
    ("WDELETE"                pro nil                 (system) "%s [, Window_Index [, ...]]" nil)
    ("WEOF"                   pro nil                 (system) "%s, Unit" nil)
    ("WF_DRAW"                pro nil                 (system) "%s, X, Y" (("COLD") ("COLOR") ("CONVERGENCE") ("DATA") ("DEVICE") ("FRONT_TYPE") ("INTERVAL") ("NORMAL") ("OCCLUDED") ("PSYM") ("STATIONARY") ("SYM_HT") ("SYM_LEN") ("THICK") ("WARM")))
    ("WIDED"                  pro nil                 (system) "%s" nil)
    ("WIDGET_CONTROL"         pro nil                 (system) "%s [, Widget_ID]" (("ALIGNMENT") ("ALL_TABLE_EVENTS") ("ALL_TEXT_EVENTS") ("AM_PM") ("APPEND") ("BAD_ID") ("BITMAP") ("CANCEL_BUTTON") ("CLEAR_EVENTS") ("COLUMN_LABELS") ("COLUMN_WIDTHS") ("DAYS_OF_WEEK") ("DEFAULT_BUTTON") ("DEFAULT_FONT") ("DELAY_DESTROY") ("DELETE_COLUMNS") ("DELETE_ROWS") ("DESTROY") ("DRAW_BUTTON_EVENTS") ("DRAW_EXPOSE_EVENTS") ("DRAW_MOTION_EVENTS") ("DRAW_VIEWPORT_EVENTS") ("DRAW_XSIZE") ("DRAW_YSIZE") ("DYNAMIC_RESIZE") ("EDIT_CELL") ("EDITABLE") ("EVENT_FUNC") ("EVENT_PRO") ("FORMAT") ("FUNC_GET_VALUE") ("GET_DRAW_VIEW") ("GET_UVALUE") ("GET_VALUE") ("GROUP_LEADER") ("HOURGLASS") ("ICONIFY") ("INPUT_FOCUS") ("INSERT_COLUMNS") ("INSERT_ROWS") ("KBRD_FOCUS_EVENTS") ("KILL_NOTIFY") ("MAP") ("MONTHS") ("NO_COPY") ("NO_NEWLINE") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("REALIZE") ("RESET") ("ROW_HEIGHTS") ("ROW_LABELS") ("SCR_XSIZE") ("SCR_YSIZE") ("SEND_EVENT") ("SENSITIVE") ("SET_BUTTON") ("SET_DRAW_VIEW") ("SET_DROPLIST_SELECT") ("SET_LIST_SELECT") ("SET_LIST_TOP") ("SET_SLIDER_MAX") ("SET_SLIDER_MIN") ("SET_TABLE_SELECT") ("SET_TABLE_VIEW") ("SET_TEXT_SELECT") ("SET_TEXT_TOP_LINE") ("SET_UNAME") ("SET_UVALUE") ("SET_VALUE") ("SHOW") ("TABLE_XSIZE") ("TABLE_YSIZE") ("TIMER") ("TLB_GET_OFFSET") ("TLB_GET_SIZE") ("TLB_KILL_REQUEST_EVENTS") ("TLB_SET_TITLE") ("TLB_SET_XOFFSET") ("TLB_SET_YOFFSET") ("TRACKING_EVENTS") ("UNITS") ("UPDATE") ("USE_TABLE_SELECT") ("USE_TEXT_SELECT") ("X_BITMAP_EXTRA") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")))
    ("WINDOW"                 pro nil                 (system) "%s [, Window_Index]" (("COLORS") ("FREE") ("PIXMAP") ("RETAIN") ("TITLE") ("XPOS") ("XSIZE") ("YPOS") ("YSIZE")))
    ("WRITE_BMP"              pro nil                 (system) "%s, Filename, Image[, R, G, B]" (("FOUR_BIT") ("HEADER_DEFINE") ("IHDR") ("RGB")))
    ("WRITE_IMAGE"            pro nil                 (system) "%s, Filename, Format, Data [, Red, Green, Blue]" (("APPEND")))
    ("WRITE_JPEG"             pro nil                 (system) "%s [, Filename] , Image" (("ORDER") ("PROGRESSIVE") ("QUALITY") ("TRUE") ("UNIT")))
    ("WRITE_NRIF"             pro nil                 (system) "%s, File, Image [, R, G, B]" nil)
    ("WRITE_PICT"             pro nil                 (system) "%s, Filename [, Image, R, G, B]" nil)
    ("WRITE_PNG"              pro nil                 (system) "%s, Filename, Image[, R, G, B]" (("ORDER") ("TRANSPARENT") ("VERBOSE")))
    ("WRITE_PPM"              pro nil                 (system) "%s, Filename, Image" (("ASCII")))
    ("WRITE_SPR"              pro nil                 (system) "%s, AS, Filename" nil)
    ("WRITE_SRF"              pro nil                 (system) "%s, Filename [, Image, R, G, B]" (("ORDER") ("WRITE_32")))
    ("WRITE_TIFF"             pro nil                 (system) "%s, Filename [, Image, Order]" (("APPEND") ("BLUE") ("COMPRESSION") ("FLOAT") ("GEOTIFF") ("GREEN") ("LONG") ("PLANARCONFIG") ("RED") ("SHORT") ("VERBOSE") ("XRESOL") ("YRESOL")))
    ("WRITE_WAV"              pro nil                 (system) "%s, Filename, Data, Rate" nil)
    ("WRITE_WAVE"             pro nil                 (system) "%s, File, Array" (("BIN") ("DATANAME") ("MESHNAME") ("NOMESHDEF") ("VECTOR")))
    ("WRITEU"                 pro nil                 (system) "%s, Unit, Expr1 ..., Exprn" (("REWRITE") ("TRANSFER_COUNT")))
    ("WSET"                   pro nil                 (system) "%s [, Window_Index]" nil)
    ("WSHOW"                  pro nil                 (system) "%s [, Window_Index [, Show]]" (("ICONIC")))
    ("XBM_EDIT"               pro nil                 (system) "%s" (("BLOCK") ("FILENAME") ("GROUP") ("XSIZE") ("YSIZE")))
    ("XDISPLAYFILE"           pro nil                 (system) "%s, Filename" (("BLOCK") ("DONE_BUTTON") ("EDITABLE") ("FONT") ("GROUP") ("HEIGHT") ("MODAL") ("TEXT") ("TITLE") ("WIDTH") ("WTEXT")))
    ("XDXF"                   pro nil                 (system) "%s [, Filename]" (("BLOCK") ("GROUP") ("MODAL") ("SCALE") ("TEST")))
    ("XINTERANIMATE"          pro nil                 (system) "%s [, Rate]" (("BLOCK") ("CLOSE") ("CYCLE") ("FRAME") ("GROUP") ("IMAGE") ("KEEP_PIXMAPS") ("MODAL") ("MPEG_BITRATE") ("MPEG_CLOSE") ("MPEG_FILENAME") ("MPEG_IFRAME_GAP") ("MPEG_MOTION_VEC_LENGTH") ("MPEG_OPEN") ("MPEG_QUALITY") ("ORDER") ("SET") ("SHOWLOAD") ("TITLE") ("TRACK") ("WINDOW") ("XOFFSET") ("YOFFSET")))
    ("XLOADCT"                pro nil                 (system) "%s" (("BLOCK") ("BOTTOM") ("FILE") ("GROUP") ("MODAL") ("NCOLORS") ("SILENT") ("UPDATECALLBACK") ("UPDATECBDATA") ("USE_CURENT")))
    ("XMANAGER"               pro nil                 (system) "%s [, Name, ID]" (("CATCH") ("CLEANUP") ("EVENT_HANDLER") ("GROUP_LEADER") ("JUST_REG") ("NO_BLOCK")))
    ("XMNG_TMPL"              pro nil                 (system) "%s" (("BLOCK") ("GROUP")))
    ("XMTOOL"                 pro nil                 (system) "%s" (("BLOCK") ("GROUP")))
    ("XOBJVIEW"               pro nil                 (system) "%s, Obj" (("BACKGROUND") ("BLOCK") ("DOUBLE_VIEW") ("GROUP") ("MODAL") ("REFRESH") ("SCALE") ("STATIONARY") ("TEST") ("TITLE") ("TLB") ("XSIZE") ("YSIZE")))
    ("XPALETTE"               pro nil                 (system) "%s" (("BLOCK") ("GROUP") ("UPDATECALLBACK") ("UPDATECBDATA")))
    ("XPCOLOR"                pro nil                 (system) "%s" (("GROUP")))
    ("XPLOT3D"                pro nil                 (system) "%s, X, Y, Z" (("BLOCK") ("COLOR") ("DOUBLE_VIEW") ("GROUP") ("LINESTYLE") ("MODAL") ("NAME") ("OVERPLOT") ("SYMBOL") ("TEST") ("THICK") ("TITLE") ("XRANGE") ("XTITLE") ("YRANGE") ("YTITLE") ("ZRANGE") ("ZTITLE")))
    ("XROI"                   pro nil                 (system) "%s [, ImageData] [, R] [, G] [, B]" (("BLOCK") ("FLOATING") ("GROUP") ("MODAL") ("REGIONS_IN") ("REGIONS_OUT") ("REJECTED") ("RENDERER") ("ROI_COLOR") ("ROI_GEOMETRY") ("ROI_SELECT_COLOR") ("STATISTICS") ("TITLE") ("TOOLS")))
    ("XSURFACE"               pro nil                 (system) "%s, Data" (("BLOCK") ("GROUP")))
    ("XVAREDIT"               pro nil                 (system) "%s, Var" (("GROUP") ("NAME") ("X_SCROLL_SIZE") ("Y_SCROLL_SIZE")))
    ("XVOLUME"                pro nil                 (system) "%s, Vol" (("BLOCK") ("GROUP") ("INTERPOLATE") ("MODAL") ("RENDERER") ("REPLACE") ("SCALE") ("TEST") ("XSIZE") ("YSIZE")))
    ("XVOLUME_ROTATE"         pro nil                 (system) "%s, Axis, Angle" (("PREMULTIPLY")))
    ("XVOLUME_WRITE_IMAGE"    pro nil                 (system) "%s, Filename, Format" (("DIMENSIONS")))
    ("XYOUTS"                 pro nil                 (system) "%s, [X, Y,] String" (("ALIGNMENT") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("COLOR") ("DATA") ("DEVICE") ("FONT") ("NOCLIP") ("NORMAL") ("ORIENTATION") ("T3D") ("TEXT_AXES") ("WIDTH") ("Z")))
    ("ZOOM"                   pro nil                 (system) "%s" (("CONTINUOUS") ("FACT") ("INTERP") ("KEEP") ("NEW_WINDOW") ("XSIZE") ("YSIZE") ("ZOOM_WINDOW")))
    ("ZOOM_24"                pro nil                 (system) "%s" (("FACT") ("RIGHT") ("XSIZE") ("YSIZE")))
    ("A_CORRELATE"            fun nil                 (system) "Result = %s(X, Lag)" (("COVARIANCE") ("DOUBLE")))
    ("ABS"                    fun nil                 (system) "Result = %s(X)" nil)
    ("ACOS"                   fun nil                 (system) "Result = %s(X)" nil)
    ("ADAPT_HIST_EQUAL"       fun nil                 (system) "Result = %s (Image)" (("CLIP") ("NREGIONS") ("TOP")))
    ("ALOG"                   fun nil                 (system) "Result = %s(X)" nil)
    ("ALOG10"                 fun nil                 (system) "Result = %s(X)" nil)
    ("AMOEBA"                 fun nil                 (system) "Result = %s( Ftol)" (("FUNCTION_NAME") ("FUNCTION_VALUE") ("NCALLS") ("NMAX") ("P0") ("SCALE") ("SIMPLEX")))
    ("ARG_PRESENT"            fun nil                 (system) "Result = %s(Variable)" nil)
    ("ARRAY_EQUAL"            fun nil                 (system) "Result = %s( Op1 , Op2)" (("NO_TYPECONV")))
    ("ASCII_TEMPLATE"         fun nil                 (system) "Result = %s( [Filename])" (("BROWSE_LINES") ("CANCEL") ("GROUP")))
    ("ASIN"                   fun nil                 (system) "Result = %s(X)" nil)
    ("ASSOC"                  fun nil                 (system) "Result = %s( Unit, Array_Structure [, Offset])" (("PACKED")))
    ("ATAN"                   fun nil                 (system) "Result = %s([Y,] X)" nil)
    ("BESELI"                 fun nil                 (system) "Result = %s(X, N)" nil)
    ("BESELJ"                 fun nil                 (system) "Result = %s(X, N)" nil)
    ("BESELK"                 fun nil                 (system) "Result = %s( X, N )" nil)
    ("BESELY"                 fun nil                 (system) "Result = %s(X, N)" nil)
    ("BETA"                   fun nil                 (system) "Result = %s( Z, W)" (("DOUBLE")))
    ("BILINEAR"               fun nil                 (system) "Result = %s(P, IX, JY)" nil)
    ("BIN_DATE"               fun nil                 (system) "Result = %s(Ascii_Time)" nil)
    ("BINARY_TEMPLATE"        fun nil                 (system) "Template = %s ( [Filename])" (("CANCEL") ("GROUP") ("N_ROWS") ("TEMPLATE")))
    ("BINDGEN"                fun nil                 (system) "Result = %s(D1, ...,D8)" nil)
    ("BINOMIAL"               fun nil                 (system) "Result = %s(V, N, P)" (("DOUBLE") ("GAUSSIAN")))
    ("BLK_CON"                fun nil                 (system) "Result = %s( Filter, Signal)" (("B_LENGTH") ("DOUBLE")))
    ("BROYDEN"                fun nil                 (system) "Result = %s( X, Vecfunc)" (("CHECK") ("DOUBLE") ("EPS") ("ITMAX") ("STEPMAX") ("TOLF") ("TOLMIN") ("TOLX")))
    ("BYTARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("BYTE"                   fun nil                 (system) "Result = %s( Expression[, Offset [, Dim1, ..., Dim8]] )" nil)
    ("BYTSCL"                 fun nil                 (system) "Result = %s( Array)" (("MAX") ("MIN") ("NAN") ("TOP")))
    ("C_CORRELATE"            fun nil                 (system) "Result = %s( X, Y, Lag)" (("COVARIANCE") ("DOUBLE")))
    ("CALL_EXTERNAL"          fun nil                 (system) "Result = %s(Image, Entry [, P0, ..., PN-1])" (("ALL_VALUE") ("AUTOGLUE") ("B_VALUE") ("CC") ("CDECL") ("COMPILE_DIRECTORY") ("D_VALUE") ("DEFAULT") ("EXTRA_CFLAGS") ("EXTRA_LFLAGS") ("F_VALUE") ("I_VALUE") ("IGNORE_EXISTING_GLUE") ("L64_VALUE") ("LD") ("NOCLEANUP") ("PORTABLE") ("RETURN_TYPE") ("S_VALUE") ("SHOW_ALL_OUTPUT") ("UI_VALUE") ("UL64_VALUE") ("UL_VALUE") ("UNLOAD") ("VALUE") ("VAX_FLOAT") ("VERBOSE") ("WRITE_WRAPPER")))
    ("CALL_FUNCTION"          fun nil                 (system) "Result = %s(Name [, P1, ..., Pn])" nil)
    ("CALL_METHOD"            fun nil                 (system) "Result = %s, Name, ObjRef, [, P1, ..., Pn]" nil)
    ("CDF_ATTCREATE"          fun nil                 (system) "Result = %s( Id, Attribute_Name)" (("GLOBAL_SCOPE") ("VARIABLE_SCOPE")))
    ("CDF_ATTEXISTS"          fun nil                 (system) "Result = %s( Id, Attribute [, EntryNum])" (("ZVARIABLE")))
    ("CDF_ATTNUM"             fun nil                 (system) "Result = %s(Id, Attribute_Name)" nil)
    ("CDF_CREATE"             fun nil                 (system) "Result = %s( Filename, [Dimensions])" (("ALPHAOSF1_DECODING") ("ALPHAOSF1_ENCODING") ("ALPHAVMSD_DECODING") ("ALPHAVMSD_ENCODING") ("ALPHAVMSG_DECODING") ("ALPHAVMSG_ENCODING") ("CLOBBER") ("COL_MAJOR") ("DECSTATION_DECODING") ("DECSTATION_ENCODING") ("HOST_DECODING") ("HOST_ENCODING") ("HP_DECODING") ("HP_ENCODING") ("IBMPC_DECODING") ("IBMPC_ENCODING") ("IBMRS_DECODING") ("IBMRS_ENCODING") ("MAC_DECODING") ("MAC_ENCODING") ("MULTI_FILE") ("NETWORK_DECODING") ("NETWORK_ENCODING") ("NEXT_DECODING") ("NEXT_ENCODING") ("ROW_MAJOR") ("SGI_DECODING") ("SGI_ENCODING") ("SINGLE_FILE") ("SUN_DECODING") ("SUN_ENCODING")))
    ("CDF_ENCODE_EPOCH"       fun nil                 (system) "Result = %s(Epoch)" (("EPOCH")))
    ("CDF_ERROR"              fun nil                 (system) "Result = %s(Status)" nil)
    ("CDF_EXISTS"             fun nil                 (system) "Result = %s( )" nil)
    ("CDF_INQUIRE"            fun nil                 (system) "Result = %s(Id)" nil)
    ("CDF_OPEN"               fun nil                 (system) "Result = %s(Filename)" nil)
    ("CDF_PARSE_EPOCH"        fun nil                 (system) "Result = %s(Epoch_string)" nil)
    ("CDF_VARCREATE"          fun nil                 (system) "Result = %s( Id, Name [, DimVary])" (("ALLOCATERECS") ("CDF_BYTE") ("CDF_CHAR") ("CDF_DOUBLE") ("CDF_EPOCH") ("CDF_FLOAT") ("CDF_INT1") ("CDF_INT2") ("CDF_INT4") ("CDF_REAL4") ("CDF_REAL8") ("CDF_UCHAR") ("CDF_UINT1") ("CDF_UINT2") ("CDF_UINT4") ("DIMENSIONS") ("NUMELEM") ("REC_NOVARY") ("REC_VARY") ("ZVARIABLE")))
    ("CDF_VARINQ"             fun nil                 (system) "Result = %s( Id, Variable)" (("ZVARIABLE")))
    ("CDF_VARNUM"             fun nil                 (system) "Result = %s( Id, VarName [, IsZVar] )" nil)
    ("CEIL"                   fun nil                 (system) "Result = %s(X)" (("L64")))
    ("CHEBYSHEV"              fun nil                 (system) "Result = %s(D, N)" nil)
    ("CHECK_MATH"             fun nil                 (system) "Result = %s()" (("MASK") ("NOCLEAR") ("PRINT")))
    ("CHISQR_CVF"             fun nil                 (system) "Result = %s(P, Df)" nil)
    ("CHISQR_PDF"             fun nil                 (system) "Result = %s(V, Df)" nil)
    ("CHOLSOL"                fun nil                 (system) "Result = %s( A, P, B)" (("DOUBLE")))
    ("CINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil)
    ("CLUST_WTS"              fun nil                 (system) "Result = %s( Array)" (("DOUBLE") ("N_CLUSTERS") ("N_ITERATIONS") ("VARIABLE_WTS")))
    ("CLUSTER"                fun nil                 (system) "Result = %s( Array, Weights)" (("DOUBLE") ("N_CLUSTERS")))
    ("COLOR_QUAN"             fun nil                 (system) "Result = %s( Image_R, Image_G, Image_B, R, G, B) or Result = COLOR_QUAN( Image, Dim, R, G, B )" (("COLORS") ("CUBE") ("DITHER") ("ERROR") ("GET_TRANSLATION") ("MAP_ALL") ("TRANSLATION")))
    ("COLORMAP_APPLICABLE"    fun nil                 (system) "Result = %s( redrawRequired )" nil)
    ("COMFIT"                 fun nil                 (system) "Result = %s( X, Y, A)" (("EXPONENTIAL") ("GEOMETRIC") ("GOMPERTZ") ("HYPERBOLIC") ("LOGISTIC") ("LOGSQUARE") ("SIGMA") ("WEIGHTS") ("YFIT")))
    ("COMPLEX"                fun nil                 (system) "Result = %s( Real [, Imaginary] ) or Result = COMPLEX(Expression, Offset, Dim1 [, ..., Dim8])" nil)
    ("COMPLEXARR"             fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("COMPLEXROUND"           fun nil                 (system) "Result = %s(Input)" nil)
    ("COMPUTE_MESH_NORMALS"   fun nil                 (system) "Result = %s( fVerts[, iConn] )" nil)
    ("COND"                   fun nil                 (system) "Result = %s( A)" (("DOUBLE")))
    ("CONGRID"                fun nil                 (system) "Result = %s( Array, X, Y, Z)" (("CUBIC") ("INTERP") ("MINUS_ONE")))
    ("CONJ"                   fun nil                 (system) "Result = %s(X)" nil)
    ("CONVERT_COORD"          fun nil                 (system) "Result = %s( X [, Y [, Z]])" (("DATA") ("DEVICE") ("DOUBLE") ("NORMAL") ("T3D") ("TO_DATA") ("TO_DEVICE") ("TO_NORMAL")))
    ("CONVOL"                 fun nil                 (system) "Result = %s( Array, Kernel [, Scale_Factor])" (("CENTER") ("EDGE_TRUNCATE") ("EDGE_WRAP")))
    ("COORD2TO3"              fun nil                 (system) "Result = %s( Mx, My, Dim, D0 [, PTI] )" nil)
    ("CORRELATE"              fun nil                 (system) "Result = %s( X [, Y])" (("COVARIANCE") ("DOUBLE")))
    ("COS"                    fun nil                 (system) "Result = %s(X)" nil)
    ("COSH"                   fun nil                 (system) "Result = %s(X)" nil)
    ("CRAMER"                 fun nil                 (system) "Result = %s( A, B)" (("DOUBLE") ("ZERO")))
    ("CREATE_STRUCT"          fun nil                 (system) "Result = %s( [Tag1, Value1, ..., Tagn, Valuen] ) or Result = CREATE_STRUCT()" (("NAME")))
    ("CROSSP"                 fun nil                 (system) "Result = %s(V1, V2)" nil)
    ("CRVLENGTH"              fun nil                 (system) "Result = %s( X, Y)" (("DOUBLE")))
    ("CT_LUMINANCE"           fun nil                 (system) "Result = %s( [R, G, B])" (("BRIGHT") ("DARK") ("READ_TABLES")))
    ("CTI_TEST"               fun nil                 (system) "Result = %s( Obfreq)" (("COEFF") ("CORRECTED") ("CRAMV") ("DF") ("EXFREQ") ("RESIDUAL")))
    ("CURVEFIT"               fun nil                 (system) "Result = %s( X, Y, Weights, A [, Sigma])" (("CHISQ") ("DOUBLE") ("FUNCTION_NAME") ("ITER") ("ITMAX") ("NODERIVATIVE") ("TOL")))
    ("CV_COORD"               fun nil                 (system) "Result = %s()" (("DEGREES") ("DOUBLE") ("FROM_CYLIN") ("FROM_POLAR") ("FROM_RECT") ("FROM_SPHERE") ("TO_CYLIN") ("TO_POLAR") ("TO_RECT") ("TO_SPHERE")))
    ("CVTTOBM"                fun nil                 (system) "Result = %s( Array)" (("THRESHOLD")))
    ("CW_ANIMATE"             fun nil                 (system) "Result = %s( Parent, Sizex, Sizey, Nframes)" (("NO_KILL") ("OPEN_FUNC") ("PIXMAPS") ("TRACK") ("UNAME") ("UVALUE")))
    ("CW_ARCBALL"             fun nil                 (system) "Result = %s( Parent)" (("COLORS") ("FRAME") ("LABEL") ("RETAIN") ("SIZE") ("UNAME") ("UPDATE") ("UVALUE") ("VALUE")))
    ("CW_BGROUP"              fun nil                 (system) "Result = %s( Parent, Names)" (("BUTTON_UVALUE") ("COLUMN") ("EVENT_FUNC") ("EXCLUSIVE") ("FONT") ("FRAME") ("IDS") ("LABEL_LEFT") ("LABEL_TOP") ("MAP") ("NO_RELEASE") ("NONEXCLUSIVE") ("RETURN_ID") ("RETURN_INDEX") ("RETURN_NAME") ("ROW") ("SCROLL") ("SET_VALUE") ("SPACE") ("UNAME") ("UVALUE") ("X_SCROLL_SIZE") ("XOFFSET") ("XPAD") ("XSIZE") ("Y_SCROLL_SIZE") ("YOFFSET") ("YPAD") ("YSIZE")))
    ("CW_CLR_INDEX"           fun nil                 (system) "Result = %s( Parent)" (("COLOR_VALUES") ("EVENT_FUNC") ("FRAME") ("LABEL") ("NCOLORS") ("START_COLOR") ("UNAME") ("UVALUE") ("VALUE") ("XSIZE") ("YSIZE")))
    ("CW_COLORSEL"            fun nil                 (system) "Result = %s( Parent)" (("FRAME") ("UNAME") ("UVALUE") ("XOFFSET") ("YOFFSET")))
    ("CW_DEFROI"              fun nil                 (system) "Result = %s( Draw)" (("IMAGE_SIZE") ("OFFSET") ("ORDER") ("RESTORE") ("ZOOM")))
    ("CW_FIELD"               fun nil                 (system) "Result = %s( Parent)" (("ALL_EVENTS") ("COLUMN") ("FIELDFONT") ("FLOATING") ("FONT") ("FRAME") ("INTEGER") ("LONG") ("NOEDIT") ("RETURN_EVENTS") ("ROW") ("STRING") ("TEXT_FRAME") ("TITLE") ("UNAME") ("UVALUE") ("VALUE") ("XSIZE") ("YSIZE")))
    ("CW_FILESEL"             fun nil                 (system) "Result = %s ( Parent)" (("FILENAME") ("FILTER") ("FIX_FILTER") ("FRAME") ("IMAGE_FILTER") ("MULTIPLE") ("PATH") ("SAVE") ("UNAME") ("UVALUE") ("WARN_EXIST")))
    ("CW_FORM"                fun nil                 (system) "Result = %s( [Parent,] Desc)" (("COLUMN") ("IDS") ("TITLE") ("UNAME") ("UVALUE")))
    ("CW_FSLIDER"             fun nil                 (system) "Result = %s( Parent)" (("DRAG") ("EDIT") ("FORMAT") ("FRAME") ("MAXIMUM") ("MINIMUM") ("SCROLL") ("SUPRESS_VALUE") ("TITLE") ("UNAME") ("UVALUE") ("VALUE") ("VERTICAL") ("XSIZE") ("YSIZE")))
    ("CW_LIGHT_EDITOR"        fun nil                 (system) "Result = %s (Parent)" (("DIRECTION_DISABLED") ("DRAG_EVENTS") ("FRAME") ("HIDE_DISABLED") ("LIGHT") ("LOCATION_DISABLED") ("TYPE_DISABLED") ("UVALUE") ("XRANGE") ("XSIZE") ("YRANGE") ("YSIZE") ("ZRANGE")))
    ("CW_ORIENT"              fun nil                 (system) "Result = %s( Parent)" (("AX") ("AZ") ("FRAME") ("TITLE") ("UNAME") ("UVALUE") ("XSIZE") ("YSIZE")))
    ("CW_PALETTE_EDITOR"      fun nil                 (system) "Result = %s (Parent)" (("DATA") ("FRAME") ("HISTOGRAM") ("HORIZONTAL") ("SELECTION") ("UNAME") ("UVALUE") ("XSIZE") ("YSIZE")))
    ("CW_PDMENU"              fun nil                 (system) "Result = %s( Parent, Desc)" (("COLUMN") ("DELIMITER") ("FONT") ("HELP") ("IDS") ("MBAR") ("RETURN_FULL_NAME") ("RETURN_ID") ("RETURN_INDEX") ("RETURN_NAME") ("UNAME") ("UVALUE") ("XOFFSET") ("YOFFSET")))
    ("CW_RGBSLIDER"           fun nil                 (system) "Result = %s( Parent)" (("CMY") ("COLOR_INDEX") ("DRAG") ("FRAME") ("GRAPHICS_LEVEL") ("HLS") ("HSV") ("LENGTH") ("RGB") ("UNAME") ("UVALUE") ("VALUE") ("VERTICAL")))
    ("CW_TMPL"                fun nil                 (system) "Result = %s( Parent)" (("UNAME") ("UVALUE")))
    ("CW_ZOOM"                fun nil                 (system) "Result = %s( Parent)" (("FRAME") ("MAX") ("MIN") ("RETAIN") ("SAMPLE") ("SCALE") ("TRACK") ("UNAME") ("UVALUE") ("X_SCROLL_SIZE") ("X_ZSIZE") ("XSIZE") ("Y_SCROLL_SIZE") ("Y_ZSIZE") ("YSIZE")))
    ("DBLARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("DCINDGEN"               fun nil                 (system) "Result = %s( D1, ..., D8 )" nil)
    ("DCOMPLEX"               fun nil                 (system) "Result = %s( Real [, Imaginary] ) or Result = DCOMPLEX( Expression, Offset, Dim1 [, ..., Dim8] )" nil)
    ("DCOMPLEXARR"            fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("DEFROI"                 fun nil                 (system) "Result = %s( Sx, Sy [, Xverts, Yverts])" (("NOFILL") ("NOREGION") ("RESTORE") ("X0") ("Y0") ("ZOOM")))
    ("DEMO_MODE"              fun nil                 (system) "Result = %s()" nil)
    ("DERIV"                  fun nil                 (system) "Result = %s([X,] Y)" nil)
    ("DERIVSIG"               fun nil                 (system) "Result = %s( [X, Y, Sigx,] Sigy )" nil)
    ("DETERM"                 fun nil                 (system) "Result = %s( A)" (("CHECK") ("DOUBLE") ("ZERO")))
    ("DIALOG_MESSAGE"         fun nil                 (system) "Result = %s( Message_Text)" (("CANCEL") ("DEFAULT_CANCEL") ("DEFAULT_NO") ("DIALOG_PARENT") ("DISPLAY_NAME") ("ERROR") ("INFORMATION") ("QUESTION") ("RESOURCE_NAME") ("TITLE")))
    ("DIALOG_PICKFILE"        fun nil                 (system) "Result = %s()" (("DIALOG_PARENT") ("DIRECTORY") ("DISPLAY_NAME") ("FILE") ("FILTER") ("FIX_FILTER") ("GET_PATH") ("GROUP") ("MULTIPLE_FILES") ("MUST_EXIST") ("PATH") ("READ") ("RESOURCE_NAME") ("TITLE") ("WRITE")))
    ("DIALOG_PRINTERSETUP"    fun nil                 (system) "Result = %s( [PrintDestination])" (("DIALOG_PARENT") ("DISPLAY_NAME") ("RESOURCE_NAME") ("TITLE")))
    ("DIALOG_PRINTJOB"        fun nil                 (system) "Result = %s( [PrintDestination])" (("DIALOG_PARENT") ("DISPLAY_NAME") ("RESOURCE_NAME") ("TITLE")))
    ("DIALOG_READ_IMAGE"      fun nil                 (system) "Result = %s ( [Filename])" (("BLUE") ("DIALOG_PARENT") ("FILE") ("FILTER_TYPE") ("FIX_FILTER") ("GET_PATH") ("GREEN") ("IMAGE") ("PATH") ("QUERY") ("RED") ("TITLE")))
    ("DIALOG_WRITE_IMAGE"     fun nil                 (system) "Result = %s ( Image [, R, G, B])" (("DIALOG_PARENT") ("FILE") ("FIX_TYPE") ("NOWRITE") ("OPTIONS") ("PATH") ("TITLE") ("TYPE") ("WARN_EXIST")))
    ("DIGITAL_FILTER"         fun nil                 (system) "Result = %s( Flow, Fhigh, A, Nterms )" nil)
    ("DILATE"                 fun nil                 (system) "Result = %s( Image, Structure [, X0 [, Y0 [, Z0]]])" (("BACKGROUND") ("CONSTRAINED") ("GRAY") ("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")))
    ("DINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil)
    ("DIST"                   fun nil                 (system) "Result = %s(N [, M])" nil)
    ("DOUBLE"                 fun nil                 (system) "Result = %s(Expression[, Offset [, Dim1, ..., Dimn]])" nil)
    ("EIGENQL"                fun nil                 (system) "Result = %s( A)" (("ABSOLUTE") ("ASCENDING") ("DOUBLE") ("EIGENVECTORS") ("OVERWRITE") ("RESIDUAL")))
    ("EIGENVEC"               fun nil                 (system) "Result = %s( A, Eval)" (("DOUBLE") ("ITMAX") ("RESIDUAL")))
    ("ELMHES"                 fun nil                 (system) "Result = %s( A)" (("COLUMN") ("DOUBLE") ("NO_BALANCE")))
    ("EOF"                    fun nil                 (system) "Result = %s(Unit)" nil)
    ("EOS_EH_CONVANG"         fun nil                 (system) "Result = %s(inAngle, code)" nil)
    ("EOS_EH_GETVERSION"      fun nil                 (system) "Result = %s(fid, version)" nil)
    ("EOS_EH_IDINFO"          fun nil                 (system) "Result = %s(fid, HDFfid, sdInterfaceID)" nil)
    ("EOS_EXISTS"             fun nil                 (system) "Result = %s( )" nil)
    ("EOS_GD_ATTACH"          fun nil                 (system) "Result = %s(fid, gridname)" nil)
    ("EOS_GD_ATTRINFO"        fun nil                 (system) "Result = %s(gridID, attrname, numbertype, count)" nil)
    ("EOS_GD_BLKSOMOFFSET"    fun nil                 (system) "Result = %s(gridID, offset, code)" nil)
    ("EOS_GD_CLOSE"           fun nil                 (system) "Result = %s(fid)" nil)
    ("EOS_GD_COMPINFO"        fun nil                 (system) "Result = %s(gridID, fieldname, compcode, compparm)" nil)
    ("EOS_GD_CREATE"          fun nil                 (system) "Result = %s(fid, gridname, xdimsize, ydimsize, upleftpt, lowrightpt)" nil)
    ("EOS_GD_DEFBOXREGION"    fun nil                 (system) "Result = %s(gridID, cornerlon, cornerlat)" nil)
    ("EOS_GD_DEFCOMP"         fun nil                 (system) "Result = %s(gridID, compcode [, compparm] )" nil)
    ("EOS_GD_DEFDIM"          fun nil                 (system) "Result = %s(gridID, dimname, dim)" nil)
    ("EOS_GD_DEFFIELD"        fun nil                 (system) "Result = %s(gridID, fieldname, dimlist, numbertype)" (("MERGE")))
    ("EOS_GD_DEFORIGIN"       fun nil                 (system) "Result = %s(gridID, origincode)" nil)
    ("EOS_GD_DEFPIXREG"       fun nil                 (system) "Result = %s(gridID, pixreg)" nil)
    ("EOS_GD_DEFPROJ"         fun nil                 (system) "Result = %s(gridID, projcode, zonecode, spherecode, projparm)" nil)
    ("EOS_GD_DEFTILE"         fun nil                 (system) "Result = %s( gridID, tilecode [, tilerank, tiledims] )" nil)
    ("EOS_GD_DEFTIMEPERIOD"   fun nil                 (system) "Result = %s(gridID, periodID, starttime, stoptime)" nil)
    ("EOS_GD_DEFVRTREGION"    fun nil                 (system) "Result = %s(gridID, regionID, vertObj, range)" nil)
    ("EOS_GD_DETACH"          fun nil                 (system) "Result = %s(gridID)" nil)
    ("EOS_GD_DIMINFO"         fun nil                 (system) "Result = %s(gridID, dimname)" nil)
    ("EOS_GD_DUPREGION"       fun nil                 (system) "Result = %s(regionID)" nil)
    ("EOS_GD_EXTRACTREGION"   fun nil                 (system) "Result = %s(gridID, regionID, fieldname, buffer)" nil)
    ("EOS_GD_FIELDINFO"       fun nil                 (system) "Result = %s(gridID, fieldname, rank, dims, numbertype, dimlist)" nil)
    ("EOS_GD_GETFILLVALUE"    fun nil                 (system) "Result = %s(gridID, fieldname, fillvalue)" nil)
    ("EOS_GD_GETPIXELS"       fun nil                 (system) "Result = %s(gridID, nLonLat, lonVal, latVal, pixRow, pixCol)" nil)
    ("EOS_GD_GETPIXVALUES"    fun nil                 (system) "Result = %s(gridID, nPixels, pixRow, pixCol, fieldname, buffer)" nil)
    ("EOS_GD_GRIDINFO"        fun nil                 (system) "Result = %s(gridID, xdimsize, ydimsize, upleft, lowright)" nil)
    ("EOS_GD_INQATTRS"        fun nil                 (system) "Result = %s( gridID, attrlist)" (("LENGTH")))
    ("EOS_GD_INQDIMS"         fun nil                 (system) "Result = %s(gridID, dimname, dims)" nil)
    ("EOS_GD_INQFIELDS"       fun nil                 (system) "Result = %s(gridID, fieldlist, rank, numbertype)" nil)
    ("EOS_GD_INQGRID"         fun nil                 (system) "Result = %s( filename, gridlist)" (("LENGTH")))
    ("EOS_GD_INTERPOLATE"     fun nil                 (system) "Result = %s(gridID, Interp, lonVal, latVal, fieldname, interpVal)" nil)
    ("EOS_GD_NENTRIES"        fun nil                 (system) "Result = %s( gridID, entrycode)" (("LENGTH")))
    ("EOS_GD_OPEN"            fun nil                 (system) "Result = %s( filename, access)" (("CREATE") ("RDWR") ("READ")))
    ("EOS_GD_ORIGININFO"      fun nil                 (system) "Result = %s(gridID, origincode)" nil)
    ("EOS_GD_PIXREGINFO"      fun nil                 (system) "Result = %s(gridID, pixregcode)" nil)
    ("EOS_GD_PROJINFO"        fun nil                 (system) "Result = %s(gridID, projcode, zonecode, spherecode, projparm)" nil)
    ("EOS_GD_QUERY"           fun nil                 (system) "Result = %s( Filename, GridName, [Info])" nil)
    ("EOS_GD_READATTR"        fun nil                 (system) "Result = %s(gridID, attrname, datbuf)" nil)
    ("EOS_GD_READFIELD"       fun nil                 (system) "Result = %s( gridID, fieldname, buffer)" (("EDGE") ("START") ("STRIDE")))
    ("EOS_GD_READTILE"        fun nil                 (system) "Result = %s(gridID, fieldname, tilecoords, buffer)" nil)
    ("EOS_GD_REGIONINFO"      fun nil                 (system) "Result = %s(gridID, regionID, fieldname, ntype, rank, dims, size, upleftpt, lowrightpt)" nil)
    ("EOS_GD_SETFILLVALUE"    fun nil                 (system) "Result = %s(gridID, fieldname, fillvalue)" nil)
    ("EOS_GD_SETTILECACHE"    fun nil                 (system) "Result = %s(gridID, fieldname, maxcache, cachecode)" nil)
    ("EOS_GD_TILEINFO"        fun nil                 (system) "Result = %s(gridID, fieldname, tilecode, tilerank, tiledims)" nil)
    ("EOS_GD_WRITEATTR"       fun nil                 (system) "Result = %s( gridID, attrname, datbuf)" (("COUNT") ("HDF_TYPE")))
    ("EOS_GD_WRITEFIELD"      fun nil                 (system) "Result = %s( gridID, fieldname, data)" (("EDGE") ("START") ("STRIDE")))
    ("EOS_GD_WRITEFIELDMETA"  fun nil                 (system) "Result = %s(gridID, fieldname, dimlist, numbertype)" nil)
    ("EOS_GD_WRITETILE"       fun nil                 (system) "Result = %s(gridID, fieldname, tilecoords, data)" nil)
    ("EOS_PT_ATTACH"          fun nil                 (system) "Result = %s(fid, pointname)" nil)
    ("EOS_PT_ATTRINFO"        fun nil                 (system) "Result = %s( pointID, attrname, numbertype, count)" nil)
    ("EOS_PT_BCKLINKINFO"     fun nil                 (system) "Result = %s(pointID, level, linkfield)" nil)
    ("EOS_PT_CLOSE"           fun nil                 (system) "Result = %s(fid)" nil)
    ("EOS_PT_CREATE"          fun nil                 (system) "Result = %s(fid, pointname)" nil)
    ("EOS_PT_DEFBOXREGION"    fun nil                 (system) "Result = %s(pointID, cornerlon, cornerlat)" nil)
    ("EOS_PT_DEFLEVEL"        fun nil                 (system) "Result = %s(pointID, levelname, fieldlist, fieldtype, fieldorder)" nil)
    ("EOS_PT_DEFLINKAGE"      fun nil                 (system) "Result = %s(pointID, parent, child, linkfield)" nil)
    ("EOS_PT_DEFTIMEPERIOD"   fun nil                 (system) "Result = %s(pointID, starttime, stoptime)" nil)
    ("EOS_PT_DEFVRTREGION"    fun nil                 (system) "Result = %s( pointID, regionID, vertObj, range)" nil)
    ("EOS_PT_DETACH"          fun nil                 (system) "Result = %s(pointID)" nil)
    ("EOS_PT_EXTRACTPERIOD"   fun nil                 (system) "Result = %s(pointID, periodID, level, fieldlist, buffer)" nil)
    ("EOS_PT_EXTRACTREGION"   fun nil                 (system) "Result = %s( pointID, regionID, level, fieldlist, buffer)" nil)
    ("EOS_PT_FWDLINKINFO"     fun nil                 (system) "Result = %s(pointID, level, linkfield)" nil)
    ("EOS_PT_GETLEVELNAME"    fun nil                 (system) "Result = %s( pointID, level, levelname)" (("LENGTH")))
    ("EOS_PT_GETRECNUMS"      fun nil                 (system) "Result = %s( pointID, inlevel, outlevel, inNrec, inRecs, outNrec, outRecs)" nil)
    ("EOS_PT_INQATTRS"        fun nil                 (system) "Result = %s( pointID, attrlist)" (("LENGTH")))
    ("EOS_PT_INQPOINT"        fun nil                 (system) "Result = %s( filename, pointlist)" (("LENGTH")))
    ("EOS_PT_LEVELINDX"       fun nil                 (system) "Result = %s( pointID, levelname)" nil)
    ("EOS_PT_LEVELINFO"       fun nil                 (system) "Result = %s(pointID, level, fieldlist, fldtype, fldorder)" nil)
    ("EOS_PT_NFIELDS"         fun nil                 (system) "Result = %s( pointID, level)" (("LENGTH")))
    ("EOS_PT_NLEVELS"         fun nil                 (system) "Result = %s(pointID)" nil)
    ("EOS_PT_NRECS"           fun nil                 (system) "Result = %s( pointID, level)" nil)
    ("EOS_PT_OPEN"            fun nil                 (system) "Result = %s( fieldname)" (("CREATE") ("RDWR") ("READ")))
    ("EOS_PT_PERIODINFO"      fun nil                 (system) "Result = %s(pointID, periodID, level, fieldlist, size)" nil)
    ("EOS_PT_PERIODRECS"      fun nil                 (system) "Result = %s(pointID, periodID, level, nrec, recs)" nil)
    ("EOS_PT_QUERY"           fun nil                 (system) "Result = %s( Filename, PointName, [Info] )" nil)
    ("EOS_PT_READATTR"        fun nil                 (system) "Result = %s(pointID, attrname, datbuf)" nil)
    ("EOS_PT_READLEVEL"       fun nil                 (system) "Result = %s(pointID, level, fieldlist, nrec, recs, buffer)" nil)
    ("EOS_PT_REGIONINFO"      fun nil                 (system) "Result = %s(pointID, regionID, level, fieldlist, size)" nil)
    ("EOS_PT_REGIONRECS"      fun nil                 (system) "Result = %s(pointID, regionID, level, nrec, recs)" nil)
    ("EOS_PT_SIZEOF"          fun nil                 (system) "Result = %s(pointID, fieldlist, fldlevel)" nil)
    ("EOS_PT_UPDATELEVEL"     fun nil                 (system) "Result = %s(pointID, level, field, list, nrec, recs, data)" nil)
    ("EOS_PT_WRITEATTR"       fun nil                 (system) "Result = %s( pointID, attrname, datbuf)" (("COUNT") ("HDF_TYPE")))
    ("EOS_PT_WRITELEVEL"      fun nil                 (system) "Result = %s(pointID, level, nrec, data)" nil)
    ("EOS_QUERY"              fun nil                 (system) "Result = %s( Filename, [Info] )" nil)
    ("EOS_SW_ATTACH"          fun nil                 (system) "Result = %s(fid, swathname)" nil)
    ("EOS_SW_ATTRINFO"        fun nil                 (system) "Result = %s(swathID, attrname, numbertype, count)" nil)
    ("EOS_SW_CLOSE"           fun nil                 (system) "Result = %s(fid)" nil)
    ("EOS_SW_COMPINFO"        fun nil                 (system) "Result = %s(swathID, fieldname, compcode, compparm)" nil)
    ("EOS_SW_CREATE"          fun nil                 (system) "Result = %s(fid, swathname)" nil)
    ("EOS_SW_DEFBOXREGION"    fun nil                 (system) "Result = %s(swathID, cornerlon, cornerlat, mode)" nil)
    ("EOS_SW_DEFCOMP"         fun nil                 (system) "Result = %s( swathID, compcode, [, compparm] )" nil)
    ("EOS_SW_DEFDATAFIELD"    fun nil                 (system) "Result = %s( swathID, fieldname, dimlist, numbertype)" (("MERGE")))
    ("EOS_SW_DEFDIM"          fun nil                 (system) "Result = %s(swathID, fieldname, dim)" nil)
    ("EOS_SW_DEFDIMMAP"       fun nil                 (system) "Result = %s(swathID, geodim, datadim, offset, increment)" nil)
    ("EOS_SW_DEFGEOFIELD"     fun nil                 (system) "Result = %s( swathID, fieldname, dimlist, numbertype)" (("MERGE")))
    ("EOS_SW_DEFIDXMAP"       fun nil                 (system) "Result = %s(swathID, geodim, datadim, index)" nil)
    ("EOS_SW_DEFTIMEPERIOD"   fun nil                 (system) "Result = %s(swathID, starttime , stoptime, mode)" nil)
    ("EOS_SW_DEFVRTREGION"    fun nil                 (system) "Result = %s(swathID, regionID, vertObj, range)" nil)
    ("EOS_SW_DETACH"          fun nil                 (system) "Result = %s(swathID)" nil)
    ("EOS_SW_DIMINFO"         fun nil                 (system) "Result = %s(swathID, dimname)" nil)
    ("EOS_SW_DUPREGION"       fun nil                 (system) "Result = %s(regionID)" nil)
    ("EOS_SW_EXTRACTPERIOD"   fun nil                 (system) "Result = %s(swathID, periodID, fieldname, external_mode, buffer)" nil)
    ("EOS_SW_EXTRACTREGION"   fun nil                 (system) "Result = %s(swathID, regionID, fieldname, external_mode, buffer)" nil)
    ("EOS_SW_FIELDINFO"       fun nil                 (system) "Result = %s(swathID, fieldname, rank, dims, numbertype, dimlist)" nil)
    ("EOS_SW_GETFILLVALUE"    fun nil                 (system) "Result = %s(swathID, fieldname, fillvalue)" nil)
    ("EOS_SW_IDXMAPINFO"      fun nil                 (system) "Result = %s(swathID, geodim, datadim, index)" nil)
    ("EOS_SW_INQATTRS"        fun nil                 (system) "Result = %s( swathID, attrlist)" (("LENGTH")))
    ("EOS_SW_INQDATAFIELDS"   fun nil                 (system) "Result = %s(swathID, fieldlist, rank, numbertype)" nil)
    ("EOS_SW_INQDIMS"         fun nil                 (system) "Result = %s(swathID, dimname, dim)" nil)
    ("EOS_SW_INQGEOFIELDS"    fun nil                 (system) "Result = %s(swathID, fieldlist, rank, numbertype)" nil)
    ("EOS_SW_INQIDXMAPS"      fun nil                 (system) "Result = %s(swathID, idxmap, idxsizes)" nil)
    ("EOS_SW_INQMAPS"         fun nil                 (system) "Result = %s(swathID, dimmap, offset, increment)" nil)
    ("EOS_SW_INQSWATH"        fun nil                 (system) "Result = %s( filename, swathlist)" (("LENGTH")))
    ("EOS_SW_MAPINFO"         fun nil                 (system) "Result = %s(swathID, geodim, datadim, offset, increment)" nil)
    ("EOS_SW_NENTRIES"        fun nil                 (system) "Result = %s( swathID, entrycode)" (("LENGTH")))
    ("EOS_SW_OPEN"            fun nil                 (system) "Result = %s( filename)" (("CREATE") ("RDWR") ("READ")))
    ("EOS_SW_PERIODINFO"      fun nil                 (system) "Result = %s(swathID, periodID, fieldname, ntype, rank, dims, size)" nil)
    ("EOS_SW_QUERY"           fun nil                 (system) "Result=%s(Filename, SwathName, [Info])" nil)
    ("EOS_SW_READATTR"        fun nil                 (system) "Result = %s(swathID, attrname, datbuf)" nil)
    ("EOS_SW_READFIELD"       fun nil                 (system) "Result = %s( swathID, fieldname, buffer)" (("EDGE") ("START") ("STRIDE")))
    ("EOS_SW_REGIONINFO"      fun nil                 (system) "Result = %s(swathID, regionID, fieldname, ntype, rank, dims, size)" nil)
    ("EOS_SW_SETFILLVALUE"    fun nil                 (system) "Result = %s(swathID, fieldname, fillvalue)" nil)
    ("EOS_SW_WRITEATTR"       fun nil                 (system) "Result = %s( swathID, attrname, datbuf)" (("COUNT") ("HDF_TYPE")))
    ("EOS_SW_WRITEDATAMETA"   fun nil                 (system) "Result = %s(swathID, fieldname, dimlist, numbertype)" nil)
    ("EOS_SW_WRITEFIELD"      fun nil                 (system) "Result = %s( swathID, fieldname, cut, data)" (("EDGE") ("START") ("STRIDE")))
    ("EOS_SW_WRITEGEOMETA"    fun nil                 (system) "Result = %s(swathID, fieldname, dimlist, numbertype)" nil)
    ("ERODE"                  fun nil                 (system) "Result = %s( Image, Structure [, X0 [, Y0 [, Z0]]])" (("GRAY") ("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")))
    ("ERRORF"                 fun nil                 (system) "Result = %s(X)" nil)
    ("EXECUTE"                fun nil                 (system) "Result = %s(String [, QuietCompile])" nil)
    ("EXP"                    fun nil                 (system) "Result = %s(Expression)" nil)
    ("EXPAND_PATH"            fun nil                 (system) "Result = %s( String)" (("ALL_DIRS") ("ARRAY") ("COUNT") ("DLM") ("HELP")))
    ("EXPINT"                 fun nil                 (system) "Result = %s( N, X)" (("DOUBLE") ("EPS") ("ITMAX")))
    ("EXTRAC"                 fun nil                 (system) "Result = %s( Array, C1, C2, ..., Cn, S1, S2, ..., Sn )" nil)
    ("EXTRACT_SLICE"          fun nil                 (system) "Result = %s( Vol, Xsize, Ysize, Xcenter, Ycenter, Zcenter, Xrot, Yrot, Zrot)" (("ANISOTROPY") ("CUBIC") ("OUT_VAL") ("RADIANS") ("SAMPLE") ("VERTICES")))
    ("F_CVF"                  fun nil                 (system) "Result = %s(P, Dfn, Dfd)" nil)
    ("F_PDF"                  fun nil                 (system) "Result = %s(V, Dfn, Dfd)" nil)
    ("FACTORIAL"              fun nil                 (system) "Result = %s( N)" (("STIRLING") ("UL64")))
    ("FFT"                    fun nil                 (system) "Result = %s( Array [, Direction])" (("DOUBLE") ("INVERSE") ("OVERWRITE")))
    ("FILE_EXPAND_PATH"       fun nil                 (system) "Result = %s (Path)" nil)
    ("FILE_TEST"              fun nil                 (system) "Result = %s( File)" (("BLOCK_SPECIAL") ("CHARACTER_SPECIAL") ("DANGLING_SYMLINK") ("DIRECTORY") ("EXECUTABLE") ("GET_MODE") ("GROUP") ("NAMED_PIPE") ("READ") ("REGULAR") ("SETGID") ("SETUID") ("SOCKET") ("STICKY_BIT") ("SYMLINK") ("USER") ("WRITE") ("ZERO_LENGTH")))
    ("FILE_WHICH"             fun nil                 (system) "Result = %s( [Path, ] File)" (("INCLUDE_CURRENT_DIR")))
    ("FILEPATH"               fun nil                 (system) "Result = %s( Filename)" (("ROOT_DIR") ("SUBDIRECTORY") ("TERMINAL") ("TMP")))
    ("FINDFILE"               fun nil                 (system) "Result = %s( File_Specification)" (("COUNT")))
    ("FINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil)
    ("FINITE"                 fun nil                 (system) "Result = %s( X)" (("INFINITY") ("NAN")))
    ("FIX"                    fun nil                 (system) "Result = %s( Expression [, Offset [, Dim1, ..., Dim8]])" (("PRINT") ("TYPE")))
    ("FLOAT"                  fun nil                 (system) "Result = %s( Expression [, Offset [, Dim1, ..., Dim8]] )" nil)
    ("FLOOR"                  fun nil                 (system) "Result = %s(X)" (("L64")))
    ("FLTARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("FORMAT_AXIS_VALUES"     fun nil                 (system) "Result = %s( Values )" nil)
    ("FSTAT"                  fun nil                 (system) "Result = %s(Unit)" nil)
    ("FULSTR"                 fun nil                 (system) "Result = %s(A)" nil)
    ("FV_TEST"                fun nil                 (system) "Result = %s(X, Y)" nil)
    ("FX_ROOT"                fun nil                 (system) "Result = %s(X, Func)" (("DOUBLE") ("ITMAX") ("STOP") ("TOL")))
    ("FZ_ROOTS"               fun nil                 (system) "Result = %s(C)" (("DOUBLE") ("EPS") ("NO_POLISH")))
    ("GAMMA"                  fun nil                 (system) "Result = %s(X)" nil)
    ("GAUSS2DFIT"             fun nil                 (system) "Result = %s( Z, A [, X, Y])" (("NEGATIVE") ("TILT")))
    ("GAUSS_CVF"              fun nil                 (system) "Result = %s(P)" nil)
    ("GAUSS_PDF"              fun nil                 (system) "Result = %s(V)" nil)
    ("GAUSSFIT"               fun nil                 (system) "Result = %s( X, Y [, A])" (("ESTIMATES") ("NTERMS")))
    ("GAUSSINT"               fun nil                 (system) "Result = %s(X)" nil)
    ("GET_DRIVE_LIST"         fun nil                 (system) "Result = %s( )" nil)
    ("GET_KBRD"               fun nil                 (system) "Result = %s(Wait)" nil)
    ("GET_SCREEN_SIZE"        fun nil                 (system) "Result = %s( [Display_name])" (("DISPLAY_NAME") ("RESOLUTION")))
    ("GET_SYMBOL"             fun nil                 (system) "Result = %s( Name)" (("TYPE")))
    ("GETENV"                 fun nil                 (system) "Result = %s( Name )" (("ENVIRONMENT")))
    ("GETHELP"                fun nil                 (system) "Result = %s([Variable])" nil)
    ("GRID3"                  fun nil                 (system) "Result = %s( X, Y, Z, F, Gx, Gy, Gz)" (("DELTA") ("DTOL") ("GRID") ("NGRID") ("START")))
    ("GRID_TPS"               fun nil                 (system) "Interp = %s (Xp, Yp, Values)" (("COEFFICIENTS") ("DELTA") ("NGRID") ("START")))
    ("GS_ITER"                fun nil                 (system) "Result = %s( A, B)" (("CHECK") ("DOUBLE") ("LAMBDA") ("MAX_ITER") ("TOL") ("X_0")))
    ("HANDLE_CREATE"          fun nil                 (system) "Result = %s([ID])" nil)
    ("HANDLE_INFO"            fun nil                 (system) "Result = %s(ID)" nil)
    ("HANNING"                fun nil                 (system) "Result = %s( N1 [, N2])" (("ALPHA") ("DOUBLE")))
    ("HDF_AN_ANNLEN"          fun nil                 (system) "Result = %s(ann_id)" nil)
    ("HDF_AN_ANNLIST"         fun nil                 (system) "Result = %s(an_id, annot_type, obj_tag, obj_ref, ann_list)" nil)
    ("HDF_AN_ATYPE2TAG"       fun nil                 (system) "Result = %s(annot_type)" nil)
    ("HDF_AN_CREATE"          fun nil                 (system) "Result = %s(an_id, obj_tag, obj_ref, annot_type)" nil)
    ("HDF_AN_CREATEF"         fun nil                 (system) "Result = %s(an_id, annot_type)" nil)
    ("HDF_AN_FILEINFO"        fun nil                 (system) "Result = %s(an_id, n_file_labels, n_file_descs, n_data_labels, n_data_descs)" nil)
    ("HDF_AN_GET_TAGREF"      fun nil                 (system) "Result = %s(an_id, index, annot_type, ann_tag, ann_ref)" nil)
    ("HDF_AN_ID2TAGREF"       fun nil                 (system) "Result = %s(ann_id, ann_tag, ann_ref)" nil)
    ("HDF_AN_NUMANN"          fun nil                 (system) "Result = %s(an_id, annot_type, obj_tag, obj_ref)" nil)
    ("HDF_AN_READANN"         fun nil                 (system) "Result = %s( ann_id, annotation)" (("LENGTH")))
    ("HDF_AN_SELECT"          fun nil                 (system) "Result = %s(an_id, index, annot_type)" nil)
    ("HDF_AN_START"           fun nil                 (system) "Result = %s(file_id)" nil)
    ("HDF_AN_TAG2ATYPE"       fun nil                 (system) "Result = %s(ann_tag)" nil)
    ("HDF_AN_TAGREF2ID"       fun nil                 (system) "Result = %s(an_id, ann_tag, ann_ref)" nil)
    ("HDF_AN_WRITEANN"        fun nil                 (system) "Result = %s( ann_id, annotation)" (("LENGTH")))
    ("HDF_BROWSER"            fun nil                 (system) "Template = %s([Filename])" (("CANCEL") ("GROUP") ("PREFIX")))
    ("HDF_DF24_LASTREF"       fun nil                 (system) "Result = %s( )" nil)
    ("HDF_DF24_NIMAGES"       fun nil                 (system) "Result = %s(Filename)" nil)
    ("HDF_DFAN_LABLIST"       fun nil                 (system) "Result = %s( Filename, Tag, Reflist, Labellist)" (("LISTSIZE") ("MAXLABEL") ("STARTPOS") ("STRING")))
    ("HDF_DFAN_LASTREF"       fun nil                 (system) "Result = %s( )" nil)
    ("HDF_DFP_LASTREF"        fun nil                 (system) "Result = %s( )" nil)
    ("HDF_DFP_NPALS"          fun nil                 (system) "Result = %s(Filename)" nil)
    ("HDF_DFR8_LASTREF"       fun nil                 (system) "Result = %s( )" nil)
    ("HDF_DFR8_NIMAGES"       fun nil                 (system) "Result = %s(Filename)" nil)
    ("HDF_EXISTS"             fun nil                 (system) "Result = %s( )" nil)
    ("HDF_GR_ATTRINFO"        fun nil                 (system) "Result = %s(obj_id, attr_index, name, data_type, count)" nil)
    ("HDF_GR_CREATE"          fun nil                 (system) "Result = %s(gr_id, name, ncomp, data_type, interlace_mode, dim_sizes)" nil)
    ("HDF_GR_FILEINFO"        fun nil                 (system) "Result = %s(gr_id, n_images, n_file_attrs)" nil)
    ("HDF_GR_FINDATTR"        fun nil                 (system) "Result = %s(obj_id, attr_name)" nil)
    ("HDF_GR_GETATTR"         fun nil                 (system) "Result = %s(obj_id, attr_index, values)" nil)
    ("HDF_GR_GETCHUNKINFO"    fun nil                 (system) "Result = %s(ri_id, dim_length, flag)" nil)
    ("HDF_GR_GETIMINFO"       fun nil                 (system) "Result = %s(ri_id, gr_name, ncomp, data_type, interlace_mode, dim_sizes, num_attrs)" nil)
    ("HDF_GR_GETLUTID"        fun nil                 (system) "Result = %s(ri_id, pal_index)" nil)
    ("HDF_GR_GETLUTINFO"      fun nil                 (system) "Result = %s(pal_id, ncomp, data_type, interlace_mode, num_entries)" nil)
    ("HDF_GR_IDTOREF"         fun nil                 (system) "Result = %s(ri_id)" nil)
    ("HDF_GR_LUTTOREF"        fun nil                 (system) "Result = %s(pal_id)" nil)
    ("HDF_GR_NAMETOINDEX"     fun nil                 (system) "Result = %s(gr_id, gr_name)" nil)
    ("HDF_GR_READIMAGE"       fun nil                 (system) "Result = %s( ri_id, data)" (("EDGE") ("INTERLACE") ("START") ("STRIDE")))
    ("HDF_GR_READLUT"         fun nil                 (system) "Result = %s( pal_id, pal_data)" (("INTERLACE")))
    ("HDF_GR_REFTOINDEX"      fun nil                 (system) "Result = %s(gr_id, gr_ref)" nil)
    ("HDF_GR_SELECT"          fun nil                 (system) "Result = %s(gr_id, index)" nil)
    ("HDF_GR_SETATTR"         fun nil                 (system) "Result = %s(obj_id, attr_name, data_type, count, values)" nil)
    ("HDF_GR_SETCHUNK"        fun nil                 (system) "Result = %s(ri_id, dim_length, comp_type, comp_prm)" nil)
    ("HDF_GR_SETCHUNKCACHE"   fun nil                 (system) "Result = %s(ri_id, maxcache, flags)" nil)
    ("HDF_GR_SETCOMPRESS"     fun nil                 (system) "Result = %s(ri_id, comp_type, comp_prm)" nil)
    ("HDF_GR_SETEXTERNALFILE" fun nil                 (system) "Result = %s(ri_id, filename, offset)" nil)
    ("HDF_GR_START"           fun nil                 (system) "Result = %s(file_id)" nil)
    ("HDF_GR_WRITEIMAGE"      fun nil                 (system) "Result = %s( ri_id, data)" (("EDGE") ("INTERLACE") ("START") ("STRIDE")))
    ("HDF_GR_WRITELUT"        fun nil                 (system) "Result = %s( pal_id, pal_data)" (("DATA_TYPE") ("INTERLACE_MODE") ("NENTRIES")))
    ("HDF_HDF2IDLTYPE"        fun nil                 (system) "Result = %s( hdftypecode )" nil)
    ("HDF_IDL2HDFTYPE"        fun nil                 (system) "Result = %s( idltypecode )" nil)
    ("HDF_ISHDF"              fun nil                 (system) "Result = %s(Filename)" nil)
    ("HDF_NEWREF"             fun nil                 (system) "Result = %s(FileHandle)" nil)
    ("HDF_NUMBER"             fun nil                 (system) "Result = %s( FileHandle)" (("TAG")))
    ("HDF_OPEN"               fun nil                 (system) "Result = %s( Filename)" (("ALL") ("CREATE") ("NUM_DD") ("RDWR") ("READ") ("WRITE")))
    ("HDF_PACKDATA"           fun nil                 (system) "Result = %s( data1 [, data2 [, data3 [, data4 [, data5 [, data6 [, data7 [, data8]]]]]]])" (("HDF_ORDER") ("HDF_TYPE") ("NREC")))
    ("HDF_READ"               fun nil                 (system) "Result = %s( [Filename])" (("DF24") ("DFR8") ("PREFIX") ("TEMPLATE")))
    ("HDF_SD_ATTRFIND"        fun nil                 (system) "Result = %s(S_ID, Name)" nil)
    ("HDF_SD_CREATE"          fun nil                 (system) "Result = %s( SD_ID, Name, Dims)" (("BYTE") ("DFNT_CHAR") ("DFNT_FLOAT32") ("DFNT_FLOAT64") ("DFNT_INT16") ("DFNT_INT32") ("DFNT_INT8") ("DFNT_UINT16") ("DFNT_UINT32") ("DFNT_UINT8") ("DOUBLE") ("FLOAT") ("HDF_TYPE") ("INT") ("LONG") ("SHORT") ("STRING")))
    ("HDF_SD_DIMGETID"        fun nil                 (system) "Result = %s(SDS_ID, Dimension_Number)" nil)
    ("HDF_SD_IDTOREF"         fun nil                 (system) "Result = %s(SDS_ID)" nil)
    ("HDF_SD_ISCOORDVAR"      fun nil                 (system) "Result = %s(SDS_ID)" nil)
    ("HDF_SD_NAMETOINDEX"     fun nil                 (system) "Result = %s(SD_ID, SDS_Name)" nil)
    ("HDF_SD_REFTOINDEX"      fun nil                 (system) "Result = %s(SD_ID, Refno)" nil)
    ("HDF_SD_SELECT"          fun nil                 (system) "Result = %s(SD_ID, Number)" nil)
    ("HDF_SD_START"           fun nil                 (system) "Result = %s( Filename)" (("CREATE") ("RDWR") ("READ")))
    ("HDF_VD_ATTACH"          fun nil                 (system) "Result = %s( FileHandle, VDataId)" (("READ") ("WRITE")))
    ("HDF_VD_FEXIST"          fun nil                 (system) "Result = %s(VData, Fieldnames)" nil)
    ("HDF_VD_FIND"            fun nil                 (system) "Result = %s(FileHandle, Name)" nil)
    ("HDF_VD_GETID"           fun nil                 (system) "Result = %s(FileHandle, VDataId)" nil)
    ("HDF_VD_GETNEXT"         fun nil                 (system) "Result = %s(VData, Id)" nil)
    ("HDF_VD_ISVD"            fun nil                 (system) "Result = %s(VGroup, Id)" nil)
    ("HDF_VD_LONE"            fun nil                 (system) "Result = %s( FileHandle)" (("MAXSIZE")))
    ("HDF_VD_READ"            fun nil                 (system) "Result = %s( VData, Data)" (("FIELDS") ("FULL_INTERLACE") ("NO_INTERLACE") ("NRECORDS")))
    ("HDF_VG_ATTACH"          fun nil                 (system) "Result = %s( FileHandle, VGroupId)" (("READ") ("WRITE")))
    ("HDF_VG_GETID"           fun nil                 (system) "Result = %s(FileHandle, VGroupId)" nil)
    ("HDF_VG_GETNEXT"         fun nil                 (system) "Result = %s(VGroup, Id)" nil)
    ("HDF_VG_INQTR"           fun nil                 (system) "Result = %s(VGroup, Tag, Ref)" nil)
    ("HDF_VG_ISVD"            fun nil                 (system) "Result = %s(VGroup, Id)" nil)
    ("HDF_VG_ISVG"            fun nil                 (system) "Result = %s(VGroup, Id)" nil)
    ("HDF_VG_LONE"            fun nil                 (system) "Result = %s( FileHandle)" (("MAXSIZE")))
    ("HDF_VG_NUMBER"          fun nil                 (system) "Result = %s(VGroup)" nil)
    ("HILBERT"                fun nil                 (system) "Result = %s(X [, D])" nil)
    ("HIST_2D"                fun nil                 (system) "Result = %s( V1, V2)" (("BIN1") ("BIN2") ("MAX1") ("MAX2") ("MIN1") ("MIN2")))
    ("HIST_EQUAL"             fun nil                 (system) "Result = %s( A)" (("BINSIZE") ("HISTOGRAM_ONLY") ("MAXV") ("MINV") ("OMAX") ("OMIN") ("PERCENT") ("TOP")))
    ("HISTOGRAM"              fun nil                 (system) "Result = %s( Array)" (("BINSIZE") ("INPUT") ("L64") ("MAX") ("MIN") ("NAN") ("NBINS") ("OMAX") ("OMIN") ("REVERSE_INDICES")))
    ("HQR"                    fun nil                 (system) "Result = %s( A)" (("COLUMN") ("DOUBLE")))
    ("IBETA"                  fun nil                 (system) "Result = %s( A, B, X)" (("DOUBLE") ("EPS") ("ITER") ("ITMAX")))
    ("IDENTITY"               fun nil                 (system) "Result = %s( N)" (("DOUBLE")))
    ("IGAMMA"                 fun nil                 (system) "Result = %s( A, X)" (("DOUBLE") ("EPS") ("ITER") ("ITMAX") ("METHOD")))
    ("IMAGINARY"              fun nil                 (system) "Result = %s(Complex_Expression)" nil)
    ("INDGEN"                 fun nil                 (system) "Result = %s(D1, ..., D8)" (("BYTE") ("COMPLEX") ("DCOMPLEX") ("DOUBLE") ("FLOAT") ("L64") ("LONG") ("STRING") ("TYPE") ("UINT") ("UL64") ("ULONG")))
    ("INT_2D"                 fun nil                 (system) "Result = %s( Fxy, AB_Limits, PQ_Limits, Pts)" (("DOUBLE") ("ORDER")))
    ("INT_3D"                 fun nil                 (system) "Result = %s( Fxyz, AB_Limits, PQ_Limits, UV_Limits, Pts)" (("DOUBLE")))
    ("INT_TABULATED"          fun nil                 (system) "Result = %s( X, F)" (("DOUBLE") ("SORT")))
    ("INTARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("INTERPOL"               fun nil                 (system) "Result = %s( V, N) or Result = INTERPOL( V, X, U)" (("LSQUADRATIC") ("QUADRATIC") ("SPLINE")))
    ("INTERPOLATE"            fun nil                 (system) "Result = %s( P, X [, Y [, Z]])" (("CUBIC") ("GRID") ("MISSING")))
    ("INVERT"                 fun nil                 (system) "Result = %s( Array [, Status])" (("DOUBLE")))
    ("IOCTL"                  fun nil                 (system) "Result = %s( File_Unit [, Request, Arg])" (("BY_VALUE") ("MT_OFFLINE") ("MT_REWIND") ("MT_SKIP_FILE") ("MT_SKIP_RECORD") ("MT_WEOF") ("SUPRESS_ERROR")))
    ("ISHFT"                  fun nil                 (system) "Result = %s(P1, P2)" nil)
    ("JULDAY"                 fun nil                 (system) "Result = %s(Month, Day, Year, Hour, Minute, Second)" nil)
    ("KEYWORD_SET"            fun nil                 (system) "Result = %s(Expression)" nil)
    ("KRIG2D"                 fun nil                 (system) "Result = %s( Z [, X, Y])" (("BOUNDS") ("EXPONENTIAL") ("GS") ("NX") ("NY") ("REGULAR") ("SPHERICAL") ("XGRID") ("XVALUES") ("YGRID") ("YVALUES")))
    ("KURTOSIS"               fun nil                 (system) "Result = %s(X)" (("DOUBLE") ("NAN")))
    ("KW_TEST"                fun nil                 (system) "Result = %s( X)" (("DF") ("MISSING")))
    ("L64INDGEN"              fun nil                 (system) "Result = %s(D1, ..., D8)" nil)
    ("LABEL_DATE"             fun nil                 (system) "Result = %s()" (("AM_PM") ("DATE_FORMAT") ("DAYS_OF_WEEK") ("MONTHS") ("OFFSET") ("ROUND_UP") ("XTICKFORMAT")))
    ("LABEL_REGION"           fun nil                 (system) "Result = %s( Data)" (("ALL_NEIGHBORS") ("ULONG")))
    ("LADFIT"                 fun nil                 (system) "Result = %s( X, Y)" (("ABSDEV") ("DOUBLE")))
    ("LAGUERRE"               fun nil                 (system) "Result = %s( X, N [, K])" (("COEFFICIENTS") ("DOUBLE")))
    ("LEEFILT"                fun nil                 (system) "Result = %s( A [, N [, Sig]])" (("DOUBLE") ("EXACT")))
    ("LEGENDRE"               fun nil                 (system) "Result = %s( X, L [, M])" (("DOUBLE")))
    ("LINBCG"                 fun nil                 (system) "Result = %s( A, B, X)" (("DOUBLE") ("ITER") ("ITMAX") ("ITOL") ("TOL")))
    ("LINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil)
    ("LINFIT"                 fun nil                 (system) "Result = %s( X, Y)" (("CHISQ") ("COVAR") ("DOUBLE") ("MEASURE_ERRORS") ("PROB") ("SIGMA") ("YFIT")))
    ("LIVE_STYLE"             fun nil                 (system) "Style = %s ({ 'contour' | 'image' | 'plot' | 'surface'})" (("BASE_STYLE") ("COLORBAR_PROPERTIES") ("ERROR") ("GRAPHIC_PROPERTIES") ("GROUP") ("LEGEND_PROPERTIES") ("NAME") ("SAVE") ("TEMPLATE_FILE") ("VISUALIZATION_PROPERTIES") ("XAXIS_PROPERTIES") ("YAXIS_PROPERTIES") ("ZAXIS_PROPERTIES")))
    ("LL_ARC_DISTANCE"        fun nil                 (system) "Result = %s( Lon_lat0, Arc_Dist, Az)" (("DEGREES")))
    ("LMFIT"                  fun nil                 (system) "Result = %s( X, Y, A)" (("ALPHA") ("CHISQ") ("CONVERGENCE") ("COVAR") ("DOUBLE") ("FITA") ("FUNCTION_NAME") ("ITER") ("ITMAX") ("ITMIN") ("MEASURE_ERRORS") ("SIGMA") ("TOL")))
    ("LMGR"                   fun nil                 (system) "Result = %s()" (("CLIENTSERVER") ("DEMO") ("EMBEDDED") ("EXPIRE_DATE") ("FORCE_DEMO") ("INSTALL_NUM") ("LMHOSTID") ("RUNTIME") ("SITE_NOTICE") ("STUDENT") ("TRIAL")))
    ("LNGAMMA"                fun nil                 (system) "Result = %s(X)" nil)
    ("LNP_TEST"               fun nil                 (system) "Result = %s( X, Y)" (("DOUBLE") ("HIFAC") ("JMAX") ("OFAC") ("WK1") ("WK2")))
    ("LOCALE_GET"             fun nil                 (system) "Result = %s( )" nil)
    ("LON64ARR"               fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("LONARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("LONG"                   fun nil                 (system) "Result = %s( Expression[, Offset [, Dim1, ..., Dim8]] )" nil)
    ("LONG64"                 fun nil                 (system) "Result = %s( Expression[, Offset [, D1, ..., D8]] )" nil)
    ("LSODE"                  fun nil                 (system) "Result = %s( Y, X, H, Derivs[, Status])" (("ATOL") ("RTOL")))
    ("LU_COMPLEX"             fun nil                 (system) "Result = %s( A, B)" (("DOUBLE") ("INVERSE") ("SPARSE")))
    ("LUMPROVE"               fun nil                 (system) "Result = %s( A, Alud, Index, B, X)" (("COLUMN") ("DOUBLE")))
    ("LUSOL"                  fun nil                 (system) "Result = %s(A, Index, B)" (("COLUMN") ("DOUBLE")))
    ("M_CORRELATE"            fun nil                 (system) "Result = %s( X, Y)" (("DOUBLE")))
    ("MACHAR"                 fun nil                 (system) "Result = %s()" (("DOUBLE")))
    ("MAKE_ARRAY"             fun nil                 (system) "Result = %s ( [D1, ..., D8])" (("BYTE") ("COMPLEX") ("DCOMPLEX") ("DIMENSION") ("DOUBLE") ("FLOAT") ("INDEX") ("INT") ("L64") ("LONG") ("NOZERO") ("OBJ") ("PTR") ("SIZE") ("STRING") ("TYPE") ("UINT") ("UL64") ("ULONG") ("VALUE")))
    ("MAP_2POINTS"            fun nil                 (system) "Result = %s( lon0, lat0, lon1, lat1)" (("DPATH") ("METERS") ("MILES") ("NPATH") ("PARAMETERS") ("RADIANS") ("RADIUS") ("RHUMB")))
    ("MAP_IMAGE"              fun nil                 (system) "Result = %s( Image [, Startx, Starty [, Xsize, Ysize]])" (("BILINEAR") ("COMPRESS") ("LATMAX") ("LATMIN") ("LONMAX") ("LONMIN") ("MAX_VALUE") ("MIN_VALUE") ("MISSING") ("SCALE")))
    ("MAP_PATCH"              fun nil                 (system) "Result = %s( Image_Orig [, Lons, Lats])" (("LAT0") ("LAT1") ("LON0") ("LON1") ("MAX_VALUE") ("MISSING") ("TRIANGULATE") ("XSIZE") ("XSTART") ("YSIZE") ("YSTART")))
    ("MATRIX_MULTIPLY"        fun nil                 (system) "Result = %s( A, B)" (("ATRANSPOSE") ("BTRANSPOSE")))
    ("MAX"                    fun nil                 (system) "Result = %s( Array [, Max_Subscript])" (("MIN") ("NAN")))
    ("MD_TEST"                fun nil                 (system) "Result = %s( X)" (("ABOVE") ("BELOW") ("MDC")))
    ("MEAN"                   fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("NAN")))
    ("MEANABSDEV"             fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("MEDIAN") ("NAN")))
    ("MEDIAN"                 fun nil                 (system) "Result = %s( Array [, Width])" (("EVEN")))
    ("MEMORY"                 fun nil                 (system) "Result = %s()" (("CURRENT") ("HIGHWATER") ("L64") ("NUM_ALLOC") ("NUM_FREE") ("STRUCTURE")))
    ("MESH_CLIP"              fun nil                 (system) "Result = %s (Plane, Vertsin, Connin, Vertsout, Connout)" (("AUXDATA_IN") ("AUXDATA_OUT") ("CUT_VERTS")))
    ("MESH_DECIMATE"          fun nil                 (system) "Result = %s (Verts, Conn, Connout)" (("PERCENT_POLYGONS") ("PERCENT_VERTICES") ("VERTICES")))
    ("MESH_ISSOLID"           fun nil                 (system) "Result = %s (Conn)" nil)
    ("MESH_MERGE"             fun nil                 (system) "Result = %s (Verts, Conn, Verts1, Conn1)" (("COMBINE_VERTICES") ("TOLERANCE")))
    ("MESH_NUMTRIANGLES"      fun nil                 (system) "Result = %s (Conn)" nil)
    ("MESH_SMOOTH"            fun nil                 (system) "Result = %s (Verts, Conn)" (("FIXED_EDGE_VERTICES") ("FIXED_VERTICES") ("ITERATIONS") ("LAMBDA")))
    ("MESH_SURFACEAREA"       fun nil                 (system) "Result = %s ( Verts, Conn)" (("AUXDATA") ("MOMENT")))
    ("MESH_VALIDATE"          fun nil                 (system) "Result = %s ( Verts, Conn)" (("COMBINE_VERTICES") ("PACK_VERTICES") ("REMOVE_NAN") ("TOLERANCE")))
    ("MESH_VOLUME"            fun nil                 (system) "Result = %s ( Verts, Conn)" (("SIGNED")))
    ("MIN"                    fun nil                 (system) "Result = %s( Array [, Min_Subscript])" (("MAX") ("NAN")))
    ("MIN_CURVE_SURF"         fun nil                 (system) "Result = %s(Z [, X, Y])" (("BOUNDS") ("CONST") ("DOUBLE") ("GS") ("NX") ("NY") ("REGULAR") ("SPHERE") ("TPS") ("XGRID") ("XOUT") ("XPOUT") ("XVALUES") ("YGRID") ("YOUT") ("YPOUT") ("YVALUES")))
    ("MOMENT"                 fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("MDEV") ("NAN") ("SDEV")))
    ("MORPH_CLOSE"            fun nil                 (system) "Result = %s (Image, Structure)" (("GRAY") ("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")))
    ("MORPH_DISTANCE"         fun nil                 (system) "Result = %s (Data)" (("BACKGROUND") ("NEIGHBOR_SAMPLING") ("NO_COPY")))
    ("MORPH_GRADIENT"         fun nil                 (system) "Result = %s (Image, Structure)" (("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")))
    ("MORPH_HITORMISS"        fun nil                 (system) "Result = %s (Image, HitStructure, MissStructure)" nil)
    ("MORPH_OPEN"             fun nil                 (system) "Result = %s (Image, Structure)" (("GRAY") ("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")))
    ("MORPH_THIN"             fun nil                 (system) "Result = %s ( Image, HitStructure, MissStructure )" nil)
    ("MORPH_TOPHAT"           fun nil                 (system) "Result = %s ( Image, Structure)" (("PRESERVE_TYPE") ("UINT") ("ULONG") ("VALUES")))
    ("MPEG_OPEN"              fun nil                 (system) "mpegID = %s( Dimensions)" (("BITRATE") ("FILENAME") ("IFRAME_GAP") ("MOTION_VEC_LENGTH") ("QUALITY")))
    ("MSG_CAT_OPEN"           fun nil                 (system) "Result = %s( application)" (("DEFAULT_FILENAME") ("FILENAME") ("FOUND") ("LOCALE") ("PATH") ("SUB_QUERY")))
    ("N_ELEMENTS"             fun nil                 (system) "Result = %s(Expression)" nil)
    ("N_PARAMS"               fun nil                 (system) "Result = %s()" nil)
    ("N_TAGS"                 fun nil                 (system) "Result = %s( Expression)" (("LENGTH")))
    ("NCDF_ATTCOPY"           fun nil                 (system) "Result = %s( Incdf [, Invar])" (("IN_GLOBAL") ("OUT_GLOBAL")))
    ("NCDF_ATTINQ"            fun nil                 (system) "Result = %s( Cdfid [, Varid])" (("GLOBAL")))
    ("NCDF_ATTNAME"           fun nil                 (system) "Result = %s( Cdfid [, Varid])" (("GLOBAL")))
    ("NCDF_CREATE"            fun nil                 (system) "Result = %s( Filename)" (("CLOBBER") ("NOCLOBBER")))
    ("NCDF_DIMDEF"            fun nil                 (system) "Result = %s( Cdfid, DimName, Size)" (("UNLIMITED")))
    ("NCDF_DIMID"             fun nil                 (system) "Result = %s( Cdfid, DimName )" nil)
    ("NCDF_EXISTS"            fun nil                 (system) "Result = %s( )" nil)
    ("NCDF_INQUIRE"           fun nil                 (system) "Result = %s(Cdfid)" nil)
    ("NCDF_OPEN"              fun nil                 (system) "Result = %s( Filename)" (("NOWRITE") ("WRITE")))
    ("NCDF_VARDEF"            fun nil                 (system) "Result = %s( Cdfid, Name [, Dim])" (("BYTE") ("CHAR") ("DOUBLE") ("FLOAT") ("LONG") ("SHORT")))
    ("NCDF_VARID"             fun nil                 (system) "Result = %s(Cdfid, Name)" nil)
    ("NCDF_VARINQ"            fun nil                 (system) "Result = %s(Cdfid, Varid)" nil)
    ("NEWTON"                 fun nil                 (system) "Result = %s( X, Vecfunc)" (("CHECK") ("DOUBLE") ("ITMAX") ("STEPMAX") ("TOLF") ("TOLMIN") ("TOLX")))
    ("NORM"                   fun nil                 (system) "Result = %s( A)" (("DOUBLE")))
    ("OBJ_CLASS"              fun nil                 (system) "Result = %s( [Arg])" (("COUNT") ("SUPERCLASS")))
    ("OBJ_ISA"                fun nil                 (system) "Result = %s(ObjectInstance, ClassName)" nil)
    ("OBJ_NEW"                fun nil                 (system) "Result = %s( [ObjectClassName [, Arg1......Argn]] )" nil)
    ("OBJ_VALID"              fun nil                 (system) "Result = %s( [Arg])" (("CAST") ("COUNT")))
    ("OBJARR"                 fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("P_CORRELATE"            fun nil                 (system) "Result = %s( X, Y, C)" (("DOUBLE")))
    ("PCOMP"                  fun nil                 (system) "Result = %s( A)" (("COEFFICIENTS") ("COVARIANCE") ("DOUBLE") ("EIGENVALUES") ("NVARIABLES") ("STANDARDIZE") ("VARIANCES")))
    ("PNT_LINE"               fun nil                 (system) "Result = %s( P0, L0, L1 [, Pl])" (("INTERVAL")))
    ("POLAR_SURFACE"          fun nil                 (system) "Result = %s( Z, R, Theta)" (("BOUNDS") ("GRID") ("MISSING") ("QUINTIC") ("SPACING")))
    ("POLY"                   fun nil                 (system) "Result = %s(X, C)" nil)
    ("POLY_2D"                fun nil                 (system) "Result = %s( Array, P, Q [, Interp [, Dimx, Dimy]])" (("CUBIC") ("MISSING")))
    ("POLY_AREA"              fun nil                 (system) "Result = %s( X, Y)" (("SIGNED")))
    ("POLY_FIT"               fun nil                 (system) "Result = %s( X, Y, Degree)" (("CHISQ") ("COVAR") ("DOUBLE") ("MEASURE_ERRORS") ("SIGMA") ("STATUS") ("YBAND") ("YERROR") ("YFIT")))
    ("POLYFILLV"              fun nil                 (system) "Result = %s( X, Y, Sx, Sy [, Run_Length] )" nil)
    ("POLYFITW"               fun nil                 (system) "Result = %s(X, Y, Weights, NDegree [, Yfit, Yband, Sigma, Corrm])" (("DOUBLE") ("STATUS")))
    ("POLYSHADE"              fun nil                 (system) "Result = %s( Vertices, Polygons) or Result = POLYSHADE(X, Y, Z, Polygons)" (("DATA") ("NORMAL") ("POLY_SHADES") ("SHADES") ("T3D") ("TOP") ("XSIZE") ("YSIZE")))
    ("PRIMES"                 fun nil                 (system) "Result = %s(K)" nil)
    ("PROFILE"                fun nil                 (system) "Result = %s( Image [, XX, YY])" (("NOMARK") ("XSTART") ("YSTART")))
    ("PROJECT_VOL"            fun nil                 (system) "Return = %s( Vol, X_Sample, Y_Sample, Z_Sample)" (("DEPTH_Q") ("OPAQUE") ("TRANS")))
    ("PTR_NEW"                fun nil                 (system) "Result = %s( [InitExpr])" (("ALLOCATE_HEAP") ("NO_COPY")))
    ("PTR_VALID"              fun nil                 (system) "Result = %s( [Arg])" (("CAST") ("COUNT")))
    ("PTRARR"                 fun nil                 (system) "Result = %s( D1, ... ..., D8)" (("ALLOCATE_HEAP") ("NOZERO")))
    ("QROMB"                  fun nil                 (system) "Result = %s( Func, A, B)" (("DOUBLE") ("EPS") ("JMAX") ("K")))
    ("QROMO"                  fun nil                 (system) "Result = %s(Func, A [, B])" (("DOUBLE") ("EPS") ("JMAX") ("K") ("MIDEXP") ("MIDINF") ("MIDPNT") ("MIDSQL") ("MIDSQU")))
    ("QSIMP"                  fun nil                 (system) "Result = %s( Func, A, B)" (("DOUBLE") ("EPS") ("JMAX")))
    ("QUERY_BMP"              fun nil                 (system) "Result = %s ( Filename [, Info] )" nil)
    ("QUERY_DICOM"            fun nil                 (system) "Result = %s( Filename [, Info])" (("IMAGE_INDEX")))
    ("QUERY_IMAGE"            fun nil                 (system) "Result = %s ( Filename[, Info])" (("CHANNELS") ("DIMENSIONS") ("HAS_PALETTE") ("IMAGE_INDEX") ("NUM_IMAGES") ("PIXEL_TYPE") ("SUPPORTED_READ") ("SUPPORTED_WRITE") ("TYPE")))
    ("QUERY_JPEG"             fun nil                 (system) "Result = %s ( Filename [, Info] )" nil)
    ("QUERY_PICT"             fun nil                 (system) "Result = %s ( Filename [, Info] )" nil)
    ("QUERY_PNG"              fun nil                 (system) "Result = %s ( Filename [, Info] )" nil)
    ("QUERY_PPM"              fun nil                 (system) "Result = %s ( Filename [, Info])" (("MAXVAL")))
    ("QUERY_SRF"              fun nil                 (system) "Result = %s (Filename [, Info] )" nil)
    ("QUERY_TIFF"             fun nil                 (system) "Result = %s ( Filename [, Info])" (("IMAGE_INDEX")))
    ("QUERY_WAV"              fun nil                 (system) "Result = %s ( Filename[, Info] )" nil)
    ("R_CORRELATE"            fun nil                 (system) "Result = %s( X, Y)" (("D") ("KENDALL") ("PROBD") ("ZD")))
    ("R_TEST"                 fun nil                 (system) "Result = %s( X)" (("N0") ("N1") ("R")))
    ("RANDOMN"                fun nil                 (system) "Result = %s( Seed [, D1, ..., D8])" (("BINOMIAL") ("DOUBLE") ("GAMMA") ("LONG") ("NORMAL") ("POISSON") ("UNIFORM")))
    ("RANDOMU"                fun nil                 (system) "Result = %s( Seed [, D1, ..., D8])" (("BINOMIAL") ("DOUBLE") ("GAMMA") ("LONG") ("NORMAL") ("POISSON") ("UNIFORM")))
    ("RANKS"                  fun nil                 (system) "Result = %s(X)" nil)
    ("READ_ASCII"             fun nil                 (system) "Result = %s( [Filename])" (("COMMENT_SYMBOL") ("COUNT") ("DATA_START") ("DELIMITER") ("HEADER") ("MISSING_VALUE") ("NUM_RECORDS") ("RECORD_START") ("TEMPLATE") ("VERBOSE")))
    ("READ_BINARY"            fun nil                 (system) "Result = %s ([Filename] | FileUnit)" (("DATA_DIMS") ("DATA_START") ("DATA_TYPE") ("ENDIAN") ("TEMPLATE")))
    ("READ_BMP"               fun nil                 (system) "Result = %s( Filename, [, R, G, B] [, Ihdr])" (("RGB")))
    ("READ_DICOM"             fun nil                 (system) "Result = %s (Filename [, Red, Green, Blue])" (("IMAGE_INDEX")))
    ("READ_IMAGE"             fun nil                 (system) "Result = %s (Filename [, Red, Green, Blue])" (("IMAGE_INDEX")))
    ("READ_PNG"               fun nil                 (system) "Result = %s ( Filename [, R, G, B])" (("ORDER") ("TRANSPARENT") ("VERBOSE")))
    ("READ_SPR"               fun nil                 (system) "Result = %s(Filename)" nil)
    ("READ_SYLK"              fun nil                 (system) "Result = %s( File)" (("ARRAY") ("COLMAJOR") ("NCOLS") ("NROWS") ("STARTCOL") ("STARTROW") ("USEDOUBLES") ("USELONGS")))
    ("READ_TIFF"              fun nil                 (system) "Result = %s( Filename [, R, G, B])" (("CHANNELS") ("GEOTIFF") ("IMAGE_INDEX") ("INTERLEAVE") ("ORDER") ("PLANARCONFIG") ("SUB_RECT") ("UNSIGNED") ("VERBOSE")))
    ("READ_WAV"               fun nil                 (system) "Result = %s ( Filename [, Rate] )" nil)
    ("READ_XWD"               fun nil                 (system) "Result = %s( Filename[, R, G, B] )" nil)
    ("REBIN"                  fun nil                 (system) "Result = %s( Array, D1 [, ..., D8])" (("SAMPLE")))
    ("RECALL_COMMANDS"        fun nil                 (system) "Result = %s()" nil)
    ("RECON3"                 fun nil                 (system) "Result = %s( Images, Obj_Rot, Obj_Pos, Focal, Dist,Vol_Pos, Img_Ref, Img_Mag, Vol_Size)" (("CUBIC") ("MISSING") ("MODE")))
    ("REFORM"                 fun nil                 (system) "Result = %s( Array, D1, ..., D8)" (("OVERWRITE")))
    ("REGRESS"                fun nil                 (system) "Result = %s( X, Y)" (("CHISQ") ("CONST") ("CORRELATION") ("DOUBLE") ("FTEST") ("MCORRELATION") ("MEASURE_ERRORS") ("SIGMA") ("STATUS") ("YFIT")))
    ("REPLICATE"              fun nil                 (system) "Result = %s( Value, D1 [, ..., D8] )" nil)
    ("REVERSE"                fun nil                 (system) "Result = %s( Array [, Subscript_Index])" (("OVERWRITE")))
    ("RK4"                    fun nil                 (system) "Result = %s( Y, Dydx, X, H, Derivs)" (("DOUBLE")))
    ("ROBERTS"                fun nil                 (system) "Result = %s(Image)" nil)
    ("ROT"                    fun nil                 (system) "Result = %s( A, Angle, [Mag, X0, Y0])" (("CUBIC") ("INTERP") ("MISSING") ("PIVOT")))
    ("ROTATE"                 fun nil                 (system) "Result = %s(Array, Direction)" nil)
    ("ROUND"                  fun nil                 (system) "Result = %s(X)" (("L64")))
    ("ROUTINE_INFO"           fun nil                 (system) "Result = %s( [Routine])" (("DISABLED") ("ENABLED") ("FUNCTIONS") ("PARAMETERS") ("SOURCE") ("SYSTEM") ("UNRESOLVED") ("VARIABLES")))
    ("RS_TEST"                fun nil                 (system) "Result = %s( X, Y)" (("UX") ("UY")))
    ("RSTRPOS"                fun nil                 (system) "Result = %s( Expression, Search_String [, Pos] )" nil)
    ("S_TEST"                 fun nil                 (system) "Result = %s( X, Y)" (("ZDIFF")))
    ("SAVGOL"                 fun nil                 (system) "Result = %s( Nleft, Nright, Order, Degree)" (("DOUBLE")))
    ("SEARCH2D"               fun nil                 (system) "Result = %s( Array, Xpos, Ypos, Min_Val, Max_Val)" (("DECREASE") ("DIAGONAL") ("INCREASE") ("LPF_BAND")))
    ("SEARCH3D"               fun nil                 (system) "Result = %s( Array, Xpos, Ypos, Zpos, Min_Val, Max_Val)" (("DECREASE") ("DIAGONAL") ("INCREASE") ("LPF_BAND")))
    ("SFIT"                   fun nil                 (system) "Result = %s( Data, Degree)" (("KX")))
    ("SHIFT"                  fun nil                 (system) "Result = %s(Array, S1, ..., Sn)" nil)
    ("SIN"                    fun nil                 (system) "Result = %s(X)" nil)
    ("SINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil)
    ("SINH"                   fun nil                 (system) "Result = %s(X)" nil)
    ("SIZE"                   fun nil                 (system) "Result = %s( Expression)" (("DIMENSIONS") ("FILE_LUN") ("L64") ("N_DIMENSIONS") ("N_ELEMENTS") ("STRUCTURE") ("TNAME") ("TYPE")))
    ("SKEWNESS"               fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("NAN")))
    ("SMOOTH"                 fun nil                 (system) "Result = %s( Array, Width)" (("EDGE_TRUNCATE") ("NAN")))
    ("SOBEL"                  fun nil                 (system) "Result = %s(Image)" nil)
    ("SORT"                   fun nil                 (system) "Result = %s(Array)" (("L64")))
    ("SPH_SCAT"               fun nil                 (system) "Result = %s( Lon, Lat, F)" (("BOUNDS") ("BOUT") ("GOUT") ("GS") ("NLAT") ("NLON")))
    ("SPHER_HARM"             fun nil                 (system) "Result = %s( Theta, Phi, L, M)" (("DOUBLE")))
    ("SPL_INIT"               fun nil                 (system) "Result = %s( X, Y)" (("DOUBLE") ("YP0") ("YPN_1")))
    ("SPL_INTERP"             fun nil                 (system) "Result = %s( X, Y, Y2, X2)" (("DOUBLE")))
    ("SPLINE"                 fun nil                 (system) "Result = %s( X, Y, T [, Sigma] )" nil)
    ("SPRSAB"                 fun nil                 (system) "Result = %s( A, B)" (("DOUBLE") ("THRESHOLD")))
    ("SPRSAX"                 fun nil                 (system) "Result = %s( A, X)" (("DOUBLE")))
    ("SPRSIN"                 fun nil                 (system) "Result = %s( A)" (("COLUMN") ("DOUBLE") ("THRESHOLD")))
    ("SPRSTP"                 fun nil                 (system) "Result = %s(A)" nil)
    ("SQRT"                   fun nil                 (system) "Result = %s(X)" nil)
    ("STANDARDIZE"            fun nil                 (system) "Result = %s( A)" (("DOUBLE")))
    ("STDDEV"                 fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("NAN")))
    ("STR_SEP"                fun nil                 (system) "Result = %s( Str, Separator)" (("ESC") ("REMOVE_ALL") ("TRIM")))
    ("STRARR"                 fun nil                 (system) "Result = %s(D1, ..., D8)" nil)
    ("STRCMP"                 fun nil                 (system) "Result = %s( String1, String2 [, N])" (("FOLD_CASE")))
    ("STRCOMPRESS"            fun nil                 (system) "Result = %s( String)" (("REMOVE_ALL")))
    ("STREGEX"                fun nil                 (system) "Result = %s( StringExpression, RegularExpression)" (("BOOLEAN") ("EXTRACT") ("FOLD_CASE") ("LENGTH") ("SUBEXPR")))
    ("STRING"                 fun nil                 (system) "Result = %s( Expression1, ..., Expressionn)" (("AM_PM") ("DAYS_OF_WEEK") ("FORMAT") ("MONTHS") ("PRINT")))
    ("STRJOIN"                fun nil                 (system) "Result = %s( String [, Delimiter])" (("SINGLE")))
    ("STRLEN"                 fun nil                 (system) "Result = %s(Expression)" nil)
    ("STRLOWCASE"             fun nil                 (system) "Result = %s(String)" nil)
    ("STRMATCH"               fun nil                 (system) "Result = %s( String, SearchString)" (("FOLD_CASE")))
    ("STRMESSAGE"             fun nil                 (system) "Result = %s( Err)" (("BLOCK") ("CODE") ("NAME")))
    ("STRMID"                 fun nil                 (system) "Result = %s(Expression, First_Character [, Length])" (("REVERSE_OFFSET")))
    ("STRPOS"                 fun nil                 (system) "Result = %s( Expression, Search String [, Pos])" (("REVERSE_OFFSET") ("REVERSE_SEARCH")))
    ("STRSPLIT"               fun nil                 (system) "Result = %s( String [, Pattern])" (("ESCAPE") ("EXTRACT") ("FOLD_CASE") ("LENGTH") ("PRESERVE_NULL") ("REGEX")))
    ("STRTRIM"                fun nil                 (system) "Result = %s( String [, Flag] )" nil)
    ("STRUPCASE"              fun nil                 (system) "Result = %s(String)" nil)
    ("SVDFIT"                 fun nil                 (system) "Result = %s( X, Y [, M])" (("A") ("CHISQ") ("COVAR") ("DOUBLE") ("FUNCTION_NAME") ("LEGENDRE") ("MEASURE_ERRORS") ("SIGMA") ("SINGULAR") ("VARIANCE") ("YFIT")))
    ("SVSOL"                  fun nil                 (system) "Result = %s( U, W, V, B)" (("COLUMN") ("DOUBLE")))
    ("SWAP_ENDIAN"            fun nil                 (system) "Result = %s(Variable)" nil)
    ("SYSTIME"                fun nil                 (system) "String = %s( [0 [, ElaspedSeconds]])" (("JULIAN") ("SECONDS") ("UTC")))
    ("T_CVF"                  fun nil                 (system) "Result = %s(P, Df)" nil)
    ("T_PDF"                  fun nil                 (system) "Result = %s(V, Df)" nil)
    ("TAG_NAMES"              fun nil                 (system) "Result = %s( Expression)" (("STRUCTURE_NAME")))
    ("TAN"                    fun nil                 (system) "Result = %s(X)" nil)
    ("TANH"                   fun nil                 (system) "Result = %s(X)" nil)
    ("TEMPORARY"              fun nil                 (system) "Result = %s(Variable)" nil)
    ("TETRA_CLIP"             fun nil                 (system) "Result = %s ( Plane, Vertsin, Connin, Vertsout, Connout)" (("AUXDATA_IN") ("AUXDATA_OUT") ("CUT_VERTS")))
    ("TETRA_SURFACE"          fun nil                 (system) "Result = %s (Verts, Connin)" nil)
    ("TETRA_VOLUME"           fun nil                 (system) "Result = %s ( Verts, Conn)" (("AUXDATA") ("MOMENT")))
    ("THIN"                   fun nil                 (system) "Result = %s( Image)" (("NEIGHBOR_COUNT") ("PRUNE")))
    ("TIFF_READ"              fun nil                 (system) "Result = %s(File [, R, G, B])" nil)
    ("TIMEGEN"                fun nil                 (system) "Result = %s( [D1,...,D8])" (("DAYS") ("FINAL") ("HOURS") ("MINUTES") ("MONTHS") ("SECONDS") ("START") ("STEP_SIZE") ("UNITS") ("YEAR")))
    ("TM_TEST"                fun nil                 (system) "Result = %s( X, Y)" (("PAIRED") ("UNEQUAL")))
    ("TOTAL"                  fun nil                 (system) "Result = %s( Array [, Dimension])" (("CUMULATIVE") ("DOUBLE") ("NAN")))
    ("TRACE"                  fun nil                 (system) "Result = %s( A)" (("DOUBLE")))
    ("TRANSPOSE"              fun nil                 (system) "Result = %s( Array [, P] )" nil)
    ("TRI_SURF"               fun nil                 (system) "Result = %s( Z [, X, Y])" (("BOUNDS") ("EXTRAPOLATE") ("GS") ("MISSING") ("NX") ("NY") ("REGULAR") ("XGRID") ("XVALUES") ("YGRID") ("YVALUES")))
    ("TRIGRID"                fun nil                 (system) "Result = %s( X, Y, Z, Triangles [, GS, Limits] ) For spherical gridding: Result = TRIGRID( F , GS, Limits)" (("DEGREES") ("EXTRAPOLATE") ("INPUT") ("MAX_VALUE") ("MIN_VALUE") ("MISSING") ("NX") ("NY") ("QUINTIC") ("SPHERE") ("XGRID") ("XOUT") ("YGRID") ("YOUT")))
    ("TRISOL"                 fun nil                 (system) "Result = %s( A, B, C, R)" (("DOUBLE")))
    ("TRNLOG"                 fun nil                 (system) "Result = %s( Lognam, Value)" (("ACMODE") ("FULL_TRANSLATION") ("ISSUE_ERROR") ("RESULT_ACMODE") ("RESULT_TABLE") ("TABLE")))
    ("TS_COEF"                fun nil                 (system) "Result = %s( X, P)" (("DOUBLE") ("MSE")))
    ("TS_DIFF"                fun nil                 (system) "Result = %s( X, K)" (("DOUBLE")))
    ("TS_FCAST"               fun nil                 (system) "Result = %s( X, P, Nvalues)" (("BACKCAST") ("DOUBLE")))
    ("TS_SMOOTH"              fun nil                 (system) "Result = %s( X, Nvalues)" (("BACKWARD") ("DOUBLE") ("FORWARD") ("ORDER")))
    ("TVRD"                   fun nil                 (system) "Result = %s( [X0 [, Y0 [, Nx [, Ny [, Channel]]]]])" (("CHANNEL") ("ORDER") ("TRUE") ("WORDS")))
    ("UINDGEN"                fun nil                 (system) "Result = %s(D1, ..., D8)" nil)
    ("UINT"                   fun nil                 (system) "Result = %s( Expression[, Offset [, Dim1, ..., Dim8]] )" nil)
    ("UINTARR"                fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("UL64INDGEN"             fun nil                 (system) "Result = %s(D1, ..., D8)" nil)
    ("ULINDGEN"               fun nil                 (system) "Result = %s(D1, ..., D8)" nil)
    ("ULON64ARR"              fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("ULONARR"                fun nil                 (system) "Result = %s( D1, ..., D8)" (("NOZERO")))
    ("ULONG"                  fun nil                 (system) "Result = %s( Expression[, Offset [, Dim1, ..., Dim8]] )" nil)
    ("ULONG64"                fun nil                 (system) "Result = %s( Expression[, Offset [, Dim1, ..., Dim8]] )" nil)
    ("UNIQ"                   fun nil                 (system) "Result = %s( Array [, Index] )" nil)
    ("VALUE_LOCATE"           fun nil                 (system) "Result = %s ( Vector, Value)" (("L64")))
    ("VARIANCE"               fun nil                 (system) "Result = %s( X)" (("DOUBLE") ("NAN")))
    ("VAX_FLOAT"              fun nil                 (system) "Result = %s( [Default])" (("FILE_UNIT")))
    ("VERT_T3D"               fun nil                 (system) "Result = %s( Vertex_List)" (("MATRIX") ("NO_COPY") ("NO_DIVIDE") ("SAVE_DIVIDE")))
    ("VOIGT"                  fun nil                 (system) "Result = %s(A, U)" nil)
    ("VOXEL_PROJ"             fun nil                 (system) "Result = %s( V [, RGBO])" (("BACKGROUND") ("CUTTING_PLANE") ("INTERPOLATE") ("MAXIMUM_INTENSITY") ("STEP") ("XSIZE") ("YSIZE") ("ZBUFFER") ("ZPIXELS")))
    ("WARP_TRI"               fun nil                 (system) "Result = %s( Xo, Yo, Xi, Yi, Image)" (("EXTRAPOLATE") ("OUTPUT_SIZE") ("QUINTIC")))
    ("WATERSHED"              fun nil                 (system) "Result = %s ( Image)" (("CONNECTIVITY")))
    ("WHERE"                  fun nil                 (system) "Result = %s( Array_Expression [, Count])" (("COMPLEMENT") ("L64") ("NCOMPLEMENT")))
    ("WIDGET_BASE"            fun nil                 (system) "Result = %s( [Parent])" (("ALIGN_BOTTOM") ("ALIGN_CENTER") ("ALIGN_LEFT") ("ALIGN_RIGHT") ("ALIGN_TOP") ("APP_MBAR") ("BASE_ALIGN_BOTTOM") ("BASE_ALIGN_CENTER") ("BASE_ALIGN_LEFT") ("BASE_ALIGN_RIGHT") ("BASE_ALIGN_TOP") ("COLUMN") ("DISPLAY_NAME") ("EVENT_FUNC") ("EVENT_PRO") ("EXCLUSIVE") ("FLOATING") ("FRAME") ("FUNC_GET_VALUE") ("GRID_LAYOUT") ("GROUP_LEADER") ("KBRD_FOCUS_EVENTS") ("KILL_NOTIFY") ("MAP") ("MBAR") ("MODAL") ("NO_COPY") ("NONEXCLUSIVE") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("RNAME_MBAR") ("ROW") ("SCR_XSIZE") ("SCR_YSIZE") ("SCROLL") ("SENSITIVE") ("SPACE") ("TITLE") ("TLB_FRAME_ATTR") ("TLB_KILL_REQUEST_EVENTS") ("TLB_SIZE_EVENTS") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("X_SCROLL_SIZE") ("XOFFSET") ("XPAD") ("XSIZE") ("Y_SCROLL_SIZE") ("YOFFSET") ("YPAD") ("YSIZE")))
    ("WIDGET_BUTTON"          fun nil                 (system) "Result = %s( Parent)" (("ALIGN_CENTER") ("ALIGN_LEFT") ("ALIGN_RIGHT") ("BITMAP") ("DYNAMIC_RESIZE") ("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("HELP") ("KILL_NOTIFY") ("MENU") ("NO_COPY") ("NO_RELEASE") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SENSITIVE") ("SEPARATOR") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("X_BITMAP_EXTRA") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")))
    ("WIDGET_DRAW"            fun nil                 (system) "Result = %s(Parent)" (("APP_SCROLL") ("BUTTON_EVENTS") ("COLOR_MODEL") ("COLORS") ("EVENT_FUNC") ("EVENT_PRO") ("EXPOSE_EVENTS") ("FRAME") ("FUNC_GET_VALUE") ("GRAPHICS_LEVEL") ("GROUP_LEADER") ("KILL_NOTIFY") ("MOTION_EVENTS") ("NO_COPY") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RENDERER") ("RESOURCE_NAME") ("RETAIN") ("SCR_XSIZE") ("SCR_YSIZE") ("SCROLL") ("SENSITIVE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("VIEWPORT_EVENTS") ("X_SCROLL_SIZE") ("XOFFSET") ("XSIZE") ("Y_SCROLL_SIZE") ("YOFFSET") ("YSIZE")))
    ("WIDGET_DROPLIST"        fun nil                 (system) "Result = %s( Parent)" (("DYNAMIC_RESIZE") ("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KILL_NOTIFY") ("NO_COPY") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SENSITIVE") ("TITLE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")))
    ("WIDGET_EVENT"           fun nil                 (system) "Result = %s([Widget_ID])" (("BAD_ID") ("NOWAIT") ("SAVE_HOURGLASS") ("YIELD_TO_TTY")))
    ("WIDGET_INFO"            fun nil                 (system) "Result = %s( [Widget_ID] )" (("ACTIVE") ("CHILD") ("COLUMN_WIDTHS") ("DRAW_BUTTON_EVENTS") ("DRAW_EXPOSE_EVENTS") ("DRAW_MOTION_EVENTS") ("DRAW_VIEWPORT_EVENTS") ("DROPLIST_NUMBER") ("DROPLIST_SELECT") ("DYNAMIC_RESIZE") ("EVENT_FUNC") ("EVENT_PRO") ("FIND_BY_UNAME") ("GEOMETRY") ("KBRD_FOCUS_EVENTS") ("LIST_MULTIPLE") ("LIST_NUM_VISIBLE") ("LIST_NUMBER") ("LIST_SELECT") ("LIST_TOP") ("MANAGED") ("MODAL") ("NAME") ("PARENT") ("REALIZED") ("ROW_HEIGHTS") ("SIBLING") ("SLIDER_MIN_MAX") ("TABLE_ALL_EVENTS") ("TABLE_EDIT_CELL") ("TABLE_EDITABLE") ("TABLE_SELECT") ("TABLE_VIEW") ("TEXT_ALL_EVENTS") ("TEXT_EDITABLE") ("TEXT_NUMBER") ("TEXT_OFFSET_TO_XY") ("TEXT_SELECT") ("TEXT_TOP_LINE") ("TEXT_XY_TO_OFFSET") ("TLB_KILL_REQUEST_EVENTS") ("TRACKING_EVENTS") ("TYPE") ("UNAME") ("UNITS") ("UPDATE") ("USE_TABLE_SELECT") ("VALID_ID") ("VERSION")))
    ("WIDGET_LABEL"           fun nil                 (system) "Result = %s( Parent)" (("ALIGN_CENTER") ("ALIGN_LEFT") ("ALIGN_RIGHT") ("DYNAMIC_RESIZE") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KILL_NOTIFY") ("NO_COPY") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SENSITIVE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")))
    ("WIDGET_LIST"            fun nil                 (system) "Result = %s( Parent)" (("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KILL_NOTIFY") ("MULTIPLE") ("NO_COPY") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SENSITIVE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")))
    ("WIDGET_SLIDER"          fun nil                 (system) "Result = %s( Parent)" (("DRAG") ("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KILL_NOTIFY") ("MAXIMUM") ("MINIMUM") ("NO_COPY") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SCROLL") ("SENSITIVE") ("SUPPRESS_VALUE") ("TITLE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("VERTICAL") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")))
    ("WIDGET_TABLE"           fun nil                 (system) "Result = %s( Parent)" (("ALIGNMENT") ("ALL_EVENTS") ("AM_PM") ("COLUMN_LABELS") ("COLUMN_MAJOR") ("COLUMN_WIDTHS") ("DAYS_OF_WEEK") ("EDITABLE") ("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FORMAT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KBRD_FOCUS_EVENTS") ("KILL_NOTIFY") ("MONTHS") ("NO_COPY") ("NO_HEADERS") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESIZEABLE_COLUMNS") ("RESIZEABLE_ROWS") ("RESOURCE_NAME") ("ROW_HEIGHTS") ("ROW_LABELS") ("ROW_MAJOR") ("SCR_XSIZE") ("SCR_YSIZE") ("SCROLL") ("SENSITIVE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("X_SCROLL_SIZE") ("XOFFSET") ("XSIZE") ("Y_SCROLL_SIZE") ("YOFFSET") ("YSIZE")))
    ("WIDGET_TEXT"            fun nil                 (system) "Result = %s( Parent)" (("ALL_EVENTS") ("EDITABLE") ("EVENT_FUNC") ("EVENT_PRO") ("FONT") ("FRAME") ("FUNC_GET_VALUE") ("GROUP_LEADER") ("KBRD_FOCUS_EVENTS") ("KILL_NOTIFY") ("NO_COPY") ("NO_NEWLINE") ("NOTIFY_REALIZE") ("PRO_SET_VALUE") ("RESOURCE_NAME") ("SCR_XSIZE") ("SCR_YSIZE") ("SCROLL") ("SENSITIVE") ("TRACKING_EVENTS") ("UNAME") ("UNITS") ("UVALUE") ("VALUE") ("WRAP") ("XOFFSET") ("XSIZE") ("YOFFSET") ("YSIZE")))
    ("WRITE_SYLK"             fun nil                 (system) "Result = %s( File, Data)" (("STARTCOL") ("STARTROW")))
    ("WTN"                    fun nil                 (system) "Result = %s( A, Coef)" (("COLUMN") ("DOUBLE") ("INVERSE") ("OVERWRITE")))
    ("XFONT"                  fun nil                 (system) "Result = %s()" (("GROUP") ("PRESERVE_FONT_INFO")))
    ("XREGISTERED"            fun nil                 (system) "Result = %s(Name)" (("NO_SHOW")))
    ("XSQ_TEST"               fun nil                 (system) "Result = %s( Obfreq, Exfreq)" (("EXCELL") ("OBCELL") ("RESIDUAL")))
    ("Add"                    pro "IDL_Container"     (system) "Obj -> [%s::]%s, Object" (("POSITION")))
    ("Cleanup"                pro "IDL_Container"     (system) "Obj-> [%s::]%s" nil)
    ("Move"                   pro "IDL_Container"     (system) "Obj -> [%s::]%s, Source, Destination" nil)
    ("Remove"                 pro "IDL_Container"     (system) "Obj -> [%s::]%s [, Child_object]" (("ALL") ("POSITION")))
    ("Count"                  fun "IDL_Container"     (system) "Result = Obj -> [%s::]%s()" nil)
    ("Get"                    fun "IDL_Container"     (system) "Result = Obj -> [%s::]%s ()" (("ALL") ("COUNT") ("ISA") ("POSITION")))
    ("Init"                   fun "IDL_Container"     (system) "Result = Obj -> [%s::]%s( ) ('IDL_Container')" nil)
    ("IsContained"            fun "IDL_Container"     (system) "Result = Obj -> [%s::]%s( Object)" (("POSITION")))
    ("AppendData"             pro "IDLanROI"          (system) "Obj->[%s::]%s, X [, Y] [, Z]" (("XRANGE") ("YRANGE") ("ZRANGE")))
    ("Cleanup"                pro "IDLanROI"          (system) "Obj->[%s::]%s" nil)
    ("GetProperty"            pro "IDLanROI"          (system) "Obj->[%s::]%s" (("ALL") ("BLOCKSIZE") ("DATA") ("DOUBLE") ("INTERIOR") ("N_VERTS") ("ROI_XRANGE") ("ROI_YRANGE") ("ROI_ZRANGE") ("TYPE")))
    ("RemoveData"             pro "IDLanROI"          (system) "Obj->[%s::]%s" (("COUNT") ("START") ("XRANGE") ("YRANGE") ("ZRANGE")))
    ("ReplaceData"            pro "IDLanROI"          (system) "Obj->[%s::]%s, X[, Y[, Z]]" (("FINISH") ("START") ("XRANGE") ("YRANGE") ("ZRANGE")))
    ("Rotate"                 pro "IDLanROI"          (system) "Obj->[%s::]%s, Axis, Angle" (("CENTER")))
    ("Scale"                  pro "IDLanROI"          (system) "Obj->[%s::]%s, Sx[, Sy[, Sz]]" nil)
    ("SetProperty"            pro "IDLanROI"          (system) "Obj->[%s::]%s" (("BLOCKSIZE") ("DATA") ("DOUBLE") ("INTERIOR")))
    ("Translate"              pro "IDLanROI"          (system) "Obj->[%s::]%s, Tx[, Ty[, Tz]]" nil)
    ("ComputeGeometry"        fun "IDLanROI"          (system) "Result = Obj->[%s::]%s()" (("AREA") ("CENTROID") ("PERIMETER") ("SPATIAL_OFFSET") ("SPATIAL_SCALE")))
    ("ComputeMask"            fun "IDLanROI"          (system) "Result = Obj->[%s::]%s()" (("DIMENSIONS") ("INITIALIZE") ("LOCATION") ("MASK_IN") ("MASK_RULE") ("PLANE_NORMAL") ("PLANE_XAXIS")))
    ("ContainsPoints"         fun "IDLanROI"          (system) "Result = Obj->[%s::]%s( X [, Y [, Z]] )" nil)
    ("Init"                   fun "IDLanROI"          (system) "Result = Obj -> [%s::]%s( [X [, Y [, Z ]]] ) ( 'IDLanROI' [, X [, Y [, Z]]])" (("BLOCKSIZE") ("DATA") ("DOUBLE") ("INTERIOR") ("TYPE")))
    ("Add"                    pro "IDLanROIGroup"     (system) "Obj->[%s::]%s, ROI" nil)
    ("Cleanup"                pro "IDLanROIGroup"     (system) "Obj->[%s::]%s" nil)
    ("GetProperty"            pro "IDLanROIGroup"     (system) "Obj->[%s::]%s" (("ALL") ("ROIGROUP_XRANGE") ("ROIGROUP_YRANGE") ("ROIGROUP_ZRANGE")))
    ("Rotate"                 pro "IDLanROIGroup"     (system) "Obj->[%s::]%s, Axis, Angle" (("CENTER")))
    ("Scale"                  pro "IDLanROIGroup"     (system) "Obj->[%s::]%s, Sx[, Sy[, Sz]]" nil)
    ("Translate"              pro "IDLanROIGroup"     (system) "Obj->[%s::]%s, Tx[, Ty[, Tz]]" nil)
    ("ComputeMask"            fun "IDLanROIGroup"     (system) "Result = Obj->[%s::]%s()" (("DIMENSIONS") ("INITIALIZE") ("LOCATION") ("MASK_IN") ("MASK_RULE")))
    ("ComputeMesh"            fun "IDLanROIGroup"     (system) "Result = Obj->[%s::]%s( Vertices, Conn)" (("CAPPED") ("SURFACE_AREA")))
    ("ContainsPoints"         fun "IDLanROIGroup"     (system) "Result = Obj->[%s::]%s( X[, Y[, Z]] )" nil)
    ("Init"                   fun "IDLanROIGroup"     (system) "Result = Obj->[%s::]%s( ) ('IDLanROIGroup')" nil)
    ("Connect"                pro "IDLdbDatabase"     (system) "DBobj ->[%s::]%s" (("CONNECTION") ("DATASOURCE") ("PASSWORD") ("USER_ID")))
    ("ExecuteSQL"             pro "IDLdbDatabase"     (system) "DBobj->ExecuteSQL, strSQL" nil)
    ("GetProperty"            pro "IDLdbDatabase"     (system) "DBobj->GetProperty" (("CAN_GET_TABLES") ("DBMS_NAME") ("DBMS_VERSION") ("DRIVER_ODBC_LEVEL") ("DRIVER_VERSION") ("IS_CONNECTED") ("IS_READONLY") ("MAX_CONNECTIONS") ("MAX_RECORDSETS") ("ODBC_LEVEL") ("SQL_LEVEL") ("SQL_SERVER_NAME") ("USE_CURSOR_LIB") ("USER_NAME")))
    ("SetProperty"            pro "IDLdbDatabase"     (system) "DBobj->SetProperty" (("N_BUFFERS") ("SQL") ("TABLE") ("USE_CURSOR_LIB") ("VERBOSE")))
    ("GetDatasources"         fun "IDLdbDatabase"     (system) "Datasources = DBObj->GetDatasources()" nil)
    ("GetTables"              fun "IDLdbDatabase"     (system) "Tables = DBObj->GetTables()" nil)
    ("AddRecord"              pro "IDLdbRecordset"    (system) "RSObj->AddRecord, [field1][field2]...[fieldn]" (("SET_AUTOINCREMENT")))
    ("DeleteRecord"           pro "IDLdbRecordset"    (system) "RSobj->DeleteRecord" nil)
    ("GetProperty"            pro "IDLdbRecordset"    (system) "RSobj->GetProperty" (("CAN_MOVE_ABSOLUTE") ("CAN_MOVE_FIRST") ("CAN_MOVE_LAST") ("CAN_MOVE_NEXT") ("CAN_MOVE_PRIOR") ("CAN_MOVE_RELATIVE") ("FIELD_INFO") ("GET_DATABASE") ("IS_READONLY") ("N_BUFFERS") ("RECORDSET_SOURCE")))
    ("SetField"               pro "IDLdbRecordset"    (system) "RSobj->SetField, iFieldNumber, Value" (("INFORMIX") ("NULL") ("SQL_TSI_DAY") ("SQL_TSI_FRAC_SECOND") ("SQL_TSI_HOUR") ("SQL_TSI_MINUTE") ("SQL_TSI_MONTH") ("SQL_TSI_QUARTER") ("SQL_TSI_SECOND") ("SQL_TSI_WEEK") ("SQL_TSI_YEAR") ("TNSNAME") ("UNIX")))
    ("CurrentRecord"          fun "IDLdbRecordset"    (system) "number = RSobj->CurrentRecord()" nil)
    ("GetField"               fun "IDLdbRecordset"    (system) "value = RSobj->GetField(iFieldNumber)" (("IS_NULL") ("NULL_VALUE")))
    ("GetRecord"              fun "IDLdbRecordset"    (system) "Result = RSObj->GetRecord()" nil)
    ("MoveCursor"             fun "IDLdbRecordset"    (system) "Result = RSObj->MoveCursor()" (("ABSOLUTE") ("FIRST") ("LAST") ("NEXT") ("PRIOR") ("RELATIVE")))
    ("NFields"                fun "IDLdbRecordset"    (system) "status = RSobj->NFields()" nil)
    ("Cleanup"                pro "IDLffDICOM"        (system) "OBJ -> [%s::]%s" nil)
    ("DumpElements"           pro "IDLffDICOM"        (system) "Obj -> [%s::]%s [, Filename]" nil)
    ("Reset"                  pro "IDLffDICOM"        (system) "Obj -> [%s::]%s" nil)
    ("GetChildren"            fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( Reference )" nil)
    ("GetDescription"         fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group [, Element]])" (("REFERENCE")))
    ("GetElement"             fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group [, Element]])" (("REFERENCE")))
    ("GetGroup"               fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group[, Element]])" (("REFERENCE")))
    ("GetLength"              fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group [, Element]])" (("REFERENCE")))
    ("GetParent"              fun "IDLffDICOM"        (system) "array = Obj ->[%s::]%s( ReferenceList )" nil)
    ("GetPreamble"            fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( )" nil)
    ("GetReference"           fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group [, Element]])" (("DESCRIPTION") ("VR")))
    ("GetValue"               fun "IDLffDICOM"        (system) "ptrArray = Obj -> [%s::]%s( [Group [, Element]])" (("NO_COPY") ("REFERENCE")))
    ("GetVR"                  fun "IDLffDICOM"        (system) "array = Obj -> [%s::]%s( [Group [, Element]])" (("REFERENCE")))
    ("Init"                   fun "IDLffDICOM"        (system) "Result = Obj -> [%s::]%s( [Filename])" (("VERBOSE")))
    ("Read"                   fun "IDLffDICOM"        (system) "Result = Obj -> [%s::]%s( Filename)" (("ENDIAN")))
    ("Cleanup"                pro "IDLffDXF"          (system) "Obj -> [%s::]%s" nil)
    ("GetPalette"             pro "IDLffDXF"          (system) "Obj-> [%s::]%s, Red, Green, Blue" nil)
    ("PutEntity"              pro "IDLffDXF"          (system) "Obj -> [%s::]%s, Data" nil)
    ("RemoveEntity"           pro "IDLffDXF"          (system) "Obj -> [%s::]%s[, Type]" (("INDEX")))
    ("Reset"                  pro "IDLffDXF"          (system) "Obj-> [%s::]%s" nil)
    ("SetPalette"             pro "IDLffDXF"          (system) "Obj-> [%s::]%s, Red, Green, Blue" nil)
    ("GetContents"            fun "IDLffDXF"          (system) "Result = Obj-> [%s::]%s( [Filter])" (("BLOCK") ("COUNT") ("LAYER")))
    ("GetEntity"              fun "IDLffDXF"          (system) "Result = Obj-> [%s::]%s( Type)" (("BLOCK") ("INDEX") ("LAYER")))
    ("Init"                   fun "IDLffDXF"          (system) "Result = Obj -> [%s::]%s( [Filename] ) ('IDLffDXF' [, Filename] )" nil)
    ("Read"                   fun "IDLffDXF"          (system) "Result = Obj-> [%s::]%s( Filename )" nil)
    ("Write"                  fun "IDLffDXF"          (system) "Result = Obj-> [%s::]%s( Filename )" nil)
    ("IsValid"                fun "IDLffLanguageCat"  (system) "Result = Obj ->[%s::]%s( )" nil)
    ("Query"                  fun "IDLffLanguageCat"  (system) "Result = Obj ->[%s::]%s( key)" (("DEFAULT_STRING")))
    ("SetCatalog"             fun "IDLffLanguageCat"  (system) "Result = Obj ->[%s::]%s( application)" (("FILENAME") ("LOCALE") ("PATH")))
    ("AddAttribute"           pro "IDLffShape"        (system) "Obj->[%s::]%s, Name, Type, Width" (("PRECISION")))
    ("Cleanup"                pro "IDLffShape"        (system) "Obj -> [%s::]%s" nil)
    ("Close"                  pro "IDLffShape"        (system) "Obj->[%s::]%s" nil)
    ("DestroyEntity"          pro "IDLffShape"        (system) "Obj->[%s::]%s, Entity" nil)
    ("GetProperty"            pro "IDLffShape"        (system) "Obj->[%s::]%s" (("ATTRIBUTE_INFO") ("ATTRIBUTE_NAMES") ("ENTITY_TYPE") ("FILENAME") ("IS_OPEN") ("N_ATTRIBUTES") ("N_ENTITIES")))
    ("PutEntity"              pro "IDLffShape"        (system) "Obj->[%s::]%s, Data" nil)
    ("SetAttributes"          pro "IDLffShape"        (system) "Obj->[%s::]%s, Index, Attribute_Num, Value or Obj->[IDLffShape::]SetAttributes, Index, Attributes" nil)
    ("GetAttributes"          fun "IDLffShape"        (system) "Result = Obj->[%s::]%s([Index])" (("ALL") ("ATTRIBUTE_STRUCTURE")))
    ("GetEntity"              fun "IDLffShape"        (system) "Result = Obj->[%s::]%s( [Index])" (("ALL") ("ATTRIBUTES")))
    ("Init"                   fun "IDLffShape"        (system) "Result = Obj -> [%s::]%s()" nil)
    ("Open"                   fun "IDLffShape"        (system) "Result = Obj->[%s::]%s( `Filename')" (("ENTITY_TYPE") ("UPDATE")))
    ("Cleanup"                pro "IDLgrAxis"         (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrAxis"         (system) "Obj -> [%s::]%s" (("ALL") ("AM_PM") ("COLOR") ("CRANGE") ("DAYS_OF_WEEK") ("DIRECTION") ("EXACT") ("EXTEND") ("GRIDSTYLE") ("HIDE") ("LOCATION") ("LOG") ("MAJOR") ("MINOR") ("MONTHS") ("NAME") ("NOTEXT") ("PALETTE") ("PARENT") ("RANGE") ("SUBTICKLEN") ("TEXTALIGNMENTS") ("TEXTBASELINE") ("TEXTPOS") ("TEXTUPDIR") ("THICK") ("TICKDIR") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKINTERVAL") ("TICKLAYOUT") ("TICKLEN") ("TICKTEXT") ("TICKUNITS") ("TICKVALUES") ("TITLE") ("USE_TEXT_COLOR") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrAxis"         (system) "Obj -> [%s::]%s" (("AM_PM") ("COLOR") ("DAYS_OF_WEEK") ("DIRECTION") ("EXACT") ("EXTEND") ("GRIDSTYLE") ("HIDE") ("LOCATION") ("LOG") ("MAJOR") ("MINOR") ("MONTHS") ("NAME") ("NOTEXT") ("PALETTE") ("RANGE") ("SUBTICKLEN") ("TEXTALIGNMENTS") ("TEXTBASELINE") ("TEXTPOS") ("TEXTUPDIR") ("THICK") ("TICKDIR") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKINTERVAL") ("TICKLAYOUT") ("TICKLEN") ("TICKTEXT") ("TICKUNITS") ("TICKVALUES") ("TITLE") ("USE_TEXT_COLOR") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("GetCTM"                 fun "IDLgrAxis"         (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrAxis"         (system) "Result = Obj -> [%s::]%s( [Direction] ) ('IDLgrAxis' [, Direction])" (("AM_PM") ("COLOR") ("DAYS_OF_WEEK") ("DIRECTION") ("EXACT") ("EXTEND") ("GRIDSTYLE") ("HIDE") ("LOCATION") ("LOG") ("MAJOR") ("MINOR") ("MONTHS") ("NAME") ("NOTEXT") ("PALETTE") ("RANGE") ("SUBTICKLEN") ("TEXTALIGNMENTS") ("TEXTBASELINE") ("TEXTPOS") ("TEXTUPDIR") ("THICK") ("TICKDIR") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKINTERVAL") ("TICKLAYOUT") ("TICKLEN") ("TICKTEXT") ("TICKUNITS") ("TICKVALUES") ("TITLE") ("USE_TEXT_COLOR") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("Cleanup"                pro "IDLgrBuffer"       (system) "Obj -> [%s::]%s" nil)
    ("Draw"                   pro "IDLgrBuffer"       (system) "Obj -> [%s::]%s [, Picture]" (("CREATE_INSTANCE") ("DRAW_INSTANCE")))
    ("Erase"                  pro "IDLgrBuffer"       (system) "Obj -> [%s::]%s" (("COLOR")))
    ("GetDeviceInfo"          pro "IDLgrBuffer"       (system) "Obj->[%s::]%s" (("ALL") ("MAX_TEXTURE_DIMENSIONS") ("MAX_VIEWPORT_DIMENSIONS") ("NAME") ("NUM_CPUS") ("VENDOR") ("VERSION")))
    ("GetProperty"            pro "IDLgrBuffer"       (system) "Obj -> [%s::]%s" (("ALL") ("COLOR_MODEL") ("DIMENSIONS") ("GRAPHICS_TREE") ("IMAGE_DATA") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("SCREEN_DIMENSIONS") ("UNITS") ("UVALUE") ("ZBUFFER_DATA")))
    ("SetProperty"            pro "IDLgrBuffer"       (system) "Obj -> [%s::]%s" (("DIMENSIONS") ("GRAPHICS_TREE") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")))
    ("GetContiguousPixels"    fun "IDLgrBuffer"       (system) "Return = Obj -> [%s::]%s()" nil)
    ("GetFontnames"           fun "IDLgrBuffer"       (system) "Return = Obj -> [%s::]%s( FamilyName)" (("IDL_FONTS") ("STYLES")))
    ("GetTextDimensions"      fun "IDLgrBuffer"       (system) "Result = Obj ->[%s::]%s( TextObj)" (("DESCENT") ("PATH")))
    ("Init"                   fun "IDLgrBuffer"       (system) "Result = Obj -> [%s::]%s( ) ('IDLgrBuffer')" (("COLOR_MODEL") ("DIMENSIONS") ("GRAPHICS_TREE") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")))
    ("PickData"               fun "IDLgrBuffer"       (system) "Result = Obj -> [%s::]%s( View, Object, Location, XYZLocation)" (("PATH")))
    ("Read"                   fun "IDLgrBuffer"       (system) "Result = Obj -> [%s::]%s()" nil)
    ("Select"                 fun "IDLgrBuffer"       (system) "Result = Obj -> [%s::]%s(Picture, XY)" (("DIMENSIONS") ("UNITS")))
    ("Cleanup"                pro "IDLgrClipboard"    (system) "Obj-> [%s::]%s" nil)
    ("Draw"                   pro "IDLgrClipboard"    (system) "Obj -> [%s::]%s [, Picture]" (("FILENAME") ("POSTSCRIPT") ("VECTOR")))
    ("GetDeviceInfo"          pro "IDLgrClipboard"    (system) "Obj->[%s::]%s" (("ALL") ("MAX_TEXTURE_DIMENSIONS") ("MAX_VIEWPORT_DIMENSIONS") ("NAME") ("NUM_CPUS") ("VENDOR") ("VERSION")))
    ("GetProperty"            pro "IDLgrClipboard"    (system) "Obj -> [%s::]%s" (("ALL") ("COLOR_MODEL") ("DIMENSIONS") ("GRAPHICS_TREE") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("SCREEN_DIMENSIONS") ("UNITS") ("UVALUE")))
    ("SetProperty"            pro "IDLgrClipboard"    (system) "Obj -> [%s::]%s" (("DIMENSIONS") ("GRAPHICS_TREE") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")))
    ("GetContiguousPixels"    fun "IDLgrClipboard"    (system) "Return = Obj ->[%s::]%s()" nil)
    ("GetFontnames"           fun "IDLgrClipboard"    (system) "Return = Obj -> [%s::]%s( FamilyName)" (("IDL_FONTS") ("STYLES")))
    ("GetTextDimensions"      fun "IDLgrClipboard"    (system) "Result = Obj ->[%s::]%s( TextObj)" (("DESCENT") ("PATH")))
    ("Init"                   fun "IDLgrClipboard"    (system) "Result = Obj -> [%s::]%s( ) ('IDLgrClipboard')" (("COLOR_MODEL") ("DIMENSIONS") ("GRAPHICS_TREE") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")))
    ("Cleanup"                pro "IDLgrColorbar"     (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrColorbar"     (system) "Obj -> [%s::]%s" (("ALL") ("BLUE_VALUES") ("COLOR") ("DIMENSIONS") ("GREEN_VALUES") ("HIDE") ("MAJOR") ("MINOR") ("NAME") ("PALETTE") ("PARENT") ("RED_VALUES") ("SHOW_AXIS") ("SHOW_OUTLINE") ("SUBTICKLEN") ("THICK") ("THREED") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKLEN") ("TICKTEXT") ("TICKVALUES") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrColorbar"     (system) "Obj -> [%s::]%s" (("BLUE_VALUES") ("COLOR") ("DIMENSIONS") ("GREEN_VALUES") ("HIDE") ("MAJOR") ("MINOR") ("NAME") ("PALETTE") ("RED_VALUES") ("SHOW_AXIS") ("SHOW_OUTLINE") ("SUBTICKLEN") ("THICK") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKLEN") ("TICKTEXT") ("TICKVALUES") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("ComputeDimensions"      fun "IDLgrColorbar"     (system) "Result = Obj ->[%s::]%s( DestinationObj)" (("PATH")))
    ("Init"                   fun "IDLgrColorbar"     (system) "Result = Obj -> [%s::]%s( [aRed, aGreen, aBlue] ) ( 'IDLgrColorbar' [, aRed, aGreen, aBlue])" (("BLUE_VALUES") ("COLOR") ("DIMENSIONS") ("GREEN_VALUES") ("HIDE") ("MAJOR") ("MINOR") ("NAME") ("PALETTE") ("RED_VALUES") ("SHOW_AXIS") ("SHOW_OUTLINE") ("SUBTICKLEN") ("THICK") ("THREED") ("TICKFORMAT") ("TICKFRMTDATA") ("TICKLEN") ("TICKTEXT") ("TICKVALUES") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("Cleanup"                pro "IDLgrContour"      (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrContour"      (system) "Obj -> [%s::]%s" (("ALL") ("ANISOTROPY") ("C_COLOR") ("C_FILL_PATTERN") ("C_LINESTYLE") ("C_THICK") ("C_VALUE") ("COLOR") ("DATA_VALUES") ("DOWNHILL") ("FILL") ("GEOM") ("HIDE") ("MAX_VALUE") ("MIN_VALUE") ("N_LEVELS") ("NAME") ("PALETTE") ("PARENT") ("PLANAR") ("POLYGONS") ("SHADE_RANGE") ("SHADING") ("TICKINTERVAL") ("TICKLEN") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrContour"      (system) "Obj -> [%s::]%s" (("ANISOTROPY") ("C_COLOR") ("C_FILL_PATTERN") ("C_LINESTYLE") ("C_THICK") ("C_VALUE") ("COLOR") ("DATA_VALUES") ("DOWNHILL") ("FILL") ("GEOMX") ("GEOMY") ("GEOMZ") ("HIDE") ("MAX_VALUE") ("MIN_VALUE") ("N_LEVELS") ("NAME") ("PALETTE") ("PLANAR") ("POLYGONS") ("SHADE_RANGE") ("SHADING") ("TICKINTERVAL") ("TICKLEN") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("GetCTM"                 fun "IDLgrContour"      (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrContour"      (system) "Result = Obj -> [%s::]%s( [Values] ) ('IDLgrContour' [, Values])" (("ANISOTROPY") ("C_COLOR") ("C_FILL_PATTERN") ("C_LINESTYLE") ("C_THICK") ("C_VALUE") ("COLOR") ("DATA_VALUES") ("DOUBLE_DATA") ("DOUBLE_GEOM") ("DOWNHILL") ("FILL") ("GEOMX") ("GEOMY") ("GEOMZ") ("HIDE") ("MAX_VALUE") ("MIN_VALUE") ("N_LEVELS") ("NAME") ("PALETTE") ("PLANAR") ("POLYGONS") ("SHADE_RANGE") ("SHADING") ("TICKINTERVAL") ("TICKLEN") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("Cleanup"                pro "IDLgrFont"         (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrFont"         (system) "Obj -> [%s:]%s" (("ALL") ("NAME") ("SIZE") ("SUBSTITUTE") ("THICK") ("UVALUE")))
    ("SetProperty"            pro "IDLgrFont"         (system) "Obj -> [%s:]%s" (("NAME") ("SIZE") ("SUBSTITUTE") ("THICK") ("UVALUE")))
    ("Init"                   fun "IDLgrFont"         (system) "Result = Obj -> [%s::]%s( [Fontname] ) ('IDLgrFont' [, Fontname])" (("NAME") ("SIZE") ("SUBSTITUTE") ("THICK") ("UVALUE")))
    ("Cleanup"                pro "IDLgrImage"        (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrImage"        (system) "Obj -> [%s::]%s" (("ALL") ("BLEND_FUNCTION") ("CHANNEL") ("DATA") ("DIMENSIONS") ("GREYSCALE") ("HIDE") ("INTERLEAVE") ("INTERPOLATE") ("LOCATION") ("NAME") ("NO_COPY") ("ORDER") ("PALETTE") ("PARENT") ("SUB_RECT") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrImage"        (system) "Obj -> [%s::]%s" (("BLEND_FUNCTION") ("CHANNEL") ("DATA") ("DIMENSIONS") ("GREYSCALE") ("HIDE") ("INTERLEAVE") ("INTERPOLATE") ("LOCATION") ("NAME") ("NO_COPY") ("ORDER") ("PALETTE") ("RESET_DATA") ("SHARE_DATA") ("SUB_RECT") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("GetCTM"                 fun "IDLgrImage"        (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrImage"        (system) "Result = Obj -> [%s::]%s( [ImageData] ) ('IDLgrImage' [, ImageData])" (("BLEND_FUNCTION") ("CHANNEL") ("DATA") ("DIMENSIONS") ("GREYSCALE") ("HIDE") ("INTERLEAVE") ("INTERPOLATE") ("LOCATION") ("NAME") ("NO_COPY") ("ORDER") ("PALETTE") ("RESET_DATA") ("SHARE_DATA") ("SUB_RECT") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("Cleanup"                pro "IDLgrLegend"       (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrLegend"       (system) "Obj -> [%s::]%s" (("ALL") ("BORDER_GAP") ("COLUMNS") ("FILL_COLOR") ("FONT") ("GAP") ("GLYPH_WIDTH") ("HIDE") ("ITEM_COLOR") ("ITEM_LINESTYLE") ("ITEM_NAME") ("ITEM_OBJECT") ("ITEM_THICK") ("ITEM_TYPE") ("NAME") ("OUTLINE_COLOR") ("OUTLINE_THICK") ("PARENT") ("SHOW_FILL") ("SHOW_OUTLINE") ("TEXT_COLOR") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrLegend"       (system) "Obj-> [%s::]%s" (("BORDER_GAP") ("COLUMNS") ("FILL_COLOR") ("FONT") ("GAP") ("GLYPH_WIDTH") ("HIDE") ("ITEM_COLOR") ("ITEM_LINESTYLE") ("ITEM_NAME") ("ITEM_OBJECT") ("ITEM_THICK") ("ITEM_TYPE") ("NAME") ("OUTLINE_COLOR") ("OUTLINE_THICK") ("RECOMPUTE") ("SHOW_FILL") ("SHOW_OUTLINE") ("TEXT_COLOR") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("ComputeDimensions"      fun "IDLgrLegend"       (system) "Result = Obj ->[%s::]%s( DestinationObject)" (("PATH")))
    ("Init"                   fun "IDLgrLegend"       (system) "Result = Obj -> [%s::]%s( [aItemNames] ) ('IDLgrLegend' [, aItemNames])" (("BORDER_GAP") ("COLUMNS") ("FILL_COLOR") ("FONT") ("GAP") ("GLYPH_WIDTH") ("HIDE") ("ITEM_COLOR") ("ITEM_LINESTYLE") ("ITEM_NAME") ("ITEM_OBJECT") ("ITEM_THICK") ("ITEM_TYPE") ("NAME") ("OUTLINE_COLOR") ("OUTLINE_THICK") ("SHOW_FILL") ("SHOW_OUTLINE") ("TEXT_COLOR") ("TITLE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("Cleanup"                pro "IDLgrLight"        (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrLight"        (system) "Obj -> [%s::]%s" (("ALL") ("ATTENUATION") ("COLOR") ("CONEANGLE") ("DIRECTION") ("FOCUS") ("HIDE") ("INTENSITY") ("LOCATION") ("NAME") ("PARENT") ("TYPE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("SetProperty"            pro "IDLgrLight"        (system) "Obj -> [%s::]%s" (("ATTENUATION") ("COLOR") ("CONEANGLE") ("DIRECTION") ("FOCUS") ("HIDE") ("INTENSITY") ("LOCATION") ("NAME") ("TYPE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("GetCTM"                 fun "IDLgrLight"        (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrLight"        (system) "Result = Obj -> [%s::]%s( ) ('IDLgrLight')" (("ATTENUATION") ("COLOR") ("CONEANGLE") ("DIRECTION") ("FOCUS") ("HIDE") ("INTENSITY") ("LOCATION") ("NAME") ("TYPE") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("Add"                    pro "IDLgrModel"        (system) "Obj -> [%s::]%s, Object" (("ALIAS") ("POSITION")))
    ("Cleanup"                pro "IDLgrModel"        (system) "Obj -> [%s::]%s" nil)
    ("Draw"                   pro "IDLgrModel"        (system) "Obj -> [%s::]%s, Destination, Picture" nil)
    ("GetProperty"            pro "IDLgrModel"        (system) "Obj -> [%s::]%s" (("ALL") ("HIDE") ("LIGHTING") ("NAME") ("PARENT") ("SELECT_TARGET") ("TRANSFORM") ("UVALUE")))
    ("Reset"                  pro "IDLgrModel"        (system) "Obj -> [%s::]%s" nil)
    ("Rotate"                 pro "IDLgrModel"        (system) "Obj -> [%s::]%s, Axis, Angle" (("PREMULTIPLY")))
    ("Scale"                  pro "IDLgrModel"        (system) "Obj -> [%s::]%s, Sx, Sy, Sz" (("PREMULTIPLY")))
    ("SetProperty"            pro "IDLgrModel"        (system) "Obj -> [%s::]%s" (("HIDE") ("LIGHTING") ("NAME") ("SELECT_TARGET") ("TRANSFORM") ("UVALUE")))
    ("Translate"              pro "IDLgrModel"        (system) "Obj -> [%s::]%s, Tx, Ty, Tz" (("PREMULTIPLY")))
    ("GetByName"              fun "IDLgrModel"        (system) "Result = Obj -> [%s::]%s(Name)" nil)
    ("GetCTM"                 fun "IDLgrModel"        (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrModel"        (system) "Result = Obj -> [%s::]%s( ) ('IDLgrModel')" (("HIDE") ("LIGHTING") ("NAME") ("SELECT_TARGET") ("TRANSFORM") ("UVALUE")))
    ("Cleanup"                pro "IDLgrMPEG"         (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrMPEG"         (system) "Obj -> [%s::]%s" (("ALL") ("BITRATE") ("DIMENSIONS") ("FILENAME") ("FORMAT") ("FRAME_RATE") ("IFRAME_GAP") ("INTERLACED") ("MOTION_VEC_LENGTH") ("QUALITY") ("SCALE") ("STATISTICS")))
    ("Put"                    pro "IDLgrMPEG"         (system) "Obj -> [%s::]%s, Image[, Frame]" nil)
    ("Save"                   pro "IDLgrMPEG"         (system) "Obj -> [%s::]%s" (("CREATOR_TYPE") ("FILENAME")))
    ("SetProperty"            pro "IDLgrMPEG"         (system) "Obj -> [%s::]%s" (("BITRATE") ("DIMENSIONS") ("FILENAME") ("FORMAT") ("FRAME_RATE") ("IFRAME_GAP") ("INTERLACED") ("MOTION_VEC_LENGTH") ("QUALITY") ("SCALE") ("STATISTICS")))
    ("Init"                   fun "IDLgrMPEG"         (system) "Result = Obj -> [%s::]%s( ) ('IDLgrMPEG')" (("BITRATE") ("DIMENSIONS") ("FILENAME") ("FORMAT") ("FRAME_RATE") ("IFRAME_GAP") ("INTERLACED") ("MOTION_VEC_LENGTH") ("QUALITY") ("SCALE") ("STATISTICS") ("TEMP_DIRECTORY")))
    ("Cleanup"                pro "IDLgrPalette"      (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrPalette"      (system) "Obj -> [%s::]%s" (("ALL") ("BLUE_VALUES") ("BOTTOM_STRETCH") ("GAMMA") ("GREEN_VALUES") ("N_COLORS") ("NAME") ("RED_VALUES") ("TOP_STRETCH") ("UVALUE")))
    ("LoadCT"                 pro "IDLgrPalette"      (system) "Obj -> [%s::]%s, TableNum" (("FILENAME")))
    ("SetProperty"            pro "IDLgrPalette"      (system) "Obj -> [%s::]%s" (("BLUE_VALUES") ("BOTTOM_STRETCH") ("GAMMA") ("GREEN_VALUES") ("NAME") ("RED_VALUES") ("TOP_STRETCH") ("UVALUE")))
    ("SetRGB"                 pro "IDLgrPalette"      (system) "Obj -> [%s::]%s, Index, Red, Green, Blue" nil)
    ("GetRGB"                 fun "IDLgrPalette"      (system) "Result = Obj -> [%s::]%s(Index)" nil)
    ("Init"                   fun "IDLgrPalette"      (system) "Result=Obj-> [%s::]%s( [aRed, aGreen, aBlue] ) ('IDLgrPalette', aRed, aGreen, aBlue)" (("BLUE_VALUES") ("BOTTOM_STRETCH") ("GAMMA") ("GREEN_VALUES") ("NAME") ("RED_VALUES") ("TOP_STRETCH") ("UVALUE")))
    ("NearestColor"           fun "IDLgrPalette"      (system) "Result = Obj-> [%s::]%s(Red, Green, Blue)" nil)
    ("Cleanup"                pro "IDLgrPattern"      (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrPattern"      (system) "Obj -> [%s::]%s" (("ALL") ("NAME") ("ORIENTATION") ("PATTERN") ("SPACING") ("STYLE") ("UVALUE")))
    ("SetProperty"            pro "IDLgrPattern"      (system) "Obj -> [%s::]%s" (("NAME") ("ORIENTATION") ("PATTERN") ("SPACING") ("STYLE") ("UVALUE")))
    ("Init"                   fun "IDLgrPattern"      (system) "Result = Obj -> [%s::]%s( [Style] ) ('IDLgrPattern' [, Style])" (("NAME") ("ORIENTATION") ("PATTERN") ("SPACING") ("STYLE") ("THICK") ("UVALUE")))
    ("Cleanup"                pro "IDLgrPlot"         (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrPlot"         (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("DATA") ("DOUBLE") ("HIDE") ("HISTOGRAM") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("NSUM") ("PALETTE") ("PARENT") ("POLAR") ("SYMBOL") ("THICK") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE") ("ZVALUE")))
    ("SetProperty"            pro "IDLgrPlot"         (system) "Obj -> [%s::]%s" (("COLOR") ("DATAY") ("DOUBLE") ("HIDE") ("HISTOGRAM") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("NSUM") ("PALETTE") ("POLAR") ("RESET_DATA") ("SHARE_DATA") ("SYMBOL") ("THICK") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZVALUE")))
    ("GetCTM"                 fun "IDLgrPlot"         (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrPlot"         (system) "Result = Obj -> [%s::]%s( [[X,] Y] ) ('IDLgrPlot' [, [X,] Y])" (("COLOR") ("DATAY") ("DOUBLE") ("HIDE") ("HISTOGRAM") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("NSUM") ("PALETTE") ("POLAR") ("RESET_DATA") ("SHARE_DATA") ("SYMBOL") ("THICK") ("USE_ZVALUE") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZVALUE")))
    ("Cleanup"                pro "IDLgrPolygon"      (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrPolygon"      (system) "Obj -> [%s::]%s" (("ALL") ("BOTTOM") ("COLOR") ("DATA") ("DOUBLE") ("FILL_PATTERN") ("HIDE") ("LINESTYLE") ("NAME") ("NORMALS") ("PARENT") ("POLYGONS") ("REJECT") ("SHADE_RANGE") ("SHADING") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrPolygon"      (system) "Obj -> [%s::]%s" (("BOTTOM") ("COLOR") ("DATA") ("DOUBLE") ("FILL_PATTERN") ("HIDE") ("LINESTYLE") ("NAME") ("NORMALS") ("POLYGONS") ("REJECT") ("RESET_DATA") ("SHADE_RANGE") ("SHADING") ("SHARE_DATA") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")))
    ("GetCTM"                 fun "IDLgrPolygon"      (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrPolygon"      (system) "Result = Obj -> [%s::]%s( [X, [Y, [Z]]] ) ('IDLgrPolygon' [, X [, Y[, Z]]])" (("BOTTOM") ("COLOR") ("DATA") ("DOUBLE") ("FILL_PATTERN") ("HIDDEN_LINES") ("HIDE") ("LINESTYLE") ("NAME") ("NORMALS") ("PALETTE") ("POLYGONS") ("REJECT") ("RESET_DATA") ("SHADE_RANGE") ("SHADING") ("SHARE_DATA") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")))
    ("Cleanup"                pro "IDLgrPolyline"     (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrPolyline"     (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("DATA") ("DOUBLE") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("PARENT") ("POLYLINES") ("SHADING") ("SYMBOL") ("THICK") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrPolyline"     (system) "Obj -> [%s::]%s" (("COLOR") ("DATA") ("DOUBLE") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("POLYLINES") ("RESET_DATA") ("SHADING") ("SHARE_DATA") ("SYMBOL") ("THICK") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("GetCTM"                 fun "IDLgrPolyline"     (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrPolyline"     (system) "Result = Obj -> [%s::]%s( [X, [Y, [Z]]] ) ('IDLgrPolyline' [, X [, Y[, Z]]])" (("COLOR") ("DATA") ("DOUBLE") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("POLYLINES") ("RESET_DATA") ("SHADING") ("SHARE_DATA") ("SYMBOL") ("THICK") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("Cleanup"                pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s" nil)
    ("Draw"                   pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s [, Picture]" (("VECTOR")))
    ("GetProperty"            pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s" (("ALL") ("COLOR_MODEL") ("DIMENSIONS") ("GRAPHICS_TREE") ("LANDSCAPE") ("N_COLORS") ("N_COPIES") ("NAME") ("PALETTE") ("PRINT_QUALITY") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")))
    ("NewDocument"            pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s" nil)
    ("NewPage"                pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s" nil)
    ("SetProperty"            pro "IDLgrPrinter"      (system) "Obj -> [%s::]%s" (("GRAPHICS_TREE") ("LANDSCAPE") ("N_COPIES") ("PALETTE") ("PRINT_QUALITY") ("QUALITY") ("UNITS") ("UVALUE")))
    ("GetContiguousPixels"    fun "IDLgrPrinter"      (system) "Return = Obj -> [%s::]%s()" nil)
    ("GetFontnames"           fun "IDLgrPrinter"      (system) "Return = Obj -> [%s::]%s( FamilyName)" (("IDL_FONTS") ("STYLES")))
    ("GetTextDimensions"      fun "IDLgrPrinter"      (system) "Result = Obj ->[%s::]%s( TextObj)" (("DESCENT") ("PATH")))
    ("Init"                   fun "IDLgrPrinter"      (system) "Result = Obj -> [%s::]%s( ) ('IDLgrPrinter')" (("COLOR_MODEL") ("GRAPHICS_TREE") ("LANDSCAPE") ("N_COLORS") ("N_COPIES") ("PALETTE") ("PRINT_QUALITY") ("QUALITY") ("UNITS") ("UVALUE")))
    ("Cleanup"                pro "IDLgrROI"          (system) "Obj->[%s::]%s" nil)
    ("GetProperty"            pro "IDLgrROI"          (system) "Obj->[%s::]%s" (("ALL") ("COLOR") ("DOUBLE") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("STYLE") ("SYMBOL") ("THICK") ("UVALUE") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrROI"          (system) "Obj->[%s::]%s" (("COLOR") ("DOUBLE") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("STYLE") ("SYMBOL") ("THICK") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("Init"                   fun "IDLgrROI"          (system) "Result = Obj->[%s::]%s([X[, Y[, Z]]] ) ( 'IDLgrROI' [, X[, Y[, Z]]])" (("COLOR") ("DOUBLE") ("HIDE") ("LINESTYLE") ("NAME") ("PALETTE") ("STYLE") ("SYMBOL") ("THICK") ("UVALUE") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("PickVertex"             fun "IDLgrROI"          (system) "Result = Obj->[%s::]%s( Dest, View, Point)" (("PATH")))
    ("Add"                    pro "IDLgrROIGroup"     (system) "Obj->[%s::]%s, ROI" nil)
    ("Cleanup"                pro "IDLgrROIGroup"     (system) "Obj->[%s::]%s" nil)
    ("GetProperty"            pro "IDLgrROIGroup"     (system) "Obj->[%s::]%s" (("ALL") ("COLOR") ("HIDE") ("NAME") ("PARENT") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrROIGroup"     (system) "Obj->[%s::]%s" (("COLOR") ("HIDE") ("NAME") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("Init"                   fun "IDLgrROIGroup"     (system) "Result = Obj->[%s::]%s( ) ('IDLgrROIGroup')" (("COLOR") ("HIDE") ("NAME") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("PickRegion"             fun "IDLgrROIGroup"     (system) "Result = Obj->[%s::]%s( Dest, View, Point)" (("PATH")))
    ("Add"                    pro "IDLgrScene"        (system) "Obj -> [%s::]%s, View" (("POSITION")))
    ("Cleanup"                pro "IDLgrScene"        (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrScene"        (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("HIDE") ("NAME") ("TRANSPARENT") ("UVALUE")))
    ("SetProperty"            pro "IDLgrScene"        (system) "Obj -> [%s::]%s" (("COLOR") ("HIDE") ("NAME") ("TRANSPARENT") ("UVALUE")))
    ("GetByName"              fun "IDLgrScene"        (system) "Result = Obj -> [%s::]%s(Name)" nil)
    ("Init"                   fun "IDLgrScene"        (system) "Result = Obj -> [%s::]%s( ) ('IDLgrScene')" (("COLOR") ("HIDE") ("NAME") ("TRANSPARENT") ("UVALUE")))
    ("Cleanup"                pro "IDLgrSurface"      (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrSurface"      (system) "Obj -> [%s::]%s" (("ALL") ("BOTTOM") ("COLOR") ("DATA") ("DOUBLE") ("EXTENDED_LEGO") ("HIDDEN_LINES") ("HIDE") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("PALETTE") ("PARENT") ("SHADE_RANGE") ("SHADING") ("SHOW_SKIRT") ("SKIRT") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("USE_TRIANGLES") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrSurface"      (system) "Obj -> [%s::]%s" (("BOTTOM") ("COLOR") ("DATAX") ("DATAY") ("DATAZ") ("DOUBLE") ("EXTENDED_LEGO") ("HIDDEN_LINES") ("HIDE") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("PALETTE") ("RESET_DATA") ("SHADE_RANGE") ("SHADING") ("SHARE_DATA") ("SHOW_SKIRT") ("SKIRT") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("USE_TRIANGLES") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")))
    ("GetCTM"                 fun "IDLgrSurface"      (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrSurface"      (system) "Result = Obj -> [%s::]%s( [Z [, X, Y]] ) ('IDLgrSurface' [, Z [, X, Y]])" (("BOTTOM") ("COLOR") ("DATAX") ("DATAY") ("DATAZ") ("DOUBLE") ("EXTENDED_LEGO") ("HIDDEN_LINES") ("HIDE") ("LINESTYLE") ("MAX_VALUE") ("MIN_VALUE") ("NAME") ("PALETTE") ("RESET_DATA") ("SHADE_RANGE") ("SHADING") ("SHARE_DATA") ("SHOW_SKIRT") ("SKIRT") ("STYLE") ("TEXTURE_COORD") ("TEXTURE_INTERP") ("TEXTURE_MAP") ("THICK") ("USE_TRIANGLES") ("UVALUE") ("VERT_COLORS") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")))
    ("Cleanup"                pro "IDLgrSymbol"       (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrSymbol"       (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("DATA") ("NAME") ("SIZE") ("THICK") ("UVALUE")))
    ("SetProperty"            pro "IDLgrSymbol"       (system) "Obj -> [%s::]%s" (("COLOR") ("DATA") ("NAME") ("SIZE") ("THICK") ("UVALUE")))
    ("Init"                   fun "IDLgrSymbol"       (system) "Result = Obj -> [%s::]%s( [Data] ) ('IDLgrSymbol' [, Data])" (("COLOR") ("DATA") ("NAME") ("SIZE") ("THICK") ("UVALUE")))
    ("AddPolygon"             pro "IDLgrTessellator"  (system) "Obj -> [%s::]%s, X [, Y[, Z]]" (("INTERIOR") ("POLYGON")))
    ("Cleanup"                pro "IDLgrTessellator"  (system) "Obj -> [%s::]%s" nil)
    ("Reset"                  pro "IDLgrTessellator"  (system) "Obj -> [%s::]%s" nil)
    ("Init"                   fun "IDLgrTessellator"  (system) "Result = Obj -> [%s::]%s( ) ('IDLgrTesselator')" nil)
    ("Tessellate"             fun "IDLgrTessellator"  (system) "Result = Obj -> [%s::]%s( Vertices, Poly)" (("QUIET")))
    ("Cleanup"                pro "IDLgrText"         (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrText"         (system) "Obj -> [%s::]%s" (("ALIGNMENT") ("ALL") ("BASELINE") ("CHAR_DIMENSIONS") ("COLOR") ("ENABLE_FORMATTING") ("FONT") ("HIDE") ("LOCATIONS") ("NAME") ("ONGLASS") ("PALETTE") ("PARENT") ("RECOMPUTE_DIMENSIONS") ("STRINGS") ("UPDIR") ("UVALUE") ("VERTICAL_ALIGNMENT") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZCOORD_CONV") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrText"         (system) "Obj -> [%s::]%s" (("ALIGNMENT") ("BASELINE") ("CHAR_DIMENSIONS") ("COLOR") ("ENABLE_FORMATTING") ("FONT") ("HIDE") ("LOCATIONS") ("NAME") ("ONGLASS") ("PALETTE") ("RECOMPUTE_DIMENSIONS") ("STRINGS") ("UPDIR") ("UVALUE") ("VERTICAL_ALIGNMENT") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("GetCTM"                 fun "IDLgrText"         (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrText"         (system) "Result = Obj -> [%s::]%s( [String or vector of strings] ) ('IDLgrText' [, String or vector of strings])" (("ALIGNMENT") ("BASELINE") ("CHAR_DIMENSIONS") ("COLOR") ("ENABLE_FORMATTING") ("FONT") ("HIDE") ("LOCATIONS") ("NAME") ("ONGLASS") ("PALETTE") ("RECOMPUTE_DIMENSIONS") ("STRINGS") ("UPDIR") ("UVALUE") ("VERTICAL_ALIGNMENT") ("XCOORD_CONV") ("YCOORD_CONV") ("ZCOORD_CONV")))
    ("Add"                    pro "IDLgrView"         (system) "Obj -> [%s::]%s, Model" (("POSITION")))
    ("Cleanup"                pro "IDLgrView"         (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrView"         (system) "Obj -> [%s::]%s" (("ALL") ("COLOR") ("DEPTH_CUE") ("DIMENSIONS") ("EYE") ("LOCATION") ("PARENT") ("PROJECTION") ("TRANSPARENT") ("UNITS") ("UVALUE") ("VIEWPLANE_RECT") ("ZCLIP")))
    ("SetProperty"            pro "IDLgrView"         (system) "Obj -> [%s::]%s" (("COLOR") ("DEPTH_CUE") ("DIMENSIONS") ("EYE") ("LOCATION") ("PROJECTION") ("TRANSPARENT") ("UNITS") ("UVALUE") ("VIEWPLANE_RECT") ("ZCLIP")))
    ("GetByName"              fun "IDLgrView"         (system) "Result = Obj -> [%s::]%s(Name)" nil)
    ("Init"                   fun "IDLgrView"         (system) "Result = Obj -> [%s::]%s( ) ('IDLgrView')" (("COLOR") ("DEPTH_CUE") ("DIMENSIONS") ("DOUBLE") ("EYE") ("LOCATION") ("PROJECTION") ("TRANSPARENT") ("UNITS") ("UVALUE") ("VIEWPLANE_RECT") ("ZCLIP")))
    ("Add"                    pro "IDLgrViewgroup"    (system) "Obj -> [%s::]%s, Object" (("POSITION")))
    ("Cleanup"                pro "IDLgrViewgroup"    (system) "Obj -> [%s::]%s" nil)
    ("GetProperty"            pro "IDLgrViewgroup"    (system) "Obj -> [%s::]%s" (("ALL") ("HIDE") ("NAME") ("PARENT") ("UVALUE")))
    ("SetProperty"            pro "IDLgrViewgroup"    (system) "Obj -> [%s::]%s" (("HIDE") ("NAME") ("UVALUE")))
    ("GetByName"              fun "IDLgrViewgroup"    (system) "Result = Obj -> [%s::]%s(Name)" nil)
    ("Init"                   fun "IDLgrViewgroup"    (system) "Result = Obj -> [%s::]%s( ) ('IDLgrViewgroup')" (("HIDE") ("NAME") ("UVALUE")))
    ("Cleanup"                pro "IDLgrVolume"       (system) "Obj -> [%s::]%s" nil)
    ("ComputeBounds"          pro "IDLgrVolume"       (system) "Obj -> [%s::]%s" (("OPACITY") ("RESET") ("VOLUMES")))
    ("GetProperty"            pro "IDLgrVolume"       (system) "Obj -> [%s::]%s" (("ALL") ("AMBIENT") ("BOUNDS") ("COMPOSITE_FUNCTION") ("CUTTING_PLANES") ("DATA0") ("DATA1") ("DATA2") ("DATA3") ("DEPTH_CUE") ("HIDE") ("HINTS") ("INTERPOLATE") ("LIGHTING_MODEL") ("NAME") ("NO_COPY") ("OPACITY_TABLE0") ("OPACITY_TABLE1") ("PARENT") ("RENDER_STEP") ("RGB_TABLE0") ("RGB_TABLE1") ("TWO_SIDED") ("UVALUE") ("VALID_DATA") ("VOLUME_SELECT") ("XCOORD_CONV") ("XRANGE") ("YCOORD_CONV") ("YRANGE") ("ZBUFFER") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP") ("ZRANGE")))
    ("SetProperty"            pro "IDLgrVolume"       (system) "Obj -> [%s::]%s" (("AMBIENT") ("BOUNDS") ("COMPOSITE_FUNCTION") ("CUTTING_PLANES") ("DATA0") ("DATA1") ("DATA2") ("DATA3") ("DEPTH_CUE") ("HIDE") ("HINTS") ("INTERPOLATE") ("LIGHTING_MODEL") ("NAME") ("NO_COPY") ("OPACITY_TABLE0") ("OPACITY_TABLE1") ("RENDER_STEP") ("RGB_TABLE0") ("RGB_TABLE1") ("TWO_SIDED") ("UVALUE") ("VOLUME_SELECT") ("XCOORD_CONV") ("YCOORD_CONV") ("ZBUFFER") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")))
    ("GetCTM"                 fun "IDLgrVolume"       (system) "Result = Obj -> [%s::]%s()" (("DESTINATION") ("PATH") ("TOP")))
    ("Init"                   fun "IDLgrVolume"       (system) "Result = Obj -> [%s::]%s( [vol0 [, vol1 [, vol2 [, vol3]]]] ) ('IDLgrVolume' [, vol0 [, vol1 [, vol2 [, vol3]]]])" (("AMBIENT") ("BOUNDS") ("COMPOSITE_FUNCTION") ("CUTTING_PLANES") ("DATA0") ("DATA1") ("DATA2") ("DATA3") ("DEPTH_CUE") ("HIDE") ("HINTS") ("INTERPOLATE") ("LIGHTING_MODEL") ("NAME") ("NO_COPY") ("OPACITY_TABLE0") ("OPACITY_TABLE1") ("RENDER_STEP") ("RGB_TABLE0") ("RGB_TABLE1") ("TWO_SIDED") ("UVALUE") ("VOLUME_SELECT") ("XCOORD_CONV") ("YCOORD_CONV") ("ZBUFFER") ("ZCOORD_CONV") ("ZERO_OPACITY_SKIP")))
    ("PickVoxel"              fun "IDLgrVolume"       (system) "Result = Obj -> [%s::]%s ( Win, View, Point)" (("PATH")))
    ("Cleanup"                pro "IDLgrVRML"         (system) "Obj -> [%s::]%s" nil)
    ("Draw"                   pro "IDLgrVRML"         (system) "Obj -> [%s::]%s [, Picture]" nil)
    ("GetDeviceInfo"          pro "IDLgrVRML"         (system) "Obj->[%s::]%s" (("ALL") ("MAX_TEXTURE_DIMENSIONS") ("MAX_VIEWPORT_DIMENSIONS") ("NAME") ("NUM_CPUS") ("VENDOR") ("VERSION")))
    ("GetProperty"            pro "IDLgrVRML"         (system) "Obj -> [%s::]%s" (("ALL") ("COLOR_MODEL") ("DIMENSIONS") ("FILENAME") ("GRAPHICS_TREE") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("SCREEN_DIMENSIONS") ("UNITS") ("UVALUE")))
    ("SetProperty"            pro "IDLgrVRML"         (system) "Obj -> [%s::]%s" (("DIMENSIONS") ("FILENAME") ("GRAPHICS_TREE") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE")))
    ("GetFontnames"           fun "IDLgrVRML"         (system) "Return = Obj ->[%s::]%s( FamilyName)" (("IDL_FONTS") ("STYLES")))
    ("GetTextDimensions"      fun "IDLgrVRML"         (system) "Result = Obj ->[%s::]%s( TextObj)" (("DESCENT") ("PATH")))
    ("Init"                   fun "IDLgrVRML"         (system) "Result = Obj -> [%s::]%s( ) ('IDLgrVRML')" (("COLOR_MODEL") ("DIMENSIONS") ("FILENAME") ("GRAPHICS_TREE") ("N_COLORS") ("PALETTE") ("QUALITY") ("RESOLUTION") ("UNITS") ("UVALUE") ("WOLRDTITLE") ("WORLDINFO")))
    ("Cleanup"                pro "IDLgrWindow"       (system) "Obj -> [%s::]%s" nil)
    ("Draw"                   pro "IDLgrWindow"       (system) "Obj -> [%s::]%s [, Picture]" (("CREATE_INSTANCE") ("DRAW_INSTANCE")))
    ("Erase"                  pro "IDLgrWindow"       (system) "Obj -> [%s::]%s" (("COLOR")))
    ("GetDeviceInfo"          pro "IDLgrWindow"       (system) "Obj->[%s::]%s" (("ALL") ("MAX_TEXTURE_DIMENSIONS") ("MAX_VIEWPORT_DIMENSIONS") ("NAME") ("NUM_CPUS") ("VENDOR") ("VERSION")))
    ("GetProperty"            pro "IDLgrWindow"       (system) "Obj -> [%s::]%s" (("ALL") ("COLOR_MODEL") ("DIMENSIONS") ("DISPLAY_NAME") ("GRAPHICS_TREE") ("IMAGE_DATA") ("LOCATION") ("N_COLORS") ("PALETTE") ("QUALITY") ("RENDERER") ("RESOLUTION") ("RETAIN") ("SCREEN_DIMENSIONS") ("TITLE") ("UNITS") ("UVALUE") ("ZBUFFER_DATA")))
    ("Iconify"                pro "IDLgrWindow"       (system) "Obj -> [%s::]%s, IconFlag" nil)
    ("SetCurrentCursor"       pro "IDLgrWindow"       (system) "Obj-> [%s::]%s [, CursorName]" (("HOTSPOT") ("IMAGE") ("MASK") ("STANDARD")))
    ("SetProperty"            pro "IDLgrWindow"       (system) "Obj -> [%s::]%s" (("DIMENSIONS") ("GRAPHICS_TREE") ("LOCATION") ("PALETTE") ("QUALITY") ("TITLE") ("UNITS") ("UVALUE")))
    ("Show"                   pro "IDLgrWindow"       (system) "Obj -> [%s::]%s, Position" nil)
    ("GetContiguousPixels"    fun "IDLgrWindow"       (system) "Return = Obj -> [%s::]%s()" nil)
    ("GetFontnames"           fun "IDLgrWindow"       (system) "Return = Obj -> [%s::]%s(FamilyName)" (("IDL_FONTS") ("STYLES")))
    ("GetTextDimensions"      fun "IDLgrWindow"       (system) "Result = Obj ->[%s::]%s( TextObj)" (("DESCENT") ("PATH")))
    ("Init"                   fun "IDLgrWindow"       (system) "Result = Obj -> [%s::]%s( )" (("COLOR_MODEL") ("DIMENSIONS") ("DISPLAY_NAME") ("GRAPHICS_TREE") ("LOCATION") ("N_COLORS") ("PALETTE") ("QUALITY") ("RENDERER") ("RETAIN") ("TITLE") ("UNITS") ("UVALUE")))
    ("PickData"               fun "IDLgrWindow"       (system) "Result = Obj -> [%s::]%s( View, Object, Location, XYZLocation)" (("PATH")))
    ("Read"                   fun "IDLgrWindow"       (system) "Result = Obj -> [%s::]%s()" nil)
    ("Select"                 fun "IDLgrWindow"       (system) "Result = Obj -> [%s::]%s( Picture, XY)" (("DIMENSIONS") ("UNITS")))
    ("Reset"                  pro "TrackBall"         (system) "Obj -> [%s::]%s, Center, Radius" (("AXIS") ("CONSTRAIN") ("MOUSE")))
    ("Init"                   fun "TrackBall"         (system) "Result = Obj -> [%s::]%s( Center, Radius ) ('TrackBall', Center, Radius)" (("AXIS") ("CONSTRAIN") ("MOUSE")))
    ("Update"                 fun "TrackBall"         (system) "Result = Obj -> [%s::]%s( sEvent)" (("MOUSE") ("TRANSFORM") ("TRANSLATE")))
   )
  "1287 builtin routines with 5724 keywords for IDL version 5.4.")

(setq idlwave-system-variables-alist
  '(
    ("C")
    ("D" ("NAME") ("X_SIZE") ("Y_SIZE") ("X_VSIZE") ("Y_VSIZE") ("X_CH_SIZE") ("Y_CH_SIZE") ("X_PX_CM") ("Y_PX_CM") ("N_COLORS") ("TABLE_SIZE") ("FILL_DIST") ("WINDOW") ("UNIT") ("FLAGS") ("ORIGIN") ("ZOOM"))
    ("DIR")
    ("DLM_PATH")
    ("DPI")
    ("DTOR")
    ("EDIT_INPUT")
    ("ERROR_STATE" ("NAME") ("BLOCK") ("CODE") ("SYS_CODE") ("MSG") ("SYS_MSG") ("MSG_PREFIX"))
    ("EXCEPT")
    ("HELP_PATH")
    ("JOURNAL")
    ("MAKE_DLL" ("COMPILE_DIRECTORY") ("COMPILER_NAME") ("CC") ("LD"))
    ("MAP" ("PROJECTION") ("SIMPLE") ("FILL_METHOD") ("UP_FLAGS") ("UP_NAME") ("P0LON") ("P0LAT") ("U0") ("V0") ("SINO") ("COSO") ("ROTATION") ("SINR") ("COSR") ("UV") ("POLE") ("UV_BOX") ("LL_BOX") ("SEGMENT_LENGTH") ("P") ("PIPELINE"))
    ("MORE")
    ("MOUSE" ("X") ("Y") ("BUTTON") ("TIME"))
    ("ORDER")
    ("P" ("BACKGROUND") ("CHARSIZE") ("CHARTHICK") ("CLIP") ("COLOR") ("FONT") ("LINESTYLE") ("MULTI") ("NOCLIP") ("NOERASE") ("NSUM") ("POSITION") ("PSYM") ("REGION") ("SUBTITLE") ("SYMSIZE") ("T") ("T3D") ("THICK") ("TITLE") ("TICKLEN") ("CHANNEL"))
    ("PATH")
    ("PI")
    ("PROMPT")
    ("QUIET")
    ("RADEG")
    ("VALUES" ("F_INFINITY") ("F_NAN") ("D_INFINITY") ("D_NAN"))
    ("VERSION" ("ARCH") ("OS") ("OS_FAMILY") ("RELEASE") ("BUILD_DATE") ("MEMORY_BITS") ("FILE_OFFSET_BITS"))
    ("WARN" ("OBS_ROUTINES") ("OBS_SYSVARS") ("PARENS") ("TRUNCATED_FILENAME"))
    ("X" ("TITLE") ("TYPE") ("STYLE") ("TICKS") ("TICKLEN") ("THICK") ("RANGE") ("CRANGE") ("S") ("MARGIN") ("OMARGIN") ("WINDOW") ("REGION") ("CHARSIZE") ("MINOR") ("TICKV") ("TICKNAME") ("GRIDSTYLE") ("TICKFORMAT") ("TICKINTERVAL") ("TICKLAYOUT") ("TICKUNITS"))
    ("Y" ("TITLE") ("TYPE") ("STYLE") ("TICKS") ("TICKLEN") ("THICK") ("RANGE") ("CRANGE") ("S") ("MARGIN") ("OMARGIN") ("WINDOW") ("REGION") ("CHARSIZE") ("MINOR") ("TICKV") ("TICKNAME") ("GRIDSTYLE") ("TICKFORMAT") ("TICKINTERVAL") ("TICKLAYOUT") ("TICKUNITS"))
    ("Z" ("TITLE") ("TYPE") ("STYLE") ("TICKS") ("TICKLEN") ("THICK") ("RANGE") ("CRANGE") ("S") ("MARGIN") ("OMARGIN") ("WINDOW") ("REGION") ("CHARSIZE") ("MINOR") ("TICKV") ("TICKNAME") ("GRIDSTYLE") ("TICKFORMAT") ("TICKINTERVAL") ("TICKLAYOUT") ("TICKUNITS"))))


(setq idlwave-system-class-info
  '(
    ("IDLgrAxis"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRAXIS_TOP" "IDLGRAXISVERSION" "AM_PM" "AXIS_TYPE" "CALCFLAGS" "DAYS_OF_WEEK" "DIRECTION" "AXISFLAGS" "GRIDSTYLE" "LOCATION" "MAJOR" "MINOR" "MONTHS" "OUTRANGE" "RANGE" "SUBTICKLEN" "TEXTALIGNMENTS" "TEXTBASELINE" "TEXTUPDIR" "THICK" "TICKDIR" "TICKFORMAT" "ARRAY_TICKFORMAT" "TICKFRMTDATA" "TICKINTERVAL" "TICKLAYOUT" "TICKLEN" "TICKTEXT" "TICKUNITCODES" "TICKUNITS" "TICKVALUES" "TITLE" "CURRENT_LEVEL" "LEVEL_DATA" "STEPRANGEUNITS" "STEPRANGE")
     (inherits))
    ("IDLgrLegend"
     (tags "OSCALENODE" "BORDER_GAP" "COLUMNS" "OOUTLINE" "OFILL" "OFONT" "GAP" "GLYPHWIDTH" "PITEM_COLOR" "PITEM_LINESTYLE" "PITEM_NAME" "PITEM_OBJECT" "PITEM_THICK" "PITEM_TYPE" "OTITLE" "PTEXT_COLOR" "BRECOMPUTE" "PGLYPHS" "PTEXTS" "HGLYPHWIDTH" "VGLYPHWIDTH" "COLORMODE" "CLEANLEAVE" "CLEANGLYPHS" "IDLGRLEGENDVERSION")
     (inherits "IDLgrModel"))
    ("IDLgrContour"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRCONTOURTOP" "IDLGRCONTOURVERSION" "ANISOTROPY" "DATA_FORMAT" "DATA" "GEOM_FORMAT" "GEOM" "CONTOURFLAGS" "C_COLOR" "C_FILLPATTERN" "C_LINESTYLE" "C_THICK" "C_VALUE" "MAXVAL" "MINVAL" "NLEVELS" "POLYGONS" "SHADERANGE" "SHADING" "TICKINTERVAL" "TICKLEN" "PRECISIONDATA" "PRECISIONGEOM" "PRECISIONGRAPH" "LEVELINFO" "CFILL1" "IDLGRCONTOURBOTTOM")
     (inherits))
    ("IDLgrROI"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRROI_TOP" "IDLGRROIVERSION" "LINESTYLE" "STYLE" "SYMBOL" "THICK" "IDLGRROI_BOTTOM")
     (inherits "IDLanROI"))
    ("IDLgrSurface"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRSURFACETOP" "IDLGRSURFACEVERSION" "DATA" "PRECISION" "SKIRT" "VERTCOLORS" "BTMCOLOR" "SURFACEFLAGS" "LINESTYLE" "MAXVALUE" "MINVALUE" "SHADING" "SHADERANGE" "STYLE" "NORMALS" "TXTRCOORD" "TXTRMAP" "THICK" "IDLGRSURFACEBOTTOM")
     (inherits))
    ("IDLgrWindow"
     (tags "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "UVALUE" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRWINDOW_TOP" "IDLGRWINDOWVERSION" "WINDOWFLAGS" "DIMENSIONS" "DISPLAYNAME" "INDEX" "LOCATION" "RENDERER" "RETAIN" "SCREENDIMENSIONS" "SELF" "TITLE" "UNITS" "NEXT" "WFILL1" "PARENT" "WFILL2" "IDLGRWINDOW_BOTTOM")
     (inherits))
    ("IDLgrPolygon"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRPOLYGONTOP" "IDLGRPOLYGONVERSION" "DATA" "PRECISION" "FILLPATTERN" "POLYGONS" "NORMALS" "POLYGONFLAGS" "SHADING" "SHADERANGE" "STYLE" "TXTRCOORD" "TXTRMAP" "VERTCOLORS" "BTMCOLOR" "LINESTYLE" "THICK" "IDLGRPOLYGONBOTTOM")
     (inherits))
    ("IDLgrVolume"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRVOLUMETOP" "IDLGRVOLUMEVERSION" "AMBIENT" "BOUNDS" "LIMITS" "DIMENSIONS" "COLORTABLE" "COMPOSITEFUNC" "CUTPLANES" "NUMCUTPLANES" "DEPTH_CUE" "OPACITYTABLE" "RENDERSTEP" "DATA" "EDM_VOLUME" "VOLUMEFLAGS" "IDLGRVOLUMEBOTTOM")
     (inherits))
    ("IDLgrPlot"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRPLOT_TOP" "IDLGRPLOTVERSION" "DATA" "PLOTFLAGS" "LINESTYLE" "PRECISION" "MAXVAL" "MINVAL" "NSUM" "SYMBOL" "PSYMBOL" "THICK" "VERTCOLORS" "ZVALUE" "LINEDATA" "PFILL1" "IDLGRPLOT_BOTTOM")
     (inherits))
    ("IDLgrROIGroup"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRROIGROUP_TOP" "IDLGRROIGROUPVERSION" "IDLGRROI_BOTTOM")
     (inherits "IDLanROIGroup"))
    ("IDLgrColorbar"
     (tags "OCOORDCONVNODE" "OSCALENODE" "MAXDIM" "DIMENSIONS" "OAXIS" "OPOLY" "OSURF" "OIMAGE" "OPALETTE" "FREE_PALETTE" "SHOW_AXIS" "IDLGRCOLORBARVERSION")
     (inherits "IDLgrModel"))
    ("IDLgrText"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRTEXT_TOP" "IDLGRTEXTVERSION" "TEXTFLAGS" "ALIGNMENT" "BASELINE" "CHAR_DIMENSIONS" "RECOMP_CTM" "FONT" "LOCATIONS" "STRINGS" "SUBPARENT" "UPDIR" "VERTICAL_ALIGNMENT" "IDLGRTEXT_BOTTOM")
     (inherits))
    ("IDLgrPolyline"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRPOLYLINETOP" "IDLGRPOLYLINEVERSION" "DATA" "PRECISION" "LINESTYLE" "POLYLINES" "SYMBOL" "PSYMBOL" "THICK" "SHADING" "VERTCOLORS" "IDLGRPOLYLINEBOTTOM")
     (inherits))
    ("IDLgrView"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRVIEW_TOP" "IDLGRVIEWVERSION" "COLOR" "DEPTH_CUE" "DIMENSIONS" "PRECISION" "EYE" "LOCATION" "OBLIQUE" "PROJECTION" "TRANSPARENT" "UNITS" "VIEW" "ZCLIP" "IDLGRVIEW_BOTTOM")
     (inherits "IDL_Container"))
    ("IDLgrImage"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRIMAGE_TOP" "IDLGRIMAGEVERSION" "CHANNEL" "DATA" "DIMENSIONS" "SUB_RECT" "IMAGEFLAGS" "LOCATION" "INTERLEAVE" "INTERPOLATE" "BLEND_FUNCTIONS" "IDLGRIMAGE_BOTTOM")
     (inherits))
    ("IDLgrLight"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRGRAPHIC_TOP" "IDLGRGRAPHICVERSION" "COLOR" "GRAPHICFLAGS" "PALETTE" "XCOORD_CONV" "YCOORD_CONV" "ZCOORD_CONV" "XRANGE" "YRANGE" "ZRANGE" "GRAPHIC_DATA_OBJECT" "IDLGRGRAPHIC_BOTTOM" "IDLGRLIGHT_TOP" "IDLGRLIGHTVERSION" "ATTENUATION" "CONEANGLE" "DIRECTION" "FOCUS" "INTENSITY" "LOCATION" "TYPE" "IDLGRLIGHT_BOTTOM")
     (inherits))
    ("IDLgrClipboard"
     (tags "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "UVALUE" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRCLIPBOARDTOP" "IDLGRCLIPBOARDVERSION" "UNITS" "DIMENSIONS" "FILENAME" "VECTOR" "POSTSCRIPT" "IDLGRCLIPBOARDBOTTOM")
     (inherits))
    ("IDLgrVRML"
     (tags "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "UVALUE" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRVRMLTOP" "IDLGRVRMLVERSION" "UNITS" "DIMENSIONS" "FILENAME" "WORLDINFO" "WORLDTITLE" "IDLGRVRMLBOTTOM")
     (inherits))
    ("IDLgrPrinter"
     (tags "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "UVALUE" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRPRINTER_TOP" "IDLGRPRINTERVERSION" "PRINTERFLAGS" "NAME" "NCOPIES" "UNITS" "GAMMA" "IDLGRPRINTER_BOTTOM")
     (inherits))
    ("IDLgrBuffer"
     (tags "IDLGRSRCDEST_TOP" "IDLGRSRCDESTVERSION" "CLIENTDIMENSIONS" "COLORMODEL" "SRCDESTFLAGS" "GRAPHICS_TREE" "NCOLORS" "PALETTE" "QUALITY" "RESOLUTION" "UVALUE" "DIST" "FILL1" "DEV" "FILL2" "ATTRS" "FILL3" "CACHES" "FILL4" "IDLGRSRCDEST_BOTTOM" "IDLGRBUFFERTOP" "IDLGRBUFFERVERSION" "UNITS" "DIMENSIONS" "IDLGRBUFFERBOTTOM")
     (inherits))
    ("IDLgrModel"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRMODEL_TOP" "IDLGRMODELVERSION" "MODELFLAGS" "TRANSFORM" "IDLGRMODEL_BOTTOM")
     (inherits "IDL_Container"))
    ("IDLgrScene"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRSCENE_TOP" "IDLGRSCENEVERSION" "COLOR" "TRANSPARENT" "IDLGRSCENE_BOTTOM")
     (inherits "IDL_Container"))
    ("IDLgrMPEG"
     (tags "IDLGRMPEG_TOP" "IDLGRMPEGVERSION" "DIMENSIONS" "FILENAME" "FORMAT" "FRAMERATE" "INTERLACED" "QUALITY" "SCALE" "STATISTICS" "DISPLAYDIMS" "FIRSTFRAME" "LASTFRAME" "MPEGID" "TEMPNODE" "TEMPNODEFILLER" "TEMP_DIRECTORY" "BITRATE" "IFRAME_GAP" "MOTION_LENGTH" "FLAGS" "IDLGRMPEG_BOTTOM")
     (inherits))
    ("IDLgrViewgroup"
     (tags "IDLGRCOMPONENT_TOP" "IDLGRCOMPONENTVERSION" "HIDE" "NAME" "PARENT" "UVALUE" "IDLGRCOMPONENT_BOTTOM" "IDLGRCONTAINER_TOP" "IDLGRCONTAINERVERSION" "ISDYING" "IDLGRCONTAINER_BOTTOM" "IDLGRVIEWGROUPTOP" "IDLGRVIEWGROUPVERSION" "IDLGRVIEWGROUPBOTTOM")
     (inherits "IDL_Container"))
    ("IDLdbRecordset"
     (tags "DTOPPAD" "IDLDBRECORDSETVERSION" "ISTABLE" "PDBOBJ" "ISREADONLY" "NFIELDS" "CURROW" "SOURCE" "CURSORTYPE" "PFIELDS" "PSDEF" "ROWSTATUS" "ROWSET" "ROWPOS" "HSTMT" "HDBC" "DBOTTOMPAD")
     (inherits))
    ("IDLdbDatabase"
     (tags "DTOPPAD" "IDLDBDATABASEVERSION" "READONLY" "ISCONNECTED" "FETCHDIR" "POSOPS" "POSSTATEMENTS" "SCROLLCONCUR" "SCROLLOPTIONS" "STATICSENSE" "GETDATAEXT" "USINGCURSOR" "NSTATEMENTS" "P_RECOBJS" "HDBC" "DBOTTOMPAD")
     (inherits))
    ("IDLanROI"
     (tags "IDLANROI_TOP" "IDLANROIVERSION" "IDLANROIFLAGS" "NALLOCVERTS" "NUSEDVERTS" "BLOCKSIZE" "DATA" "TYPE" "PRECISION" "PLANE" "ROI_XRANGE" "ROI_YRANGE" "ROI_ZRANGE" "IDLANROI_BOTTOM")
     (inherits))
    ("IDLanROIGroup"
     (tags "IDLANROIGROUP_TOP" "IDLANROIGROUPVERSION" "IDLANROIGROUPFLAGS" "ROIGROUP_XRANGE" "ROIGROUP_YRANGE" "ROIGROUP_ZRANGE" "IDLANROIGROUP_BOTTOM")
     (inherits "IDL_Container"))
    ("IDLgrPalette"
     (tags "IDLGRPALETTE_SERIALNUM" "IDLGRPALETTEVERSION" "GAMMA" "BOTTOMSTRETCH" "TOPSTRETCH" "NENTRIES" "ORIGLUT" "CURRLUT" "INVTABLE" "UVALUE" "NAME" "IDLGRPALETTE_BOTTOM")
     (inherits))
    ("IDLgrFont"
     (tags "IDLGRFONT_TOP" "IDLGRFONTVERSION" "FONTFLAGS" "HERSHEY" "NAME" "SIZE" "SUBSTITUTE" "THICK" "ID" "UVALUE" "IDLGRFONT_BOTTOM")
     (inherits))
    ("IDLgrSymbol"
     (tags "IDLGRSYMBOLTOP" "IDLGRSYMBOLVERSION" "COLOR" "DATA" "SIZE" "THICK" "FLAGS" "UVALUE" "NAME" "IDLGRSYMBOLBOTTOM")
     (inherits))
    ("IDLgrPattern"
     (tags "IDLGRPATTERN_TOP" "IDLGRPATTERNVERSION" "ORIENTATION" "PATTERN" "SPACING" "STYLE" "THICK" "UVALUE" "NAME" "IDLGRPATTERN_BOTTOM")
     (inherits))
    ("IDLffShape"
     (tags "IDLFFSHAPE_TOP" "IDLFFSHAPEVERSION" "FILENAME" "ISOPEN" "SHPTYPE" "PATTRIBUTE" "SHAPEHANDLE" "DBFHANDLE" "IDLFFSHAPE_BOTTOM")
     (inherits))
    ("TrackBall"
     (tags "BTNDOWN" "AXIS" "CONSTRAIN" "MOUSE" "CENTER" "RADIUS" "PT0" "PT1")
     (inherits))
    ("IDLffDXF"
     (tags "IDLFFDXF_TOP" "IDLFFDXFVERSION" "DXFREADVALID" "DXFHANDLEVALID" "DXFLUT" "DXFHANDLE" "DXFHANDLEFILLER" "IDLFFDXF_BOTTOM")
     (inherits))
    ("IDLffDICOM"
     (tags "IDLFFDICOM_TOP" "IDLFFDICOMVERSION" "DICOMFLAGS" "DICOMELEMENTS" "DICOMPREAMBLE" "DICOMHANDLE" "DICOMHANDLEFILLER" "IDLFFDICOM_BOTTOM")
     (inherits))
    ("IDLgrTessellator"
     (tags "IDLGRTESSELLATORTOP" "IDLGRTESSELLATORVERSION" "ITESSFLAGS" "IVERTS" "HVIDLIST" "IDLGRTESSELLATORBOTTOM")
     (inherits))
    ("IDL_Container"
     (tags "IDL_CONTAINER_TOP" "IDLCONTAINERVERSION" "PHEAD" "PTAIL" "NLIST" "IDL_CONTAINER_BOTTOM")
     (inherits))))

(provide 'idlw-rinfo)
(provide 'idlwave-rinfo)

;;; idlw-rinfo.el ends here
