/**
 * @file slp.h MSNSLP support
 *
 * gaim
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _MSN_SLP_H_
#define _MSN_SLP_H_

#define DEBUG_SLP 1
/* #define DEBUG_SLP_FILES 1 */

#include "slpcall.h"

#include "ft.h"

void msn_xfer_progress_cb(MsnSlpCall *slpcall, gsize total_length, gsize
						  len, gsize offset);

MsnSlpCall * msn_slp_sip_recv(MsnSlpLink *slplink,
							  const char *body, gsize len);

void send_bye(MsnSlpCall *slpcall, const char *type);

void msn_xfer_finish_cb(MsnSlpCall *slpcall,
						const char *body, long long size);

void msn_xfer_cancel(GaimXfer *xfer);

#endif /* _MSN_SLP_H_ */
