
var sUri 	= null;
var oTitle	= null;
var oTiny	= null;

// Load Data
function tinyurl_edit_load(){
	var aProps	= new Array();
	
	if(window.arguments.length > 0)
		sUri = window.arguments[0];
	else
		return;
		
	aProps 	= opener.tinyurl_saved_getEntry(sUri);
	oTitle	= document.getElementById("title-field");
	oTitle.value = aProps["title"];
	
	oTiny	= document.getElementById("tinyurl-label")
	oTiny.value = aProps["tinyurl"];
	
	document.getElementById("real-field").value = aProps["realurl"];
	
	var sIcon = opener.tinyurl_saved_getFavIcon(aProps["realurl"]);
	if(sIcon != "")
		document.getElementById("icon-image").setAttribute("src", sIcon);
	
}

// Save New Title
function tinyurl_edit_save(){
	
	try{
		// Verify not empty
		if(oTitle.value == ""){
			alert("You must enter a title.");
			oTitle.focus();
			return false;
		}
		
		// Verify not duplicate
		var sTitleUri = opener.tinyurl_saved_getUriForTitle(oTitle.value);
		if(sTitleUri != null && sTitleUri != sUri){
			alert("A TinyUrl entry already exists with that title.");
			oTitle.focus();
			return false;
		}
		
		// Update
		opener.tinyurl_saved_changeTitle(sUri, oTitle.value);
		opener.tinyurl_saved_read();
		
	}catch(err){ alert("Could not update this entry due to an unknown error.\n"+ err); return false; }
	
	return true;
}

// Open TinyUrl
function tinyurl_edit_open(){

	if(oTiny.value == "")
		return;
	
	if(opener && opener.opener){
		opener.opener.gBrowser.selectedTab = opener.opener.gBrowser.addTab(oTiny.value);
	}
	else{
		window.open(oTiny.value);
	}
		
	setTimeout("self.focus()", 100);
}
